/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.hardware.Camera;
import com.justalk.cloud.zmf.CaptureInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeviceFilter {
    private static Set<PreviewSize> sExcluePreviewSizes = new HashSet<PreviewSize>();
    private static List<CaptureInfo> sOverrideCameraInfo = new ArrayList<CaptureInfo>();

    public static void avoidPreviewSize(int n, int n2) {
        sExcluePreviewSizes.add(new PreviewSize(n, n2));
    }

    public static void overrideCameraInfo(int n, Camera.CameraInfo cameraInfo) {
        while (sOverrideCameraInfo.size() <= n) {
            sOverrideCameraInfo.add(null);
        }
        sOverrideCameraInfo.set(n, new CaptureInfo(cameraInfo));
    }

    static List<Camera.Size> filterPreviewSizes(List<Camera.Size> list) {
        PreviewSize previewSize = new PreviewSize(0, 0);
        ArrayList<Camera.Size> arrayList = new ArrayList<Camera.Size>();
        for (Camera.Size size : list) {
            previewSize.width = size.width;
            previewSize.height = size.height;
            if (sExcluePreviewSizes.contains(previewSize)) continue;
            arrayList.add(size);
        }
        return arrayList;
    }

    static final CaptureInfo getCameraInfo(int n) {
        CaptureInfo captureInfo = null;
        if (n < sOverrideCameraInfo.size()) {
            captureInfo = sOverrideCameraInfo.get(n);
        }
        if (captureInfo != null) {
            if (!captureInfo.override) {
                Camera.getCameraInfo((int)n, (Camera.CameraInfo)captureInfo);
            }
            return captureInfo;
        }
        while (sOverrideCameraInfo.size() <= n) {
            sOverrideCameraInfo.add(null);
        }
        captureInfo = new CaptureInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)captureInfo);
        sOverrideCameraInfo.set(n, captureInfo);
        return captureInfo;
    }

    private static final class PreviewSize {
        int width;
        int height;

        PreviewSize(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public boolean equals(Object object) {
            PreviewSize previewSize = (PreviewSize)object;
            return previewSize.width == this.width && previewSize.height == this.height;
        }

        public int hashCode() {
            return this.height << 16 | this.width;
        }
    }
}

