package com.juphoon.cloud;

import android.support.annotation.IntDef;
import android.text.TextUtils;

import com.justalk.cloud.lemon.MtcBuddyConstants;
import com.justalk.cloud.lemon.MtcCall;
import com.justalk.cloud.lemon.MtcCallConstants;
import com.justalk.cloud.lemon.MtcCallExt;
import com.justalk.cloud.lemon.MtcCliConstants;
import com.justalk.cloud.lemon.MtcConf;
import com.justalk.cloud.lemon.MtcConfConstants;
import com.justalk.cloud.lemon.MtcFs2Constants;
import com.justalk.cloud.lemon.MtcFsConstants;
import com.justalk.cloud.lemon.MtcGroupConstants;
import com.justalk.cloud.lemon.MtcImConstants;
import com.justalk.cloud.lemon.MtcSgwConstants;
import com.justalk.cloud.lemon.MtcUe;
import com.justalk.cloud.lemon.MtcUser;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class JCNotify {

    /************* Storage *************/

    @IntDef({STORAGE_NONE, STORAGE_PROGRESS, STORAGE_SEND_OK, STORAGE_SEND_FAIL,
            STORAGE_RECV_OK, STORAGE_RECV_FAIL})
    @Retention(RetentionPolicy.SOURCE)
    @interface StorageType {
    }

    /**
     * 无
     */
    static final int STORAGE_NONE = 0;
    /**
     * 进度
     */
    public static final int STORAGE_PROGRESS = 1;
    /**
     * 发送成功
     */
    public static final int STORAGE_SEND_OK = 2;
    /**
     * 发送失败
     */
    public static final int STORAGE_SEND_FAIL = 3;
    /**
     * 接收成功
     */
    public static final int STORAGE_RECV_OK = 4;
    /**
     * 接收失败
     */
    public static final int STORAGE_RECV_FAIL = 5;

    public class Storage implements MtcFs2Constants, MtcFsConstants {

        public class Progress {
            public int progress;
        }

        public class SendOk {
            public String uri;
        }

        public class SendFail {
            public int statusCode;
        }

        public class RecvOk {

        }

        public class RecvFail {
            public int statusCode;
        }

        @StorageType
        public int type;
        public Progress storageProgress;
        public SendOk sendOk;
        public SendFail sendFail;
        public RecvOk recvOk;
        public RecvFail recvFail;

        public Storage(String name, String info) {
            type = STORAGE_NONE;
            try {
                JSONObject object = new JSONObject(TextUtils.isEmpty(info) ? "{}" : info);
                /** 发送进度 */
                if (TextUtils.equals(name, MtcFs2UploadProgressNotification)) {
                    type = STORAGE_PROGRESS;
                    storageProgress = new Progress();
                    storageProgress.progress = object.optInt(MtcFsProgressKey);
                }
                /** 发送成功  */
                else if (TextUtils.equals(name, MtcFs2UploadOkNotification)) {
                    type = STORAGE_SEND_OK;
                    sendOk = new SendOk();
                    sendOk.uri = object.optString(MtcFsLinkUriKey);
                }
                /** 发送失败  */
                else if (TextUtils.equals(name, MtcFs2UploadDidFailNotification)) {
                    type = STORAGE_SEND_FAIL;
                    sendFail = new SendFail();
                    sendFail.statusCode = object.optInt(MtcFsStatusCodeKey);
                }
                /** 接收进度 */
                if (TextUtils.equals(name, MtcFs2DownloadProgressNotification)) {
                    type = STORAGE_PROGRESS;
                    storageProgress = new Progress();
                    storageProgress.progress = object.optInt(MtcFsProgressKey);
                }
                /** 接收成功  */
                else if (TextUtils.equals(name, MtcFs2DownloadOkNotification)) {
                    type = STORAGE_RECV_OK;
                    recvOk = new RecvOk();
                }
                /** 接收失败  */
                else if (TextUtils.equals(name, MtcFs2DownloadDidFailNotification)) {
                    type = STORAGE_RECV_FAIL;
                    recvFail = new RecvFail();
                    recvFail.statusCode = object.optInt(MtcFsStatusCodeKey);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }


    /************* Im *************/

    @IntDef({MESSAGE_NONE, MESSAGE_SEND_OK, MESSAGE_SEND_FAIL, MESSAGE_RECV_MESSAGE})
    @Retention(RetentionPolicy.SOURCE)
    @interface MessageType {
    }

    /**
     * 无
     */
    public static final int MESSAGE_NONE = 0;
    /**
     * 发送成功
     */
    public static final int MESSAGE_SEND_OK = 1;
    /**
     * 发送失败
     */
    public static final int MESSAGE_SEND_FAIL = 2;
    /**
     * 收到消息
     */
    public static final int MESSAGE_RECV_MESSAGE = 3;

    public class Message implements MtcImConstants {

        public class SendOk {
        }

        public class SendFail {
        }

        public class Recv {
            public String userId;
            public String groupId;
            public long time;
            public int category;
            public String messageType;
            public String messageContent;
            public String displayName;
            public String messageInfo;
            public String messageLabel;
            public long messageId;
        }

        public
        @MessageType
        int type;
        public SendOk sendOk;
        public SendFail sendFail;
        public Recv recvMessage;

        public Message(String name, String info) {
            type = MESSAGE_NONE;
            try {
                JSONObject object = new JSONObject(TextUtils.isEmpty(info) ? "{}" : info);
                /** 发送成功 */
                if (TextUtils.equals(name, MtcImSendInfoOkNotification)) {
                    type = MESSAGE_SEND_OK;
                    sendOk = new SendOk();
                }
                /** 发送失败 */
                else if (TextUtils.equals(name, MtcImSendInfoDidFailNotification)) {
                    type = MESSAGE_SEND_FAIL;
                    sendFail = new SendFail();
                }
                /** 收到消息 */
                else if (TextUtils.equals(name, MtcImInfoDidReceiveNotification)) {
                    type = MESSAGE_RECV_MESSAGE;
                    recvMessage = new Recv();
                    recvMessage.userId = MtcUser.Mtc_UserGetId(object.optString(MtcImUserUriKey));
                    recvMessage.messageContent = object.optString(MtcImInfoContentKey);
                    recvMessage.time = object.optLong(MtcImTimeKey);
                    recvMessage.displayName = object.optString(MtcImDisplayNameKey);
                    recvMessage.messageType = object.optString(MtcImInfoTypeKey);
                    recvMessage.messageInfo = object.optString(MtcImUserDataKey);
                    recvMessage.category = object.optInt(MtcImCategoryKey);
                    recvMessage.groupId = recvMessage.category == MTC_IM_ID_GROUP ? object.optString(MtcImLabelKey) : null;
                    recvMessage.messageLabel = object.optString(MtcImLabelKey);
                    recvMessage.messageId = object.optLong(MtcImMsgIdKey);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    /************* Conf *************/

    @IntDef({CONF_NONE, CONF_JOIN_OK, CONF_JOIN_FAIL, CONF_LEAVE, CONF_QUERY_OK, CONF_QUERY_FAIL, CONF_ADD_PARTICIPANT
            , CONF_REMOVE_PARTICIPANT, CONF_PARTICIPANT_CNANGED, CONF_VOLUME_CHANGED, CONF_ERROR_EVENT, CONF_PROP_CNANGED})
    @Retention(RetentionPolicy.SOURCE)
    @interface ConfType {
    }

    /**
     * 无
     */
    public static final int CONF_NONE = 0;
    /**
     * 加入成功
     */
    public static final int CONF_JOIN_OK = 1;
    /**
     * 加入失败
     */
    public static final int CONF_JOIN_FAIL = 2;
    /**
     * 离开
     */
    public static final int CONF_LEAVE = 3;
    /**
     * 查询成功
     */
    public static final int CONF_QUERY_OK = 4;
    /**
     * 查询失败
     */
    public static final int CONF_QUERY_FAIL = 5;
    /**
     * 成员加入
     */
    public static final int CONF_ADD_PARTICIPANT = 6;
    /**
     * 成员离开
     */
    public static final int CONF_REMOVE_PARTICIPANT = 7;
    /**
     * 成员更新
     */
    public static final int CONF_PARTICIPANT_CNANGED = 8;
    /**
     * 成员音量更新
     */
    public static final int CONF_VOLUME_CHANGED = 9;
    /**
     * 错误事件
     */
    public static final int CONF_ERROR_EVENT = 10;
    /**
     * 属性变化事件
     */
    public static final int CONF_PROP_CNANGED = 11;
    /**
     * 收到消息事件
     */
    public static final int CONF_MESSAGE_RECEIVED = 12;
    /**
     * sip邀请成功
     */
    public static final int CONF_SIP_INVITE_OK = 13;
    /**
     * sip邀请失败
     */
    public static final int CONF_SIP_INVITE_FAIL = 14;

    /**
     * 解散频道成功
     */
    public static final int CONF_CANCEL_RESERVATION_Ok = 15;

    /**
     * 解散频道失败
     */
    public static final int CONF_CANCEL_RESERVATION_FAIL = 16;


    public class Conf implements MtcConfConstants, MtcSgwConstants {
        public class Region {
            public int rid;
            public String name;
            public String desc;
        }

        public class Partp {
            public String userId;
            public String uri;
            public String displayName;
            public int state;
            public int role;
            public String screenRenderId;
        }

        public class JoinOk {
            public int confId;
            public int number;
            public int viewMode;
            public int qualityGrade;
            public boolean videoSquare;
            public String title;
            public String deliveryUri;
            public String screenUserUri;
            public String screenUserId;
            public String screenRenderId;
            public Region region;
            public String data;
            public List<Partp> partps;
            public Map<String, String> customProperty = new HashMap<>();
        }

        public class JoinFail {
            public int confId;
            public int number;
            public int event;
            public int reason;
        }

        public class Leave {
            public int confId;
            public int number;
            public int event;
            public int reason;
        }

        public class Stop {
            public int number;
            public int reason;
            public String reasonDescription;
        }

        public class QueryOk {
            public int number;
            public int capacity;
            public String title;
            public boolean video;
            public Region region;
            public int clientCount;
            public List<String> mMembers = new ArrayList<>();
        }

        public class QueryFail {
            public int reason;
            public String detailReason;
        }

        public class AddParticipant {
            public int confId;
            public int number;
            public Partp partp;
        }

        public class RemoveParticipant {
            public int confId;
            public int number;
            public Partp partp;
        }

        public class ParticipantChanged {
            public int confId;
            public int number;
            public String uri;
            public String userId;
            public int state;
            public int role;
            public String displayName;
        }

        public class VolumeChanged {
            public int confId;
            public int number;
            public Map<String, Integer> mapVolume;
        }

        public class ErrorEvent {
            public int confId;
            public int number;
            public int event;
            public int reason;
        }

        public class PropChange {
            public int confId;
            public int number;
            public String title;
            public String screenUserUri;
            public String screenUserId;
            public String screenRenderId;
            public Map<String, String> customProperty = new HashMap<>();
        }

        public class MessageReceived
        {
            public int confId;
            public String type;
            public String fromUserId;
            public String content;
        }

        public
        @ConfType
        int type;
        public JoinOk joinOk;
        public JoinFail joinFail;
        public Leave leave;
        public Stop stop;
        public QueryOk queryOk;
        public QueryFail queryFail;
        public AddParticipant addParticipant;
        public RemoveParticipant removeParticipant;
        public ParticipantChanged participantChanged;
        public VolumeChanged volumeChanged;
        public ErrorEvent errorEvent;
        public PropChange propChange;
        public MessageReceived messageReceived;

        public Conf(String name, String info) {
            type = CONF_NONE;
            try {
                JSONObject object = new JSONObject(TextUtils.isEmpty(info) ? "{}" : info);
                /** 查询成功 */
                if (TextUtils.equals(name, MtcConfQueryOkNotification)) {
                    type = CONF_QUERY_OK;
                    queryOk = new QueryOk();
                    queryOk.number = object.optInt(MtcConfNumberKey);
                    queryOk.capacity = object.optInt(MtcConfCapacityKey);
                    queryOk.title = object.optString(MtcConfTitleKey);
                    queryOk.video = object.optBoolean(MtcConfIsVideoKey);
                    queryOk.region = new Region();
                    queryOk.region.rid = object.optInt(MtcRegionIdKey);
                    queryOk.region.name = object.optString(MtcRegionNameKey);
                    queryOk.region.desc = object.optString(MtcRegionDescKey);
                    queryOk.clientCount = object.optInt(MtcConfClientCountKey);
                    JSONArray memberArray = object.getJSONArray(MtcConfMemberListKey);
                    for (int i = 0; i < memberArray.length(); i++) {
                        queryOk.mMembers.add(MtcUser.Mtc_UserGetId(memberArray.getString(i)));
                    }
                }
                /** 查询失败 */
                else if (TextUtils.equals(name, MtcConfQueryDidFailNotification)) {
                    type = CONF_QUERY_FAIL;
                    queryFail = new QueryFail();
                    queryFail.reason = object.optInt(MtcConfReasonKey);
                    queryFail.detailReason = object.optString(MtcConfDetailReasonKey);
                }
                /** 加入成功 */
                else if (TextUtils.equals(name, MtcConfJoinOkNotification)) {
                    type = CONF_JOIN_OK;
                    joinOk = new JoinOk();
                    joinOk.confId = object.optInt(MtcConfIdKey);
                    joinOk.number = object.optInt(MtcConfNumberKey);
                    joinOk.viewMode = object.optInt(MtcConfViewModeKey);
                    joinOk.qualityGrade = object.optInt(MtcConfQualityGradeKey);
                    joinOk.videoSquare = object.optBoolean(MtcConfVideoSquareKey);
                    joinOk.title = object.optString(MtcConfTitleKey);
                    joinOk.screenUserUri = object.optString(MtcConfScreenUserKey);
                    if (!TextUtils.isEmpty(joinOk.screenUserUri)) {
                        joinOk.screenUserId = MtcUser.Mtc_UserGetId(joinOk.screenUserUri);
                        joinOk.screenRenderId = MtcConf.Mtc_ConfGetProp(joinOk.confId, MtcConfPropScreenUri);
                    }
                    joinOk.region = new Region();
                    joinOk.region.rid = object.optInt(MtcRegionIdKey);
                    joinOk.region.name = object.optString(MtcRegionNameKey);
                    joinOk.region.desc = object.optString(MtcRegionDescKey);
                    joinOk.data = object.optString(MtcConfDataKey);
                    joinOk.partps = new ArrayList<>();
                    joinOk.deliveryUri = MtcConf.Mtc_ConfGetProp(joinOk.confId, MtcConfPropDeliveryUri);
                    JSONArray partpArray = object.getJSONArray(MtcConfPartpLstKey);
                    for (int i = 0; i < partpArray.length(); i++) {
                        JSONObject subObject = partpArray.getJSONObject(i);
                        Partp partp = new Partp();
                        partp.uri = subObject.optString(MtcConfUserUriKey);
                        partp.userId = MtcUser.Mtc_UserGetId(partp.uri);
                        partp.displayName = subObject.optString(MtcConfDisplayNameKey);
                        partp.state = subObject.optInt(MtcConfStateKey);
                        partp.role = subObject.optInt(MtcConfRoleKey);
                        if (TextUtils.equals(partp.displayName, partp.uri)) {
                            partp.displayName = partp.userId;
                        }
                        joinOk.partps.add(partp);
                    }
                    try {
                        String propData = object.getString(MtcConfPropUserDefined);
                        JSONObject props = new JSONObject(propData);
                        Iterator<String> iterator = props.keys();
                        while(iterator.hasNext()){
                            String key = iterator.next();
                            joinOk.customProperty.put(key, (String)props.get(key));
                        }
                    } catch (JSONException e) {

                    }
                }
                /** 加入失败 */
                else if (TextUtils.equals(name, MtcConfJoinDidFailNotification)) {
                    type = CONF_JOIN_FAIL;
                    joinFail = new JoinFail();
                    joinFail.confId = object.optInt(MtcConfIdKey);
                    joinFail.number = object.optInt(MtcConfNumberKey);
                    joinFail.event = object.optInt(MtcConfEventKey);
                    joinFail.reason = object.optInt(MtcConfReasonKey);
                }
                /** 成员加入 */
                else if (TextUtils.equals(name, MtcConfJoinedNotification)) {
                    type = CONF_ADD_PARTICIPANT;
                    addParticipant = new AddParticipant();
                    addParticipant.partp = new Partp();
                    addParticipant.confId = object.optInt(MtcConfIdKey);
                    addParticipant.number = object.optInt(MtcConfNumberKey);
                    addParticipant.partp.uri = object.optString(MtcConfUserUriKey);
                    addParticipant.partp.userId = MtcUser.Mtc_UserGetId(addParticipant.partp.uri);
                    addParticipant.partp.displayName = object.optString(MtcConfDisplayNameKey);
                    addParticipant.partp.state = object.optInt(MtcConfStateKey);
                    addParticipant.partp.role = object.optInt(MtcConfRoleKey);
                    if (TextUtils.equals(addParticipant.partp.displayName, addParticipant.partp.uri)) {
                        addParticipant.partp.displayName = addParticipant.partp.userId;
                    }
                }
                /** 离开 */
                else if (TextUtils.equals(name, MtcConfDidLeaveNotification)) {
                    type = CONF_LEAVE;
                    leave = new Leave();
                    leave.confId = object.optInt(MtcConfIdKey);
                    leave.number = object.optInt(MtcConfNumberKey);
                    leave.event = object.optInt(MtcConfEventKey);
                    leave.reason = object.optInt(MtcConfReasonKey);
                }
                /** 频道解散成功 **/
                else if (TextUtils.equals(name, MtcConfCancelReservationOkNotification)) {
                    type = CONF_CANCEL_RESERVATION_Ok;
                    stop = new Stop();
                    stop.number = object.optInt(MtcConfNumberKey);
                }
                /** 频道解散失败 **/
                else if (TextUtils.equals(name, MtcConfCancelReservationDidFailNotification)) {
                    type = CONF_CANCEL_RESERVATION_FAIL;
                    stop = new Stop();
                    stop.number = object.optInt(MtcConfNumberKey);
                    stop.reason = object.optInt(MtcConfReasonKey);
                    stop.reasonDescription = object.optString(MtcConfDetailReasonKey);
                }
                /** 成员离开 */
                else if (TextUtils.equals(name, MtcConfLeavedNotification)) {
                    type = CONF_REMOVE_PARTICIPANT;
                    removeParticipant = new RemoveParticipant();
                    removeParticipant.partp = new Partp();
                    removeParticipant.confId = object.optInt(MtcConfIdKey);
                    removeParticipant.number = object.optInt(MtcConfNumberKey);
                    removeParticipant.partp.uri = object.optString(MtcConfUserUriKey);
                    removeParticipant.partp.userId = MtcUser.Mtc_UserGetId(removeParticipant.partp.uri);
                }
                /** 成员更新 */
                else if (TextUtils.equals(name, MtcConfParticipantChangedNotification)) {
                    type = CONF_PARTICIPANT_CNANGED;
                    participantChanged = new ParticipantChanged();
                    participantChanged.confId = object.optInt(MtcConfIdKey);
                    participantChanged.number = object.optInt(MtcConfNumberKey);
                    participantChanged.uri = object.optString(MtcConfUserUriKey);
                    participantChanged.userId = MtcUser.Mtc_UserGetId(participantChanged.uri);
                    participantChanged.displayName = object.optString(MtcConfDisplayNameKey);
                    participantChanged.state = object.optInt(MtcConfStateKey);
                    participantChanged.role = object.optInt(MtcConfRoleKey);
                    if (TextUtils.equals(participantChanged.displayName, participantChanged.uri)) {
                        participantChanged.displayName = participantChanged.userId;
                    }
                }
                /** 音量更新 */
                else if (TextUtils.equals(name, MtcConfVolumeChangedNotification)) {
                    type = CONF_VOLUME_CHANGED;
                    volumeChanged = new VolumeChanged();
                    volumeChanged.confId = object.optInt(MtcConfIdKey);
                    volumeChanged.number = object.optInt(MtcConfNumberKey);
                    volumeChanged.mapVolume = new HashMap<>();
                    JSONArray volumeArray = object.optJSONArray(MtcConfPartpVolumeLstKey);
                    for (int i = 0; i < volumeArray.length(); i++) {
                        JSONObject subObject = volumeArray.getJSONObject(i);
                        volumeChanged.mapVolume.put(MtcUser.Mtc_UserGetId(subObject.optString(MtcConfUserUriKey)),
                                subObject.optInt(MtcConfVolumeKey));
                    }
                }
                /** 错误事件 */
                else if (TextUtils.equals(name, MtcConfErrorNotification)) {
                    type = CONF_ERROR_EVENT;
                    errorEvent = new ErrorEvent();
                    errorEvent.confId = object.optInt(MtcConfIdKey);
                    errorEvent.number = object.optInt(MtcConfNumberKey);
                    errorEvent.event = object.optInt(MtcConfEventKey);
                    errorEvent.reason = object.optInt(MtcConfReasonKey);
                }
                /** 会议属性变化 */
                else if (TextUtils.equals(name, MtcConfPropertyChangedNotfication)) {
                    type = CONF_PROP_CNANGED;
                    propChange = new PropChange();
                    propChange.confId = object.optInt(MtcConfIdKey);
                    propChange.number = object.optInt(MtcConfNumberKey);
                    propChange.title = object.optString(MtcConfTitleKey);
                    propChange.screenUserUri = object.optString(MtcConfScreenUserKey);
                    if (!TextUtils.isEmpty(propChange.screenUserUri)) {
                        propChange.screenUserId = MtcUser.Mtc_UserGetId(propChange.screenUserUri);
                        propChange.screenRenderId = MtcConf.Mtc_ConfGetProp(propChange.confId, MtcConfPropScreenUri);
                    }
                    try {
                        String propData = object.getString(MtcConfPropUserDefined);
                        JSONObject props = new JSONObject(propData);
                        Iterator<String> iterator = props.keys();
                        while(iterator.hasNext()){
                            String key = iterator.next();
                            propChange.customProperty.put(key, (String)props.get(key));
                        }
                    } catch (JSONException e) {

                    }
                }
                /** 收到消息 */
                else if (TextUtils.equals(name, MtcConfDataReceivedNotification)
                            || TextUtils.equals(name, MtcConfBypassDataReceivedNotification)
                            || TextUtils.equals(name, MtcConfTextReceivedNotification)) {
                    type = CONF_MESSAGE_RECEIVED;
                    messageReceived = new MessageReceived();
                    messageReceived.confId = object.optInt(MtcConfIdKey);
                    if (TextUtils.equals(name, MtcConfTextReceivedNotification)) {
                        messageReceived.type = "text";
                        messageReceived.fromUserId = MtcUser.Mtc_UserGetId(object.optString(MtcConfUserUriKey));
                        messageReceived.content = object.optString(MtcConfTextKey);
                    } else {
                        messageReceived.type = object.optString(MtcConfDataTypeKey);
                        messageReceived.content = object.optString(MtcConfDataContentKey);
                    }
                }
                /** sip邀请发送成功 */
                else if (TextUtils.equals(name, MtcSgwDeliInviteOkNotification)) {
                    type = CONF_SIP_INVITE_OK;
                }
                /** sip邀请发送失败 */
                else if (TextUtils.equals(name, MtcSgwDeliInviteDidFailNotification)) {
                    type = CONF_SIP_INVITE_FAIL;
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    /************* Cli *************/

    @IntDef({CLI_NONE, CLI_LOGIN_OK, CLI_LOGIN_FAIL, CLI_DID_LOGOUT, CLI_LOGOUTED, CLI_RECONNECTING, CLI_RECONNECT_OK})
    @Retention(RetentionPolicy.SOURCE)
    @interface CliType {
    }

    /**
     * 无
     */
    public static final int CLI_NONE = 0;
    /**
     * 登陆成功
     */
    public static final int CLI_LOGIN_OK = 1;
    /**
     * 登陆失败
     */
    public static final int CLI_LOGIN_FAIL = 2;
    /**
     * 主动登出
     */
    public static final int CLI_DID_LOGOUT = 3;
    /**
     * 被动登出
     */
    public static final int CLI_LOGOUTED = 4;
    /**
     * 重连中
     */
    public static final int CLI_RECONNECTING = 5;
    /**
     * 重连成功
     */
    public static final int CLI_RECONNECT_OK = 6;

    public class Cli implements MtcCliConstants {

        public class LoginOk {
            public String uid;
        }

        public class LoginFail {
            public int statusCode;
        }

        public class DidLogout {
            public int statusCode;
        }

        public class Logouted {
            public int statusCode;
        }

        @CliType
        public int type;
        public LoginOk loginOk;
        public LoginFail loginFail;
        public DidLogout didLogout;
        public Logouted logouted;

        public Cli() {

        }

        public Cli(String name, String info) {
            type = CLI_NONE;
            JSONObject object = null;
            if (info != null) {
                try {
                    object = new JSONObject(info);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            /** 登陆成功 */
            if (name.equals(MtcCliServerLoginOkNotification)) {
                type = CLI_LOGIN_OK;
                loginOk = new LoginOk();
                loginOk.uid = MtcUe.Mtc_UeGetUid();
            }
            /** 登陆失败 */
            else if (name.equals(MtcCliServerLoginDidFailNotification)) {
                type = CLI_LOGIN_FAIL;
                loginFail = new LoginFail();
                loginFail.statusCode = object.optInt(MtcCliStatusCodeKey);
            }
            /** 主动登出 */
            else if (name.equals(MtcCliServerDidLogoutNotification)) {
                type = CLI_DID_LOGOUT;
                didLogout = new DidLogout();
                didLogout.statusCode = object.optInt(MtcCliStatusCodeKey);
            }
            /** 被动登出 */
            else if (name.equals(MtcCliServerLogoutedNotification)) {
                type = CLI_LOGOUTED;
                logouted = new Logouted();
                logouted.statusCode = object.optInt(MtcCliStatusCodeKey);
            }
            /** 重连中 */
            else if (name.equals(MtcCliReconnectingNotification)) {
                type = CLI_RECONNECTING;
            }
            /** 重连成功 */
            else if (name.equals(MtcCliReconnectOkNotification)) {
                type = CLI_RECONNECT_OK;
            }
        }
    }

    /************* Call *************/

    @IntDef({CALL_NONE, CALL_DIDTERM, CALL_TERMED, CALL_INCOMING, CALL_TALKING, CALL_CONNECTING, CALL_ALERTED,
            CALL_MESSAGE, CALL_OTHER_VIDEO_STATUS, CALL_MISS_CALL, CALL_NET_STATUS, CALL_TRYING})
    @Retention(RetentionPolicy.SOURCE)
    @interface CallType {
    }

    /**
     * 无
     */
    public static final int CALL_NONE = 0;
    /**
     * 主动挂断
     */
    public static final int CALL_DIDTERM = 1;
    /**
     * 被动挂断
     */
    public static final int CALL_TERMED = 2;
    /**
     * 电话呼入
     */
    public static final int CALL_INCOMING = 3;
    /**
     * 通话中
     */
    public static final int CALL_TALKING = 4;
    /**
     * 连接中
     */
    public static final int CALL_CONNECTING = 5;
    /**
     * 振铃中
     */
    public static final int CALL_ALERTED = 6;
    /**
     * 消息
     */
    public static final int CALL_MESSAGE = 7;
    /**
     * 对端视频状态
     */
    public static final int CALL_OTHER_VIDEO_STATUS = 8;
    /**
     * 未接电话
     */
    public static final int CALL_MISS_CALL = 9;
    /**
     * 通话网络状态
     */
    public static final int CALL_NET_STATUS = 10;
    /**
     * 呼出中
     */
    public static final int CALL_TRYING = 11;


    @IntDef({CALL_MESSAGE_TYPE_INFO, CALL_MESSAGE_TYPE_STREAM_DATA})
    @Retention(RetentionPolicy.SOURCE)
    public @interface CallMessageTunnel {
    }

    public static final int CALL_MESSAGE_TYPE_INFO = 0;
    public static final int CALL_MESSAGE_TYPE_STREAM_DATA = 1;

    public class Call implements MtcCallConstants {
        public class DidTerm {
            public long callId;
            public int statusCode;
        }

        public class Termed {
            public long callId;
            public String desc;
            public int statusCode;
        }

        public class Incoming {
            public long callId;
            public String userId;
            public String uri;
            public String renderId;
            public String displayName;
            public boolean video;
            public String serverCallId;
            public String extraParam;
        }

        public class Trying {
            public long callId;
            public String serverCallId;
        }

        public class Connecting {
            public long callId;
            public boolean video;
        }

        public class Talking {
            public long callId;
        }

        public class Alerted {
            public long callId;
            public int type;
        }

        public class Message {
            public long callId;
            @CallMessageTunnel
            public int tunnel;
            public String type;
            public String content;
        }

        public class OtherVideoStatus {
            public long callId;
            public int status;
        }

        public class MissCall {
            public String serverCallId;
            public boolean video;
            public long time;
            public String userId;
            public String uri;
            public String displayName;
        }

        public class NetStatus {
            public long callId;
            public boolean video;
            public boolean send;
            public int status;
            public int receiveRtt;
            public int receiveJitter;
            public int receiveLostRate;
            public int receiveCurBitRate;
        }

        @CallType
        public int type;
        public DidTerm didTerm;
        public Termed termed;
        public Incoming incoming;
        public Connecting connecting;
        public Talking talking;
        public Alerted alerted;
        public Message message;
        public OtherVideoStatus otherVideoStatus;
        public MissCall missCall;
        public NetStatus netStatus;
        public Trying trying;

        public Call(String name, String info) {
            type = CALL_NONE;
            JSONObject object = null;
            if (info != null) {
                try {
                    object = new JSONObject(info);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (name.equals(MtcCallDidTermNotification)) {
                type = CALL_DIDTERM;
                didTerm = new DidTerm();
                didTerm.callId = object.optLong(MtcCallIdKey);
                didTerm.statusCode = object.optInt(MtcCallStatusCodeKey);
            } else if (name.equals(MtcCallTermedNotification)) {
                type = CALL_TERMED;
                termed = new Termed();
                termed.callId = object.optLong(MtcCallIdKey);
                termed.statusCode = object.optInt(MtcCallStatusCodeKey);
                termed.desc = object.optString(MtcCallDescriptionKey);
            } else if (name.equals(MtcCallIncomingNotification)) {
                type = CALL_INCOMING;
                incoming = new Incoming();
                incoming.callId = object.optLong(MtcCallIdKey);
                incoming.video = MtcCall.Mtc_CallHasVideo((int) incoming.callId);
                incoming.renderId = MtcCall.Mtc_CallGetName((int) incoming.callId);
                incoming.serverCallId = MtcCallExt.Mtc_CallGetServerCallId((int) incoming.callId);
                incoming.extraParam = object.optString(MtcCallConstants.MtcCallUserDataKey);
                String uri = MtcCall.Mtc_CallGetPeerUri((int) incoming.callId);
                String displayName = MtcCall.Mtc_CallGetPeerDisplayName((int) incoming.callId);
                if (!TextUtils.isEmpty(uri)) {
                    incoming.uri = uri;
                    incoming.userId = MtcUser.Mtc_UserGetId(incoming.uri);
                    if (!TextUtils.isEmpty(displayName)) {
                        incoming.displayName = displayName;
                    } else {
                        incoming.displayName = incoming.userId;
                    }
                } else {
                    incoming.uri = "";
                    incoming.displayName = "";
                }
            } else if (name.equals(MtcCallTryingNotification)) {
                type = CALL_TRYING;
                trying = new Trying();
                trying.callId = object.optLong(MtcCallIdKey);
                trying.serverCallId = MtcCallExt.Mtc_CallGetServerCallId((int) trying.callId);
            } else if (name.equals(MtcCallTalkingNotification)) {
                type = CALL_TALKING;
                talking = new Talking();
                talking.callId = object.optLong(MtcCallIdKey);
            } else if (name.equals(MtcCallConnectingNotification)) {
                type = CALL_CONNECTING;
                connecting = new Connecting();
                connecting.callId = object.optLong(MtcCallIdKey);
                connecting.video = MtcCall.Mtc_CallHasVideo((int) connecting.callId);
            } else if (name.equals(MtcCallAlertedNotification)) {
                type = CALL_ALERTED;
                alerted = new Alerted();
                alerted.callId = object.optLong(MtcCallIdKey);
                alerted.type = object.optInt(MtcCallAlertTypeKey);
            } else if (name.equals(MtcCallInfoReceivedNotification)) {
                type = CALL_MESSAGE;
                message = new Message();
                message.tunnel = JCNotify.CALL_MESSAGE_TYPE_INFO;
                message.callId = object.optLong(MtcCallIdKey);
                message.content = object.optString(MtcCallBodyKey);
            }  else if (name.equals(MtcCallStreamDataReceivedNotification)) {
                type = CALL_MESSAGE;
                message = new Message();
                message.tunnel = JCNotify.CALL_MESSAGE_TYPE_STREAM_DATA;
                message.callId = object.optLong(MtcCallIdKey);
                message.type = object.optString(MtcCallDataNameKey);
                message.content = object.optString(MtcCallDataValueKey);
            } else if (name.equals(MtcCallVideoReceiveStatusChangedNotification)) {
                type = CALL_OTHER_VIDEO_STATUS;
                otherVideoStatus = new OtherVideoStatus();
                otherVideoStatus.callId = object.optLong(MtcCallIdKey);
                otherVideoStatus.status = object.optInt(MtcCallVideoStatusKey);
            } else if (name.equals(MtcCallMissedNotification)) {
                type = CALL_MISS_CALL;
                missCall = new MissCall();
                missCall.serverCallId = object.optString(MtcCallServerIdKey);
                missCall.video = object.optBoolean(MtcCallIsVideoKey);
                missCall.time = object.optLong(MtcCallStartTimeKey);
                missCall.uri = object.optString(MtcCallPeerUriKey);
                missCall.userId = MtcUser.Mtc_UserGetId(missCall.uri);
                missCall.displayName = object.optString(MtcCallPeerNameKey);
                if (TextUtils.isEmpty(missCall.displayName)) {
                    missCall.displayName = missCall.userId;
                }
            } else if (name.equals(MtcCallNetworkStatusChangedNotification)) {
                type = CALL_NET_STATUS;
                netStatus = new NetStatus();
                netStatus.callId = object.optLong(MtcCallIdKey);
                netStatus.send = object.optBoolean(MtcCallIsSendKey);
                netStatus.video = object.optBoolean(MtcCallIsVideoKey);
                netStatus.status = object.optInt(MtcCallNetworkStatusKey);
                netStatus.receiveRtt = object.optInt(MtcCallReceiveRttKey);
                netStatus.receiveJitter = object.optInt(MtcCallReceiveJitterKey);
                netStatus.receiveLostRate = object.optInt(MtcCallReceiveLostRatioKey);
                netStatus.receiveCurBitRate = object.optInt(MtcCallReceiveCurBitRateKey);
            }
        }
    }

    @IntDef({GROUP_TYPE_NONE, GROUP_TYPE_CREATE_OK, GROUP_TYPE_CREATE_FAIL, GROUP_TYPE_FETCH_GROUP_OK,
            GROUP_TYPE_FETCH_GROUP_FAIL, GROUP_TYPE_GROUP_LIST_CHANGE, GROUP_TYPE_FETCH_GROUP_INFO_OK,
            GROUP_TYPE_FETCH_GROUP_INFO_FAIL, GROUP_TYPE_GROUP_INFO_CHANGE, GROUP_TYPE_LEAVE_OK,
            GROUP_TYPE_LEAVE_FAIL, GROUP_TYPE_DISSOLVE_OK, GROUP_TYPE_DISSOLVE_FAIL,
            GROUP_TYPE_DEAL_MEMBERS_OK, GROUP_TYPE_DEAL_MEMBERS_FAIL,
            GROUP_TYPE_CHANGE_GROUP_PROP_OK, GROUP_TYPE_CHANGE_GROUP_PROP_FAIL})
    @Retention(RetentionPolicy.SOURCE)
    @interface GroupType {
    }

    /// 无
    static final int GROUP_TYPE_NONE = 0;
    /// 群创建成功
    static final int GROUP_TYPE_CREATE_OK = 1;
    /// 群创建失败
    static final int GROUP_TYPE_CREATE_FAIL = 2;
    /// 获取群列表成功
    static final int GROUP_TYPE_FETCH_GROUP_OK = 3;
    /// 获取群列表失败
    static final int GROUP_TYPE_FETCH_GROUP_FAIL = 4;
    /// 群列表更新
    static final int GROUP_TYPE_GROUP_LIST_CHANGE = 5;
    /// 获取群详情成功
    static final int GROUP_TYPE_FETCH_GROUP_INFO_OK = 6;
    /// 获取群详情失败
    static final int GROUP_TYPE_FETCH_GROUP_INFO_FAIL = 7;
    /// 群详情更新
    static final int GROUP_TYPE_GROUP_INFO_CHANGE = 8;
    /// 离开成功
    static final int GROUP_TYPE_LEAVE_OK = 9;
    /// 离开失败
    static final int GROUP_TYPE_LEAVE_FAIL = 10;
    /// 解散成功
    static final int GROUP_TYPE_DISSOLVE_OK = 11;
    /// 解散失败
    static final int GROUP_TYPE_DISSOLVE_FAIL = 12;
    /// 处理成员成功
    static final int GROUP_TYPE_DEAL_MEMBERS_OK = 13;
    /// 处理成员失败
    static final int GROUP_TYPE_DEAL_MEMBERS_FAIL = 14;
    /// 更新群属性成功
    static final int GROUP_TYPE_CHANGE_GROUP_PROP_OK = 15;
    /// 更新群属性失败
    static final int GROUP_TYPE_CHANGE_GROUP_PROP_FAIL = 16;

    @IntDef({GROUP_CHANGE_TYPE_ADD, GROUP_CHANGE_TYPE_REMOVE, GROUP_CHANGE_TYPE_UPDATE})
    @Retention(RetentionPolicy.SOURCE)
    @interface GroupChangeType {
    }

    static final int GROUP_CHANGE_TYPE_ADD = 0;
    static final int GROUP_CHANGE_TYPE_REMOVE = 1;
    static final int GROUP_CHANGE_TYPE_UPDATE = 2;

    class Group implements MtcGroupConstants {

        class NotifyItem {
            String groupId;
            String name;
            String tag;
            @GroupChangeType
            int changeType;
        }

        class NotifyMember {
            int memberType;
            String uid;
            String displayName;
            @GroupChangeType
            int changeType;
            String tag;
        }

        class CreateOk {
            String groupId;
            String name;
        }

        class CreateFail {
            int reason;
            String detail;
        }

        class FetchGroupOk {
            Collection<NotifyItem> groupItems;
            long updateTime;
            boolean fullUpdate;
        }

        class FetchGroupFail {
            String groupId;
            int reason;
            String details;
        }

        class FetchGroupInfoOk {
            String groupId;
            String name;
            Collection<NotifyMember> members;
            long updateTime;
            boolean fullUpdate;
        }

        class FetchGroupInfoFail {
            String groupId;
            int reason;
            String details;
        }

        class LeaveOk {
            String groupId;
        }

        class LeaveFail {
            String groupId;
            int reason;
            String details;
        }

        class DissolveOk {
            String groupId;
        }

        class DissolveFail {
            String groupId;
            int reason;
            String details;
        }

        class DealMembersOk {
        }

        class DealMembersFail {
            int reason;
            String details;
        }

        class GroupListChange {
        }

        class GroupInfoChange {
            String groupId;
        }

        class ChangeGroupPropOk {
            String groupId;
        }

        class ChangeGroupPropFail {
            String groupId;
            int reason;
            String details;
        }

        @GroupType
        int type;
        CreateOk createOk;
        CreateFail createFail;
        FetchGroupOk fetchGroupOk;
        FetchGroupFail fetchGroupFail;
        FetchGroupInfoOk fetchGroupInfoOk;
        FetchGroupInfoFail fetchGroupInfoFail;
        LeaveOk leaveOk;
        LeaveFail leaveFail;
        DissolveOk dissolveOk;
        DissolveFail dissolveFail;
        DealMembersOk dealMembersOk;
        DealMembersFail dealMembersFail;
        GroupListChange groupListChange;
        GroupInfoChange groupInfoChange;
        ChangeGroupPropOk changeGroupPropOk;
        ChangeGroupPropFail changeGroupPropFail;

        Group(String name, String info) {
            this.type = GROUP_TYPE_NONE;
            JSONObject object = null;
            if (info != null) {
                try {
                    object = new JSONObject(info);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (object == null) {
                return;
            }
            if (MtcGroupCreateOkNotification.equals(name)) {
                this.type = GROUP_TYPE_CREATE_OK;
                this.createOk = new CreateOk();
                this.createOk.groupId = object.optString(MtcGroupRidKey);
                JSONObject jsonObject = object.optJSONObject(MtcGroupPropertiesKey);
                this.createOk.name = jsonObject.optString(MtcGroupPropNameKey);
            } else if (MtcGroupCreateDidFailNotification.equals(name)) {
                this.type = GROUP_TYPE_CREATE_FAIL;
                this.createFail = new CreateFail();
                this.createFail.reason = object.optInt(MtcGroupReasonCodeKey);
                this.createFail.detail = object.optString(MtcGroupReasonDetailKey);
            } else if (MtcGroupRefreshOkNotification.equals(name)) {
                int type = object.optInt(MtcGroupRidTypeKey);
                if (type == EN_MTC_GROUP_RESOURCE_ID_GROUP) {
                    this.type = GROUP_TYPE_FETCH_GROUP_INFO_OK;
                    this.fetchGroupInfoOk = new FetchGroupInfoOk();
                    this.fetchGroupInfoOk.groupId = object.optString(MtcGroupRidKey);
                    this.fetchGroupInfoOk.name = object.optString(MtcGroupDisplayNameKey);
                    this.fetchGroupInfoOk.updateTime = object.optLong(MtcGroupUpdateTimeKey);
                    this.fetchGroupInfoOk.fullUpdate = !object.optBoolean(MtcGroupIsPartialUpdateKey);
                    this.fetchGroupInfoOk.members = new HashSet<>();
                    if (this.fetchGroupInfoOk.fullUpdate) {
                        JSONArray jsonArray = object.optJSONArray(MtcGroupRelationListKey);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                JSONObject jsonObject = jsonArray.optJSONObject(i);
                                NotifyMember notifyMember = new NotifyMember();
                                notifyMember.memberType = jsonObject.optInt(MtcGroupRelationTypeKey);
                                notifyMember.uid = jsonObject.optString(MtcGroupRidKey);
                                notifyMember.displayName = jsonObject.optString(MtcGroupDisplayNameKey);
                                notifyMember.changeType = GROUP_CHANGE_TYPE_ADD;
                                notifyMember.tag = jsonObject.optString(MtcGroupTagKey);
                                this.fetchGroupInfoOk.members.add(notifyMember);
                            }
                        }
                    } else {
                        JSONArray jsonArray = object.optJSONArray(MtcGroupAddedRelationListKey);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                JSONObject jsonObject = jsonArray.optJSONObject(i);
                                NotifyMember notifyMember = new NotifyMember();
                                notifyMember.memberType = jsonObject.optInt(MtcGroupRelationTypeKey);
                                notifyMember.uid = jsonObject.optString(MtcGroupRidKey);
                                notifyMember.displayName = jsonObject.optString(MtcGroupDisplayNameKey);
                                notifyMember.changeType = GROUP_CHANGE_TYPE_ADD;
                                notifyMember.tag = jsonObject.optString(MtcGroupTagKey);
                                this.fetchGroupInfoOk.members.add(notifyMember);
                            }
                        }
                        jsonArray = object.optJSONArray(MtcGroupUpdatedRelationListKey);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                JSONObject jsonObject = jsonArray.optJSONObject(i);
                                NotifyMember notifyMember = new NotifyMember();
                                notifyMember.memberType = jsonObject.optInt(MtcGroupRelationTypeKey);
                                notifyMember.uid = jsonObject.optString(MtcGroupRidKey);
                                notifyMember.displayName = jsonObject.optString(MtcGroupDisplayNameKey);
                                notifyMember.changeType = GROUP_CHANGE_TYPE_UPDATE;
                                notifyMember.tag = jsonObject.optString(MtcGroupTagKey);
                                this.fetchGroupInfoOk.members.add(notifyMember);
                            }
                        }
                        jsonArray = object.optJSONArray(MtcGroupRemovedRelationListKey);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                NotifyMember notifyMember = new NotifyMember();
                                notifyMember.uid = jsonArray.optString(i);
                                notifyMember.changeType = GROUP_CHANGE_TYPE_REMOVE;
                                this.fetchGroupInfoOk.members.add(notifyMember);
                            }
                        }
                    }
                } else {
                    this.type = GROUP_TYPE_FETCH_GROUP_OK;
                    this.fetchGroupOk = new FetchGroupOk();
                    this.fetchGroupOk.updateTime = object.optLong(MtcGroupUpdateTimeKey);
                    this.fetchGroupOk.fullUpdate = !object.optBoolean(MtcGroupIsPartialUpdateKey);
                    this.fetchGroupOk.groupItems = new HashSet<>();
                    if (this.fetchGroupOk.fullUpdate) {
                        JSONArray jsonArray = object.optJSONArray(MtcGroupRelationListKey);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                JSONObject jsonObject = jsonArray.optJSONObject(i);
                                NotifyItem notifyItem = new NotifyItem();
                                notifyItem.groupId = jsonObject.optString(MtcGroupRidKey);
                                notifyItem.name = jsonObject.optString(MtcGroupDisplayNameKey);
                                notifyItem.changeType = GROUP_CHANGE_TYPE_ADD;
                                notifyItem.tag = jsonObject.optString(MtcGroupTagKey);
                                this.fetchGroupOk.groupItems.add(notifyItem);
                            }
                        }
                    } else {
                        JSONArray jsonArray = object.optJSONArray(MtcGroupAddedRelationListKey);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                JSONObject jsonObject = jsonArray.optJSONObject(i);
                                NotifyItem notifyItem = new NotifyItem();
                                notifyItem.groupId = jsonObject.optString(MtcGroupRidKey);
                                notifyItem.name = jsonObject.optString(MtcGroupDisplayNameKey);
                                notifyItem.changeType = GROUP_CHANGE_TYPE_ADD;
                                notifyItem.tag = jsonObject.optString(MtcGroupTagKey);
                                this.fetchGroupOk.groupItems.add(notifyItem);
                            }
                        }

                        jsonArray = object.optJSONArray(MtcGroupUpdatedRelationListKey);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                JSONObject jsonObject = jsonArray.optJSONObject(i);
                                NotifyItem notifyItem = new NotifyItem();
                                notifyItem.groupId = jsonObject.optString(MtcGroupRidKey);
                                notifyItem.name = jsonObject.optString(MtcGroupDisplayNameKey);
                                notifyItem.changeType = GROUP_CHANGE_TYPE_UPDATE;
                                notifyItem.tag = jsonObject.optString(MtcGroupTagKey);
                                this.fetchGroupOk.groupItems.add(notifyItem);
                            }
                        }

                        jsonArray = object.optJSONArray(MtcGroupRemovedRelationListKey);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                NotifyItem notifyItem = new NotifyItem();
                                notifyItem.groupId = jsonArray.optString(i);
                                notifyItem.changeType = GROUP_CHANGE_TYPE_REMOVE;
                                this.fetchGroupOk.groupItems.add(notifyItem);
                            }
                        }
                    }
                }
            } else if (MtcGroupRefreshDidFailNotification.equals(name)) {
                int type = object.optInt(MtcGroupRidTypeKey);
                if (type == EN_MTC_GROUP_RESOURCE_ID_GROUP) {
                    this.type = GROUP_TYPE_FETCH_GROUP_INFO_FAIL;
                    this.fetchGroupInfoFail = new FetchGroupInfoFail();
                    this.fetchGroupInfoFail.groupId = object.optString(MtcGroupRidKey);
                    this.fetchGroupInfoFail.reason = object.optInt(MtcGroupReasonCodeKey);
                    this.fetchGroupInfoFail.details = object.optString(MtcGroupReasonDetailKey);
                } else {
                    this.type = GROUP_TYPE_FETCH_GROUP_FAIL;
                    this.fetchGroupFail = new FetchGroupFail();
                    this.fetchGroupFail.groupId = object.optString(MtcGroupRidKey);
                    this.fetchGroupFail.reason = object.optInt(MtcGroupReasonCodeKey);
                    this.fetchGroupFail.details = object.optString(MtcGroupReasonDetailKey);
                }
            } else if (MtcGroupRemoveOkNotification.equals(name)) {
                int type = object.optInt(MtcGroupRidTypeKey);
                if (type == EN_MTC_GROUP_RESOURCE_ID_GROUP) {
                    this.type = GROUP_TYPE_DISSOLVE_OK;
                    this.dissolveOk = new DissolveOk();
                    this.dissolveOk.groupId = object.optString(MtcGroupRidKey);
                }
            } else if (MtcGroupRemoveDidFailNotification.equals(name)) {
                int type = object.optInt(MtcGroupRidTypeKey);
                if (type == EN_MTC_GROUP_RESOURCE_ID_GROUP) {
                    this.type = GROUP_TYPE_DISSOLVE_FAIL;
                    this.dissolveFail = new DissolveFail();
                    this.dissolveFail.groupId = object.optString(MtcGroupRidKey);
                    this.dissolveFail.reason = object.optInt(MtcGroupReasonCodeKey);
                    this.dissolveFail.details = object.optString(MtcGroupReasonDetailKey);
                }
            } else if (MtcGroupRemoveRelationOkNotification.equals(name)) {
                this.type = GROUP_TYPE_LEAVE_OK;
                this.leaveOk = new LeaveOk();
                this.leaveOk.groupId = object.optString(MtcGroupRidKey);
            } else if (MtcGroupRemoveRelationDidFailNotification.equals(name)) {
                this.type = GROUP_TYPE_LEAVE_FAIL;
                this.leaveFail = new LeaveFail();
                this.leaveFail.groupId = object.optString(MtcGroupRidKey);
                this.leaveFail.reason = object.optInt(MtcGroupReasonCodeKey);
                this.leaveFail.details = object.optString(MtcGroupReasonDetailKey);
            } else if (MtcGroupChangedNotification.equals(name)) {
                int type = object.optInt(MtcGroupRidTypeKey);
                if (type == EN_MTC_GROUP_RESOURCE_ID_GROUP) {
                    this.type = GROUP_TYPE_GROUP_INFO_CHANGE;
                    this.groupInfoChange = new GroupInfoChange();
                    this.groupInfoChange.groupId = object.optString(MtcGroupRidKey);
                } else {
                    this.type = GROUP_TYPE_GROUP_LIST_CHANGE;
                    this.groupListChange = new GroupListChange();
                }
            } else if (MtcGroupSetRelationsOkNotification.equals(name)) {
                this.type = GROUP_TYPE_DEAL_MEMBERS_OK;
                this.dealMembersOk = new DealMembersOk();
            } else if (MtcGroupSetRelationsDidFailNotification.equals(name)) {
                this.type = GROUP_TYPE_DEAL_MEMBERS_FAIL;
                this.dealMembersFail = new DealMembersFail();
                this.dealMembersFail.reason = object.optInt(MtcGroupReasonCodeKey);
                this.dealMembersFail.details = object.optString(MtcGroupReasonDetailKey);
            } else if (MtcGroupSetPropertiesOkNotification.equals(name)) {
                this.type = GROUP_TYPE_CHANGE_GROUP_PROP_OK;
                this.changeGroupPropOk = new ChangeGroupPropOk();
                this.changeGroupPropOk.groupId = object.optString(MtcGroupRidKey);
            } else if (MtcGroupSetPropertiesDidFailNotification.equals(name)) {
                this.type = GROUP_TYPE_CHANGE_GROUP_PROP_FAIL;
                this.changeGroupPropFail = new ChangeGroupPropFail();
                this.changeGroupPropFail.groupId = object.optString(MtcGroupRidKey);
                this.changeGroupPropFail.reason = object.optInt(MtcGroupReasonCodeKey);
                this.changeGroupPropFail.details = object.optString(MtcGroupReasonDetailKey);
            }
        }
    }

    /************* Account *************/

    @IntDef({ACCOUNT_QUERY_USER_STATUS_OK, ACCOUNT_QUERY_USER_STATUS_FAIL})

    @Retention(RetentionPolicy.SOURCE)
    @interface AccountType {
    }

    /**
     * 无
     */
    public static final int ACCOUNT_NONE = 0;
    /**
     * 查询用户状态成功
     */
    public static final int ACCOUNT_QUERY_USER_STATUS_OK = 1;
    /**
     * 查询用户状态失败
     */
    public static final int ACCOUNT_QUERY_USER_STATUS_FAIL = 2;

    public class Account implements MtcBuddyConstants {

        public class QueryUserStatusItem {
            public String userId;
            public int status;

            public QueryUserStatusItem(JSONObject jsonObject) {
                userId = MtcUser.Mtc_UserGetId(jsonObject.optString("UserUri"));
                status = jsonObject.optInt("Status");
            }
        }

        public class QueryUserStatus {
            public List<QueryUserStatusItem> resultList;

            public QueryUserStatus() {
                resultList = new ArrayList<>();
            }
        }

        @AccountType
        int type;
        public QueryUserStatus queryUserStatus;

        public Account(String name, String info) {
            this.type = ACCOUNT_NONE;
            if (name.equals(MtcBuddyQueryUsersStatusOkNotification)) {
                try {
                    queryUserStatus = new QueryUserStatus();
                    type = ACCOUNT_QUERY_USER_STATUS_OK;
                    JSONArray jsonArray = new JSONArray(info);
                    for (int i = 0; i < jsonArray.length(); i++) {
                        queryUserStatus.resultList.add(new QueryUserStatusItem(jsonArray.optJSONObject(i)));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            } else if (name.equals(MtcBuddyQueryUsersStatusDidFailNotification)) {
                type = ACCOUNT_QUERY_USER_STATUS_FAIL;
            }
        }
    }

    /** 通知结果类 */
    @IntDef({CLI, CONF, CALL, MESSAGE, STORAGE, GROUP, ACCOUNT})
    @Retention(RetentionPolicy.SOURCE)
    @interface Type {
    }

    /**
     * Cli 相关通知
     */
    public static final int CLI = 0;
    /**
     * Conf 相关通知
     */
    public static final int CONF = 1;
    /**
     * Call 相关通知
     */
    public static final int CALL = 2;
    /**
     * Message 相关通知
     */
    public static final int MESSAGE = 3;
    /**
     * Storage 相关通知
     */
    public static final int STORAGE = 4;
    /**
     * Group 相关通知
     */
    public static final int GROUP = 5;
    /**
     * Account 相关通知
     */
    public static final int ACCOUNT = 6;

    @JCNotify.Type
    public int type;
    public int cookie;
    public Cli cliNotify;
    public Call callNotify;
    public Conf confNotify;
    public Message messageNotify;
    public Storage storageNotify;
    public Group groupNotify;
    public Account accountNotify;

    private final static String TAG_CLI = "MtcCli";
    private final static String TAG_CONF = "MtcConf";
    private final static String TAG_CALL = "MtcCall";
    private final static String TAG_IM = "MtcIm";
    private final static String TAG_FS2 = "MtcFs2";
    private final static String TAG_GROUP = "MtcGroup";
    private final static String TAG_SGW = "MtcSgw";
    private final static String TAG_BUDDY = "MtcBuddy";

    public static JCNotify create(String name, int cookie, String info) {
        JCNotify notify = null;
        if (name.startsWith(TAG_CLI)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = CLI;
            notify.cliNotify = notify.new Cli(name, info);
        } else if (name.startsWith(TAG_CONF) || name.startsWith(TAG_SGW)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = CONF;
            notify.confNotify = notify.new Conf(name, info);
        } else if (name.startsWith(TAG_CALL)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = CALL;
            notify.callNotify = notify.new Call(name, info);
        } else if (name.startsWith(TAG_IM)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = MESSAGE;
            notify.messageNotify = notify.new Message(name, info);
        } else if (name.startsWith(TAG_FS2)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = STORAGE;
            notify.storageNotify = notify.new Storage(name, info);
        } else if (name.startsWith(TAG_GROUP)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = GROUP;
            notify.cookie = cookie;
            notify.groupNotify = notify.new Group(name, info);
        } else if (name.startsWith(TAG_BUDDY)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = ACCOUNT;
            notify.accountNotify = notify.new Account(name, info);
        }
        return notify;
    }
}
