package com.juphoon.cloud;

/**
 * 群组成员对象类
 *
 * @author juphoon
 */
public class JCGroupMember {

    /**
     * 群组标识
     */
    public String groupId;
    /**
     * 用户标识
     */
    public String userId;
    /**
     *  服务器端用户标识
     *  当通知成员变化时，changeState 为 GROUP_CHANGE_STATE_REMOVE 时只能通过此参数来判断，不能通过 userId
     */
    public String uid;
    /**
     * 用户昵称
     */
    public String displayName;
    /**
     * 角色类型，参见 JCGroupMemberType
     */
    @JCGroup.MemberType
    public int memberType;
    /**
     * 成员改变状态
     */
    @JCGroup.ChangeState
    public int changeState;

    /**
     *  构造 JCGroupMember
     *  @param groupId 群组唯一标识
     *  @param userId 用户标识
     *  @param displayName 昵称
     *  @param memberType 成员类型
     *  @param changeState 成员变化状态
     */
    public JCGroupMember(String groupId, String userId, String displayName, int memberType, @JCGroup.ChangeState int changeState) {
        this.groupId = groupId;
        this.userId = userId;
        this.displayName = displayName;
        this.memberType = memberType;
        this.changeState = changeState;
    }
}
