/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCGroupCallback;
import com.juphoon.cloud.JCGroupImpl;
import com.juphoon.cloud.JCGroupItem;
import com.juphoon.cloud.JCGroupMember;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public abstract class JCGroup {
    static final String TAG = JCGroup.class.getSimpleName();
    public static final int REASON_NONE = 0;
    public static final int REASON_NOT_LOGIN = 1;
    public static final int REASON_CALL_FUNCTION_ERROR = 2;
    public static final int REASON_TIME_OUT = 3;
    public static final int REASON_NETWORK = 4;
    public static final int REASON_PARAM_INVALID = 5;
    public static final int REASON_OTHER = 100;
    public static final int GROUP_CHANGE_STATE_NONE = 0;
    public static final int GROUP_CHANGE_STATE_ADD = 1;
    public static final int GROUP_CHANGE_STATE_UPDATE = 2;
    public static final int GROUP_CHANGE_STATE_REMOVE = 3;
    public static final int GROUP_MEMBER_TYPE_OWNER = 0;
    public static final int GROUP_MEMBER_TYPE_MANAGER = 1;
    public static final int GROUP_MEMBER_TYPE_MEMBER = 2;
    private static JCGroup sGroup;

    public static JCGroup create(JCClient client, JCGroupCallback callback) {
        if (sGroup != null) {
            return sGroup;
        }
        sGroup = new JCGroupImpl(client, callback);
        return sGroup;
    }

    public static void destroy() {
        if (sGroup != null) {
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    sGroup.destroyObj();
                    sGroup = null;
                }
            });
        }
    }

    protected abstract void destroyObj();

    public abstract int fetchGroups(long var1);

    public abstract int fetchGroupInfo(String var1, long var2);

    public abstract int createGroup(List<JCGroupMember> var1, String var2);

    public abstract int updateGroup(JCGroupItem var1);

    public abstract int dissolve(String var1);

    public abstract int leave(String var1);

    public abstract int updateSelfInfo(JCGroupMember var1);

    public abstract int dealMembers(String var1, List<JCGroupMember> var2);

    abstract void addCallback(JCGroupCallback var1);

    abstract void removeCallback(JCGroupCallback var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MemberType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChangeState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reason {
    }
}

