/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import com.juphoon.cloud.JCCallCallback;
import com.juphoon.cloud.JCCallImpl;
import com.juphoon.cloud.JCCallItem;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCMediaDevice;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public abstract class JCCall {
    static final String TAG = JCCall.class.getSimpleName();
    public static final int DIRECTION_IN = 0;
    public static final int DIRECTION_OUT = 1;
    public static final int REASON_NONE = 0;
    public static final int REASON_NOT_LOGIN = 1;
    public static final int REASON_CALL_FUNCTION_ERROR = 2;
    public static final int REASON_TIMEOUT = 3;
    public static final int REASON_NETWORK = 4;
    public static final int REASON_OVER_LIMIT = 5;
    public static final int REASON_TERM_BY_SELF = 6;
    public static final int REASON_ANSWER_FAIL = 7;
    public static final int REASON_BUSY = 8;
    public static final int REASON_DECLINE = 9;
    public static final int REASON_USER_OFFLINE = 10;
    public static final int REASON_NOT_FOUND = 11;
    public static final int REASON_REJECT_VIDEO_WHEN_HAS_CALL = 12;
    public static final int REASON_OTHER = 100;
    public static final int STATE_INIT = 0;
    public static final int STATE_PENDING = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_TALKING = 3;
    public static final int STATE_OK = 4;
    public static final int STATE_CANCEL = 5;
    public static final int STATE_CANCELED = 6;
    public static final int STATE_MISSED = 7;
    public static final int STATE_ERROR = 8;
    public static final int NET_STATUS_DISCONNECTED = -3;
    public static final int NET_STATUS_VERY_BAD = -2;
    public static final int NET_STATUS_BAD = -1;
    public static final int NET_STATUS_NORMAL = 0;
    public static final int NET_STATUS_GOOD = 1;
    public static final int NET_STATUS_VERY_GOOD = 2;
    private static JCCall sCall;
    public int maxCallNum = 5;

    public static JCCall create(JCClient client, JCMediaDevice mediaDevice, JCCallCallback callback) {
        if (sCall != null) {
            return sCall;
        }
        sCall = new JCCallImpl(client, mediaDevice, callback);
        return sCall;
    }

    public static void destroy() {
        if (sCall != null) {
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    sCall.destroyObj();
                    sCall = null;
                }
            });
        }
    }

    protected abstract void destroyObj();

    public abstract boolean call(String var1, boolean var2, String var3);

    public abstract boolean term(JCCallItem var1, int var2, String var3);

    public abstract boolean answer(JCCallItem var1, boolean var2);

    public abstract boolean mute(JCCallItem var1);

    public abstract boolean hold(JCCallItem var1);

    public abstract boolean audioRecord(JCCallItem var1, boolean var2, String var3);

    public abstract boolean videoRecord(JCCallItem var1, boolean var2, boolean var3, int var4, int var5, String var6);

    public abstract boolean becomeActive(JCCallItem var1);

    public abstract boolean enableUploadVideoStream(JCCallItem var1);

    public abstract void setConference(boolean var1);

    public abstract boolean getConference();

    public abstract List<JCCallItem> getCallItems();

    public abstract boolean sendMessage(JCCallItem var1, String var2, String var3);

    public abstract String getStatistics();

    protected abstract void addCallback(JCCallCallback var1);

    protected abstract void removeCallback(JCCallCallback var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallDirection {
    }
}

