/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.TargetApi;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TargetApi(value=11)
public class ZmfMdm {
    private static Pattern _section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private static Pattern _keyValue = Pattern.compile("\\s*([^=]*)=(.*)");
    private static Map<String, Map<String, String>> _entries = new HashMap<String, Map<String, String>>();
    private static String _group = "Mmp Remote";

    public static void loadFile(String string) {
        try {
            ZmfMdm.load(new FileReader(new File(string, "/mdm.ini")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void load(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string2 = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = _section.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(1).trim();
                if (string2.equals("Mmp TOP10")) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                string2 = "Mmp TOP10";
                continue;
            }
            if (string2 == null || !(matcher = _keyValue.matcher(string)).matches()) continue;
            String string3 = matcher.group(1).trim();
            String string4 = matcher.group(2).trim();
            Map<String, String> map = _entries.get(string2);
            if (map == null) {
                map = new HashMap<String, String>();
                _entries.put(string2, map);
            }
            map.put(string3, string4);
        }
        _group = "Mmp Remote";
        if (ZmfMdm.getInt(_group, "mmp.version", 0) == 0 && ZmfMdm.getInt(_group = "Mmp Local", "mmp.version", 0) == 0) {
            _group = "Mmp TOP10";
        }
    }

    public static int getVersion() {
        return ZmfMdm.getInt("Mmp Remote", "mmp.version", 0);
    }

    public static int getAudioMode() {
        String string = ZmfMdm.getString(_group, "mmp.android.audio.mode", "Normal");
        if (string.equals("VoIP")) {
            return 3;
        }
        return 0;
    }

    public static String getAudioInput() {
        String string = ZmfMdm.getString(_group, "mmp.audio.play.mode", "SYS");
        if (string.equals("MUSIC")) {
            return "STREAM_MUSIC";
        }
        if (string.equals("VoIP")) {
            return "STREAM_VOICE_CALL";
        }
        return "STREAM_SYSTEM";
    }

    public static String getAudioOutput() {
        String string = ZmfMdm.getString(_group, "mmp.audio.rec.mode", "SYS");
        if (string.equals("VoIP")) {
            return "VOICE_COMMUNICATION";
        }
        return "MIC";
    }

    public static int getVolumeMaxLevel() {
        return ZmfMdm.getInt(_group, "mmp.speaker.volume.max", 100);
    }

    public static int getAecMode() {
        String string = ZmfMdm.getString(_group, "mmp.aec.mode", "OS");
        if (string.equals("OS")) {
            return 1;
        }
        return 0;
    }

    private static String getString(String string, String string2, String string3) {
        Map<String, String> map = _entries.get(string);
        if (map == null) {
            return string3;
        }
        return map.get(string2);
    }

    private static int getInt(String string, String string2, int n) {
        Map<String, String> map = _entries.get(string);
        if (map == null) {
            return n;
        }
        return Integer.parseInt(map.get(string2));
    }

    private static float getFloat(String string, String string2, float f) {
        Map<String, String> map = _entries.get(string);
        if (map == null) {
            return f;
        }
        return Float.parseFloat(map.get(string2));
    }

    private static double getDouble(String string, String string2, double d) {
        Map<String, String> map = _entries.get(string);
        if (map == null) {
            return d;
        }
        return Double.parseDouble(map.get(string2));
    }
}

