/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.text.TextUtils;
import com.justalk.cloud.zmf.VideoCapture;
import com.justalk.cloud.zmf.ZmfVideo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
class UVCCamera
extends VideoCapture {
    private final int mDeviceClass = 239;
    private final int mDeviceSubClass = 2;
    private volatile boolean destroyed;
    private final UsbManager mUsbManager;
    private int mCaptureH264 = 0;
    HashMap<String, Device> openedDevice;
    private PendingIntent mPermissionIntent = null;
    private static final String ACTION_USB_PERMISSION_BASE = "com.juphoon.USB_PERMISSION.";
    private final String ACTION_USB_PERMISSION = "com.juphoon.USB_PERMISSION." + this.hashCode();
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String string;
            UsbDevice usbDevice;
            if (UVCCamera.this.destroyed) {
                return;
            }
            String string2 = intent.getAction();
            if (UVCCamera.this.ACTION_USB_PERMISSION.equals(string2)) {
                UVCCamera uVCCamera = UVCCamera.this;
                synchronized (uVCCamera) {
                    UsbDevice usbDevice2 = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (usbDevice2 != null) {
                            UVCCamera.this.processConnect(usbDevice2);
                        }
                    } else {
                        UVCCamera.this.processCancel(usbDevice2);
                        ZmfVideo.onErrorOccurred("failed to request usb permission");
                    }
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(string2)) {
                UsbDevice usbDevice3 = (UsbDevice)intent.getParcelableExtra("device");
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(string2) && (usbDevice = (UsbDevice)intent.getParcelableExtra("device")) != null && UVCCamera.this.openedDevice.get(string = usbDevice.getDeviceName()) != null) {
                ZmfVideo.onErrorOccurred("USB camera detached: " + string + " (" + usbDevice.getProductName() + ")");
            }
        }
    };

    private void processCancel(UsbDevice usbDevice) {
        if (usbDevice != null) {
            this.stop(usbDevice.getDeviceName());
        }
    }

    private int processConnect(UsbDevice usbDevice) {
        StringBuilder stringBuilder;
        if (this.destroyed) {
            return -1;
        }
        Device device = this.openedDevice.get(usbDevice.getDeviceName());
        if (device == null) {
            return -1;
        }
        String string = usbDevice.getDeviceName();
        String[] stringArray = !TextUtils.isEmpty((CharSequence)string) ? string.split("/") : null;
        int n = 0;
        int n2 = 0;
        if (stringArray != null && stringArray.length > 2) {
            n = Integer.parseInt(stringArray[stringArray.length - 2]);
            n2 = Integer.parseInt(stringArray[stringArray.length - 1]);
            stringBuilder = new StringBuilder(stringArray[0]);
            for (int i = 1; i < stringArray.length - 2; ++i) {
                stringBuilder.append("/").append(stringArray[i]);
            }
        } else {
            ZmfVideo.logError("failed to open get usbfs " + usbDevice.getDeviceName());
            return -1;
        }
        String string2 = stringBuilder.toString();
        device.mConnection = this.mUsbManager.openDevice(usbDevice);
        if (device.mConnection == null) {
            ZmfVideo.logError("failed to open use connection " + usbDevice.getDeviceName());
            return -1;
        }
        device.handle = UVCCamera.uvcCamOpen(usbDevice.getVendorId(), usbDevice.getProductId(), device.mConnection.getFileDescriptor(), n, n2, string, this.mCaptureH264);
        if (device.handle != 0L) {
            return UVCCamera.uvcCamStart(device.handle, device.mWidth, device.mHeight, device.mFps);
        }
        return -1;
    }

    @Override
    int start(String string, int n, int n2, int n3) {
        Device device = this.openedDevice.get(string);
        if (device != null) {
            ZmfVideo.logError(string + " already opened.");
            return -1;
        }
        UsbDevice usbDevice = null;
        List<UsbDevice> list = this.getDeviceList();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getDeviceName().equals(string)) continue;
            usbDevice = list.get(i);
        }
        if (usbDevice == null) {
            ZmfVideo.logError("can't find usb camera:" + string);
            return -1;
        }
        Device device2 = new Device();
        device2.mWidth = n;
        device2.mHeight = n2;
        device2.mFps = n3;
        this.openedDevice.put(usbDevice.getDeviceName(), device2);
        if (!this.mUsbManager.hasPermission(usbDevice)) {
            try {
                this.mUsbManager.requestPermission(usbDevice, this.mPermissionIntent);
            }
            catch (Exception exception) {
                ZmfVideo.logError("failed to request usb permission:" + string);
                this.processCancel(usbDevice);
                return -2;
            }
            return 0;
        }
        return this.processConnect(usbDevice);
    }

    @Override
    int rotate(String string, int n) {
        return -1;
    }

    @Override
    int effect(int n, JSONObject jSONObject, Object[] objectArray) {
        this.mCaptureH264 = (n & 0x40) != 0 ? 1 : 0;
        return 0;
    }

    @Override
    int stop(String string) {
        Device device = this.openedDevice.get(string);
        if (device != null) {
            if (device.handle != 0L) {
                UVCCamera.uvcCamStop(device.handle);
                UVCCamera.uvcCamClose(device.handle);
            }
            if (device.mConnection != null) {
                device.mConnection.close();
            }
            this.openedDevice.remove(string);
            ZmfVideo.onCaptureDidStop(string);
        }
        return 0;
    }

    @Override
    int stopAll() {
        Set<Map.Entry<String, Device>> set = this.openedDevice.entrySet();
        for (Map.Entry<String, Device> entry : set) {
            Device device = entry.getValue();
            if (device.handle != 0L) {
                UVCCamera.uvcCamStop(device.handle);
                UVCCamera.uvcCamClose(device.handle);
            }
            if (device.mConnection != null) {
                device.mConnection.close();
            }
            ZmfVideo.onCaptureDidStop(entry.getKey());
        }
        this.openedDevice.clear();
        return 0;
    }

    UVCCamera(Context context) {
        super(context);
        this.openedDevice = new HashMap();
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
        IntentFilter intentFilter = new IntentFilter(this.ACTION_USB_PERMISSION);
        intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        context.registerReceiver(this.mUsbReceiver, intentFilter);
        this.destroyed = false;
    }

    @Override
    void teminate() {
        this.destroyed = true;
    }

    private List<UsbDevice> getDeviceList() {
        HashMap hashMap = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> arrayList = new ArrayList<UsbDevice>();
        if (hashMap != null) {
            for (UsbDevice usbDevice : hashMap.values()) {
                UsbConfiguration usbConfiguration;
                if (usbDevice.getDeviceClass() != 239 || usbDevice.getDeviceSubclass() != 2 || usbDevice.getConfigurationCount() <= 0 || (usbConfiguration = usbDevice.getConfiguration(0)).getInterfaceCount() <= 0) continue;
                arrayList.add(usbDevice);
            }
        }
        return arrayList;
    }

    @Override
    int getCount() {
        return this.getDeviceList().size();
    }

    @Override
    int getIndexById(String string) {
        List<UsbDevice> list = this.getDeviceList();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getDeviceName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    String getCaptureBack() {
        return null;
    }

    @Override
    String getCaptureFront() {
        return null;
    }

    @Override
    int getName(int n, String[] stringArray) {
        List<UsbDevice> list = this.getDeviceList();
        if (list.size() > n) {
            UsbDevice usbDevice = list.get(n);
            stringArray[0] = usbDevice.getDeviceName();
            stringArray[1] = usbDevice.getProductName();
            return 0;
        }
        return -1;
    }

    @Override
    int face(String string, int n) {
        return -1;
    }

    @Override
    int getOrient(String string, int[] nArray) {
        int n = this.getIndexById(string);
        if (n < 0) {
            return -1;
        }
        nArray[0] = 2;
        nArray[1] = 0;
        nArray[2] = 0;
        return 0;
    }

    @Override
    int[] getCamParam(String string) {
        return null;
    }

    static native int uvcCamInit(String var0, int var1);

    static native int uvcCamTerm();

    private static native long uvcCamOpen(int var0, int var1, int var2, int var3, int var4, String var5, int var6);

    private static native int uvcCamStart(long var0, int var2, int var3, int var4);

    private static native int uvcCamStop(long var0);

    private static native int uvcCamClose(long var0);

    class Device {
        public int mWidth;
        public int mHeight;
        public int mFps;
        public long handle;
        public UsbDeviceConnection mConnection;

        Device() {
        }
    }
}

