/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.opengl.GLES20;
import com.justalk.cloud.zmf.EffectFx;
import com.justalk.cloud.zmf.EffectParam;
import com.justalk.cloud.zmf.GLView;
import com.justalk.cloud.zmf.ZmfVideo;

class GaussianBlur
extends EffectFx {
    float _hoffset;
    float _voffset;
    float[] _offset = new float[2];

    GaussianBlur() {
    }

    private boolean buildShader(int n, float f, int n2) {
        float f2;
        float f3;
        float f4;
        float f5;
        int n3;
        int n4;
        StringBuilder stringBuilder = new StringBuilder(1024);
        StringBuilder stringBuilder2 = new StringBuilder(1024);
        float[] fArray = new float[n + 1];
        float f6 = 0.0f;
        for (n4 = 0; n4 <= n; ++n4) {
            fArray[n4] = (float)(1.0 / Math.sqrt(Math.PI * 2 * (double)f * (double)f) * Math.exp((float)(-n4 * n4) / (2.0f * f * f)));
            if (fArray[n4] <= 1.0E-4f) {
                n = n4 - 1;
                break;
            }
            f6 += n4 == 0 ? fArray[n4] : fArray[n4] * 2.0f;
        }
        n4 = 0;
        while (n4 <= n) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] / f6;
        }
        n4 = (n + 1) / 2;
        int n6 = Math.min(n4, n2 - 1);
        stringBuilder.append(String.format("attribute vec4 aPosition;\nuniform mat4 _mvp;\nuniform mediump vec2 singleStepOffset;\nvarying vec2 blurCoordinates0;\nvarying vec4 blurCoordinates[%d];\nvoid main(){\n  gl_Position = _mvp*aPosition;\n  blurCoordinates0 = gl_Position.xy*0.5+0.5;\n", n6));
        stringBuilder2.append(String.format("precision mediump float;\nuniform sampler2D _tex;\nuniform vec2 singleStepOffset;\nvarying vec2 blurCoordinates0;\nvarying vec4 blurCoordinates[%d];\nvoid main(){\n  gl_FragColor = texture2D(_tex, blurCoordinates0) * %f;\n", n6, Float.valueOf(fArray[0])));
        for (n3 = 0; n3 < n6; ++n3) {
            f5 = fArray[n3 * 2 + 1];
            f4 = fArray[n3 * 2 + 2];
            f3 = f5 + f4;
            f2 = (f5 * (float)(n3 * 2 + 1) + f4 * (float)(n3 * 2 + 2)) / f3;
            stringBuilder.append(String.format("  blurCoordinates[%d].xy = blurCoordinates0 + singleStepOffset * %f;\n  blurCoordinates[%d].wz = blurCoordinates0 - singleStepOffset * %f;\n", n3, Float.valueOf(f2), n3, Float.valueOf(f2)));
            stringBuilder2.append(String.format("  gl_FragColor += texture2D(_tex, blurCoordinates[%d].xy) * %f;\n  gl_FragColor += texture2D(_tex, blurCoordinates[%d].wz) * %f;\n", n3, Float.valueOf(f3), n3, Float.valueOf(f3)));
        }
        stringBuilder.append("}");
        for (n3 = n6; n3 < n4; ++n3) {
            f5 = fArray[n3 * 2 + 1];
            f4 = fArray[n3 * 2 + 2];
            f3 = f5 + f4;
            f2 = (f5 * (float)(n3 * 2 + 1) + f4 * (float)(n3 * 2 + 2)) / f3;
            stringBuilder2.append(String.format("  gl_FragColor += texture2D(_tex, blurCoordinates0 + singleStepOffset * %f) * %f;\n  gl_FragColor += texture2D(_tex, blurCoordinates0 - singleStepOffset * %f) * %f;\n", Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f2), Float.valueOf(f3)));
        }
        stringBuilder2.append("}");
        return this.load(stringBuilder.toString(), stringBuilder2.toString());
    }

    @Override
    boolean compile(GLView.Layer layer) {
        int n;
        int[] nArray = new int[]{0};
        GLES20.glGetIntegerv((int)36348, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            return false;
        }
        int n2 = nArray[0] > 8 ? 16 : 2 * (nArray[0] - 1);
        float f = 19.0f;
        EffectParam effectParam = layer.effect_param;
        for (n = 0; n < effectParam.argc; n += 1) {
            if (effectParam.name[n].equals("radius")) {
                n2 = (int)effectParam.value[n] * 2;
                continue;
            }
            if (!effectParam.name[n].equals("sigma")) continue;
            f = effectParam.value[n];
        }
        n = 0;
        while (n2 > 2) {
            boolean bl = this.buildShader(n2, f, nArray[0]);
            n = bl ? 1 : 0;
            if (bl) break;
            ZmfVideo.logWarn("try gaussion radius2:" + (n2 -= 2));
        }
        if (!n) {
            ZmfVideo.logError("can't load gaussion blur shader");
        }
        this._hoffset = 2.0f / (float)layer.texWidth;
        this._voffset = 2.0f / (float)layer.texHeight;
        this._iterate = 3;
        return n != 0;
    }

    @Override
    boolean upload_param(int n, GLView.Layer layer) {
        EffectParam effectParam = layer.effect_param;
        if (n == 0) {
            for (int i = 0; i < effectParam.argc; ++i) {
                if (effectParam.name[i].equals("hoffset")) {
                    this._hoffset = effectParam.value[i] / (float)layer.texWidth;
                    continue;
                }
                if (effectParam.name[i].equals("voffset")) {
                    this._voffset = effectParam.value[i] / (float)layer.texHeight;
                    continue;
                }
                if (!effectParam.name[i].equals("iterate")) continue;
                this._iterate = (int)effectParam.value[i];
            }
        }
        this._offset[0] = (float)((double)this._hoffset * Math.cos(Math.PI * (double)n / (double)this._iterate));
        this._offset[1] = (float)((double)this._voffset * Math.sin(Math.PI * (double)n / (double)this._iterate));
        return true;
    }

    @Override
    float[] manual_ptr(String string) {
        return this._offset;
    }
}

