/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.opengl.GLES10;
import android.opengl.GLES20;
import com.justalk.cloud.zmf.GLView;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

abstract class EffectFx {
    static final int FA_VERTICES = 0;
    static final int FA_TEXCOORD = 1;
    static final int FS_MANUAL = 0;
    static final int FS_TRANSFORM = 1;
    static final int FS_TEXTURES = 2;
    private static final int[] _texIndex = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    protected int _iterate = 1;
    private int _program = 0;
    private int _refCount = 0;
    protected final int TEX_LAY_Y = -4;
    protected final int TEX_LAY_U = -3;
    protected final int TEX_LAY_V = -2;
    protected final int TEX_FBO = -1;
    protected int[] _texId = new int[]{-1};
    private final Map<String, Integer> _semantics = new HashMap<String, Integer>();
    private Map<String, FxUniform> _uniforms = new HashMap<String, FxUniform>();
    private Map<String, FxAttribute> _attributes = new HashMap<String, FxAttribute>();
    static final String _stdVert = "attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nuniform mat4 _mvp;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = _mvp*aPosition;\n  vTextureCoord = aTextureCoord;\n}";
    static final String _stdFrag = "precision mediump float;\nuniform sampler2D _tex;\nvarying vec2 vTextureCoord;\nvoid main(){\n   gl_FragColor = texture2D( _tex, vTextureCoord);\n}\n";
    static final String _stdEffectVert = "attribute vec4 aPosition;\nuniform mat4 _mvp;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = _mvp*aPosition;\n  vTextureCoord = gl_Position.xy*0.5+0.5;\n}\n";

    EffectFx() {
    }

    int iterate() {
        return this._iterate;
    }

    void unbind() {
        if (this._program != 0) {
            for (FxAttribute fxAttribute : this._attributes.values()) {
                GLES20.glDisableVertexAttribArray((int)fxAttribute.location);
            }
            for (int i = 0; i < this._texId.length; ++i) {
                GLES20.glActiveTexture((int)(33984 + i));
                GLES20.glBindTexture((int)3553, (int)0);
            }
            GLES20.glUseProgram((int)0);
            this.checkGlError("unbind");
        }
    }

    boolean bind(int n, int n2, float[] fArray, GLView.Layer layer) {
        if (n >= this._iterate) {
            return false;
        }
        if (this._program == 0 && !this.compile(layer)) {
            return false;
        }
        GLES20.glUseProgram((int)this._program);
        this.checkGlError("glUseProgram");
        if (!this.upload_param(n, layer)) {
            return false;
        }
        for (int i = 0; i < this._texId.length; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            if (this._texId[i] > 0) {
                GLES20.glBindTexture((int)3553, (int)this._texId[i]);
                continue;
            }
            if (this._texId[i] == -1) {
                GLES20.glBindTexture((int)3553, (int)n2);
                continue;
            }
            GLES20.glBindTexture((int)3553, (int)layer.texId[this._texId[i] - -4]);
        }
        for (FxAttribute object : this._attributes.values()) {
            switch (object.type) {
                case 0: {
                    GLES20.glVertexAttribPointer((int)object.location, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
                    break;
                }
                case 1: {
                    GLES20.glVertexAttribPointer((int)object.location, (int)2, (int)5126, (boolean)false, (int)0, (int)32);
                    break;
                }
                default: {
                    ZmfVideo.logError("unknown FxAttriType of vertex attributes:" + object.type);
                }
            }
            GLES20.glEnableVertexAttribArray((int)object.location);
        }
        block16: for (FxUniform fxUniform : this._uniforms.values()) {
            switch (fxUniform.semantic) {
                case 1: {
                    GLES20.glUniformMatrix4fv((int)fxUniform.location, (int)1, (boolean)false, (float[])fArray, (int)0);
                    continue block16;
                }
                case 2: {
                    GLES20.glUniform1iv((int)fxUniform.location, (int)fxUniform.arraySize, (int[])_texIndex, (int)0);
                    continue block16;
                }
                case 0: {
                    switch (fxUniform.glType) {
                        case 35664: {
                            GLES20.glUniform2fv((int)fxUniform.location, (int)fxUniform.arraySize, (float[])fxUniform.value, (int)0);
                            continue block16;
                        }
                        case 35665: {
                            GLES20.glUniform3fv((int)fxUniform.location, (int)fxUniform.arraySize, (float[])fxUniform.value, (int)0);
                            continue block16;
                        }
                        case 35666: {
                            GLES20.glUniform4fv((int)fxUniform.location, (int)fxUniform.arraySize, (float[])fxUniform.value, (int)0);
                            continue block16;
                        }
                    }
                    ZmfVideo.logError("unknown glType of manual uniform:" + fxUniform.glType);
                    continue block16;
                }
            }
            ZmfVideo.logError("unknown FxSemantic of uniform:" + fxUniform.semantic);
        }
        return true;
    }

    boolean build(String string) {
        int n;
        Object object;
        int n2;
        int n3;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        byte[] byArray = new byte[256];
        this._uniforms.clear();
        this._attributes.clear();
        if (this._program == 0) {
            return false;
        }
        GLES20.glGetProgramiv((int)this._program, (int)35718, (int[])nArray, (int)0);
        this.checkGlError("glGetProgramiv");
        for (n3 = 0; n3 < nArray[0]; ++n3) {
            Object object2;
            FxUniform fxUniform = new FxUniform();
            nArray3[0] = 0;
            GLES20.glGetActiveUniform((int)this._program, (int)n3, (int)256, (int[])nArray3, (int)0, (int[])nArray2, (int)0, (int[])nArray4, (int)0, (byte[])byArray, (int)0);
            this.checkGlError("glGetActiveUniform");
            if (nArray3[0] == 0) continue;
            String string2 = new String(byArray, 0, nArray3[0], Charset.forName("UTF8"));
            n2 = string2.indexOf("[");
            if (n2 >= 0) {
                object2 = string2.substring(0, n2);
                object = this._uniforms.get(object2);
                if (object != null) {
                    n = Integer.parseInt(string2.substring(n2 + 1, string2.indexOf("]", n2))) + 1;
                    if (((FxUniform)object).arraySize >= n) continue;
                    ((FxUniform)object).arraySize = n;
                    continue;
                }
                string2 = object2;
            }
            fxUniform.location = GLES20.glGetUniformLocation((int)this._program, (String)string2);
            this.checkGlError("glGetUniformLocation");
            if (fxUniform.location < 0) continue;
            fxUniform.glType = nArray4[0];
            fxUniform.arraySize = nArray2[0];
            object2 = this._semantics.get(string2);
            if (object2 == null) {
                if (string2.equals("_mvp")) {
                    fxUniform.semantic = 1;
                } else if (string2.equals("_tex")) {
                    fxUniform.semantic = 2;
                } else {
                    fxUniform.semantic = 0;
                    fxUniform.value = this.manual_ptr(string2);
                }
            } else {
                fxUniform.semantic = (Integer)object2;
            }
            this._uniforms.put(string2, fxUniform);
        }
        n3 = string.indexOf("attribute");
        if (n3 < 0) {
            n3 = string.indexOf("in");
            while (n3 >= 0 && n3 < string.length() && !Character.isWhitespace(string.charAt(n3 + 2))) {
                n3 = string.indexOf("in", n3 + 2);
            }
        }
        while (n3 >= 0) {
            int n4 = string.indexOf(59, n3);
            int n5 = 0;
            if (n4 < 0) {
                return false;
            }
            object = null;
            FxAttribute fxAttribute = new FxAttribute();
            for (n2 = n4 - 1; n2 > n3; --n2) {
                if (n5 > 0) {
                    if (!Character.isWhitespace(string.charAt(n2))) continue;
                    n = n2 + 1;
                    if (string.substring(n, n + 3).equals("vec")) {
                        String string3 = string.substring(n + 3, n + 4);
                        fxAttribute.size = Integer.parseInt(string3);
                    } else if (object == null) {
                        int n6 = n5 - n + 1;
                        object = string.substring(n, n + n6);
                    } else {
                        return false;
                    }
                    n5 = 0;
                    continue;
                }
                if (Character.isWhitespace(string.charAt(n2))) continue;
                n5 = n2;
            }
            fxAttribute.location = GLES20.glGetAttribLocation((int)this._program, object);
            if (fxAttribute.location >= 0) {
                fxAttribute.type = ((String)object).indexOf("Tex") >= 0 ? 1 : 0;
                this._attributes.put((String)object, fxAttribute);
            }
            if ((n3 = string.indexOf("attribute", n4 + 1)) >= 0) continue;
            n3 = string.indexOf("in", n4 + 1);
            while (n3 >= 0 && n3 < string.length() && !Character.isWhitespace(string.charAt(n3 + 2))) {
                n3 = string.indexOf("in", n3 + 2);
            }
        }
        return true;
    }

    boolean load(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0};
        this._program = 0;
        n = GLES20.glCreateShader((int)35633);
        GLES20.glShaderSource((int)n, (String)string);
        GLES20.glCompileShader((int)n);
        GLES20.glGetShaderiv((int)n, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            ZmfVideo.logError("Could not compile vertex shader:" + GLES20.glGetShaderInfoLog((int)n));
            GLES20.glDeleteShader((int)n);
            n = 0;
        } else {
            this.checkGlError("glCompileShader:vertexShader");
        }
        n2 = GLES20.glCreateShader((int)35632);
        GLES20.glShaderSource((int)n2, (String)string2);
        GLES20.glCompileShader((int)n2);
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            ZmfVideo.logError("Could not compile pixel shader:" + GLES20.glGetShaderInfoLog((int)n2));
            GLES20.glDeleteShader((int)n2);
            n2 = 0;
        } else {
            this.checkGlError("glCompileShader:pixelShader");
        }
        if (n != 0 && n2 != 0) {
            this._program = GLES20.glCreateProgram();
            GLES20.glAttachShader((int)this._program, (int)n);
            this.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)this._program, (int)n2);
            this.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)this._program);
            GLES20.glGetProgramiv((int)this._program, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] != 1) {
                ZmfVideo.logError("Could not link program:" + GLES20.glGetProgramInfoLog((int)this._program));
                GLES20.glDeleteProgram((int)this._program);
                this._program = 0;
            } else {
                this.checkGlError("glLinkProgram");
            }
        }
        boolean bl = this.build(string);
        if (n != 0) {
            if (this._program != 0) {
                GLES20.glDetachShader((int)this._program, (int)n);
            }
            GLES20.glDeleteShader((int)n);
            this.checkGlError("glDeleteShader:vertexShader");
        }
        if (n2 != 0) {
            if (this._program != 0) {
                GLES20.glDetachShader((int)this._program, (int)n2);
            }
            GLES20.glDeleteShader((int)n2);
            this.checkGlError("glDeleteShader:pixelShader");
        }
        return bl;
    }

    void checkGlError(String string) {
        int n;
        while ((n = GLES10.glGetError()) != 0) {
            ZmfVideo.logError(string + ": glError " + n);
        }
    }

    void prepare(GLView.Layer layer) {
        if (this._program == 0) {
            this.compile(layer);
        }
    }

    abstract boolean compile(GLView.Layer var1);

    boolean upload_param(int n, GLView.Layer layer) {
        return true;
    }

    float[] manual_ptr(String string) {
        return null;
    }

    boolean unref() {
        if (this._refCount > 0) {
            return --this._refCount == 0;
        }
        return false;
    }

    EffectFx ref() {
        ++this._refCount;
        return this;
    }

    protected void finalize() throws Throwable {
        if (this._refCount > 0) {
            ZmfVideo.logError("EffexFx unref() missing");
        }
        super.finalize();
    }

    void release() {
        if (this._program != 0) {
            GLES20.glDeleteProgram((int)this._program);
            this._program = 0;
            this.checkGlError("glDeleteProgram");
        }
        for (int i = 0; i < this._texId.length; ++i) {
            if (this._texId[i] <= 0) continue;
            GLES10.glDeleteTextures((int)1, (int[])this._texId, (int)i);
            this._texId[i] = 0;
            this.checkGlError("glDeleteTextures");
        }
    }

    class FxAttribute {
        int location;
        int size;
        int type;

        FxAttribute() {
        }
    }

    class FxUniform {
        int location;
        int arraySize;
        int glType;
        int semantic;
        float[] value;

        FxUniform() {
        }
    }
}

