/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import com.justalk.cloud.zmf.DeviceFilter;
import com.justalk.cloud.zmf.VideoCapture;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

@TargetApi(value=11)
class CamView
extends VideoCapture {
    private Device[] _devices = new Device[16];
    private SurfaceTexture _preview = new SurfaceTexture(0);

    CamView(Context context) {
        super(context);
        for (int i = 0; i < this._devices.length; ++i) {
            this._devices[i] = new Device();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int start(final String string, final int n, final int n2, final int n3) {
        final int n4 = this.getIndexById(string);
        if (n4 < 0 || n4 >= this._devices.length || this._devices[n4] == null) {
            return -1;
        }
        final Device device = this._devices[n4];
        Runnable runnable = device;
        synchronized (runnable) {
            if (device._camera != null || device._looper != null || device._captureId != null) {
                ZmfVideo.logError(string + " already started");
                return -1;
            }
            device._captureId = string;
        }
        runnable = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Looper.prepare();
                Device device2 = device;
                synchronized (device2) {
                    block6: {
                        if (device._captureId == null) {
                            return;
                        }
                        device._looper = Looper.myLooper();
                        Camera camera = null;
                        try {
                            camera = Camera.open((int)n4);
                            device.start(camera, n, n2, n3);
                        }
                        catch (Throwable throwable) {
                            Zmf._handler.removeCallbacks((Runnable)device);
                            Zmf.videoErrorOccurred("camera " + string + ":" + throwable.getLocalizedMessage());
                            if (camera == null) break block6;
                            camera.release();
                        }
                    }
                }
                Looper.loop();
            }
        });
        ((Thread)runnable).setPriority(3);
        ((Thread)runnable).start();
        Zmf._handler.postDelayed((Runnable)device, 10000L);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int stop(String string) {
        int n = this.getIndexById(string);
        if (n >= 0 && n < this._devices.length && this._devices[n] != null) {
            Device device;
            Device device2 = device = this._devices[n];
            synchronized (device2) {
                if (device._captureId != null) {
                    device.stop(n, string);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int stopAll() {
        for (int i = 0; i < this._devices.length; ++i) {
            Device device = this._devices[i];
            synchronized (device) {
                if (this._devices[i]._captureId != null) {
                    this._devices[i].stop(i, this._devices[i]._captureId);
                }
                continue;
            }
        }
        return 0;
    }

    @Override
    int rotate(String string, int n) {
        int n2 = this.getIndexById(string);
        if (n2 >= 0 && n2 < this._devices.length && this._devices[n2] != null) {
            Device device = this._devices[n2];
            device._rotateAngle = n;
            device._previewIncomed = false;
        }
        return 0;
    }

    @Override
    int effect(int n, JSONObject jSONObject, Object[] objectArray) {
        int n2 = 0;
        for (int i = 0; i < this._devices.length; ++i) {
            n2 = this._devices[i].effect(n, jSONObject, objectArray);
            if (n2 != -1) continue;
            return -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int focusAtPoint(String string, float[] fArray, int n, float f, float f2) {
        int n2 = this.getIndexById(string);
        if (n2 >= 0 && n2 < this._devices.length && this._devices[n2] != null) {
            Device device;
            Device device2 = device = this._devices[n2];
            synchronized (device2) {
                return device.focus(fArray, n, f, f2);
            }
        }
        return -1;
    }

    class Device
    implements Camera.PreviewCallback,
    Camera.ErrorCallback,
    Runnable {
        Looper _looper;
        Camera _camera;
        int _dir;
        int _camAngle;
        int _format;
        int _width;
        int _height;
        ByteBuffer _bufI420;
        ByteBuffer _previewBuf;
        int _rotateAngle;
        boolean _ownsBuffers;
        String _captureId;
        boolean _previewIncomed;
        int _deltime;
        long _lasttime;
        private int[] _croppedSize = new int[2];

        Device() {
        }

        int effect(int n, JSONObject jSONObject, Object[] objectArray) {
            String string = "";
            if (jSONObject != null) {
                string = jSONObject.toString();
            }
            return Zmf.onCaptureEnhance(n, string);
        }

        @Override
        public synchronized void run() {
            if (this._captureId != null) {
                if (this._camera == null) {
                    ZmfVideo.onErrorOccurred("camera " + this._captureId + ":disconnect");
                } else if (!this._previewIncomed) {
                    ZmfVideo.onErrorOccurred("camera " + this._captureId + ":timeout");
                }
            }
        }

        public synchronized void onError(int n, Camera camera) {
            if (this._captureId != null) {
                if (n == 100) {
                    ZmfVideo.onErrorOccurred("camera " + this._captureId + ":server died");
                } else {
                    ZmfVideo.onErrorOccurred("camera " + this._captureId + ":unknown");
                }
            }
        }

        public void onPreviewFrame(byte[] byArray, Camera camera) {
            int n;
            int n2;
            if (byArray == null) {
                return;
            }
            long l = SystemClock.elapsedRealtime();
            if (l - this._lasttime < (long)this._deltime) {
                if (l < this._lasttime) {
                    this._lasttime = l;
                }
                if (this._ownsBuffers) {
                    camera.addCallbackBuffer(byArray);
                }
                return;
            }
            do {
                this._lasttime += (long)this._deltime;
            } while (this._lasttime + (long)this._deltime <= l);
            int n3 = this._rotateAngle;
            if (!this._previewIncomed) {
                this._previewIncomed = true;
                this._croppedSize[0] = this._width & 0xFFFFFFF8;
                this._croppedSize[1] = this._height & 0xFFFFFFF8;
            }
            if (this._previewBuf == null || byArray.length > this._previewBuf.capacity()) {
                try {
                    this._previewBuf = ByteBuffer.allocateDirect(byArray.length).order(ByteOrder.nativeOrder());
                }
                catch (Throwable throwable) {
                    if (this._ownsBuffers) {
                        camera.addCallbackBuffer(byArray);
                    }
                    ZmfVideo.logError("Failed to allocateDirect()");
                    return;
                }
            }
            this._previewBuf.position(0);
            this._previewBuf.put(byArray);
            if (this._ownsBuffers) {
                camera.addCallbackBuffer(byArray);
            }
            if (Zmf.convertToI420(this._bufI420, this._format, this._previewBuf, this._width, this._height, n3, n2 = this._width - this._croppedSize[0] >> 1 & 0xFFFFFFFC, n = this._height - this._croppedSize[1] >> 1 & 0xFFFFFFFC, this._croppedSize) != 0) {
                ZmfVideo.logError("Zmf_ConvertToI420 failed");
                return;
            }
            int n4 = this._camAngle;
            n4 = (360 + n4 - n3) % 360;
            int n5 = ZmfVideo.captureOrientation();
            n5 = (n5 * this._dir + this._camAngle + 360) % 360;
            ZmfVideo.onCapture(this._captureId, this._dir == 1 ? 1 : 2, n5, n4, this._croppedSize, this._bufI420);
            if (n3 == 90 || n3 == 270) {
                int n6 = this._croppedSize[0];
                this._croppedSize[0] = this._croppedSize[1];
                this._croppedSize[1] = n6;
            }
        }

        @SuppressLint(value={"NewApi"})
        void start(Camera camera, int n, int n2, int n3) throws Exception {
            int n4;
            Object object;
            int n5;
            List<Camera.Size> list;
            int n6;
            this._deltime = 1000 / n3;
            this._lasttime = SystemClock.elapsedRealtime();
            if (n3 > 60) {
                n3 = 60;
            }
            this._previewIncomed = false;
            Camera.Parameters parameters = camera.getParameters();
            if (n * n2 >= 524288) {
                List list2 = parameters.getSupportedPreviewFormats();
                if (list2.contains(256)) {
                    parameters.setPreviewFormat(256);
                } else {
                    ZmfVideo.logWarn("video can't support mjpeg, FPS maybe slowly");
                }
            }
            if ((n6 = parameters.getPreviewFormat()) == 0) {
                list = parameters.getSupportedPreviewFormats();
                if (list.size() > 0) {
                    n6 = list.contains(17) ? 17 : (Integer)list.get(0);
                    parameters.setPreviewFormat(n6);
                }
                ZmfVideo.logInfo("unset preview format: change to " + n6);
            }
            switch (n6) {
                case 17: {
                    this._format = 13;
                    break;
                }
                case 20: {
                    this._format = 9;
                    break;
                }
                case 842094169: {
                    this._format = 10;
                    break;
                }
                case 4: {
                    this._format = 7;
                    break;
                }
                case 256: {
                    this._format = 12;
                    break;
                }
                case 35: {
                    this._format = 1;
                    break;
                }
                case 0: 
                case 16: {
                    throw new Exception("invalid format");
                }
            }
            ZmfVideo.logInfo("CamView enable preview format " + this._format);
            list = DeviceFilter.filterPreviewSizes(parameters.getSupportedPreviewSizes());
            int n7 = Integer.MAX_VALUE;
            for (Camera.Size object3 : list) {
                int nArray;
                n5 = (object3.width - n) * n2;
                int n13 = (object3.height - n2) * n;
                if (n5 < 0) {
                    n5 *= -2;
                }
                if (n13 < 0) {
                    n13 *= -2;
                }
                if ((nArray = n5 + n13) >= n7) continue;
                n7 = nArray;
                this._width = object3.width;
                this._height = object3.height;
            }
            parameters.setPreviewSize(this._width, this._height);
            ZmfVideo.logInfo("CamView enable preview size " + this._width + " x " + this._height);
            List list3 = parameters.getSupportedPreviewFpsRange();
            if (list3 == null) {
                List n10 = parameters.getSupportedPreviewFrameRates();
                Object nArray = 999;
                object = 0;
                for (Object object2 : n10) {
                    if ((Integer)object2 >= n3) {
                        nArray = Math.min((Integer)object2, (Integer)nArray);
                    }
                    object = Math.max((Integer)object2, (Integer)object);
                }
                if ((Integer)nArray == 999) {
                    nArray = object;
                }
                parameters.setPreviewFrameRate(((Integer)nArray).intValue());
                ZmfVideo.logInfo("CamView enable preview FPS " + nArray);
            } else {
                int n8;
                boolean list4 = false;
                n5 = 0;
                object = list3.iterator();
                while (object.hasNext()) {
                    int[] nArray = (int[])object.next();
                    if (n8 == 0 || n5 == 0) {
                        n8 = nArray[0];
                        n5 = nArray[1];
                        continue;
                    }
                    int n9 = n5 - n3 * 1000;
                    n4 = nArray[1] - n3 * 1000;
                    if (n9 == n4) {
                        if (n8 <= nArray[0]) continue;
                        n8 = nArray[0];
                        continue;
                    }
                    if (n9 >= 0 && n4 >= 0) {
                        if (n9 <= n4) continue;
                        n8 = nArray[0];
                        n5 = nArray[1];
                        continue;
                    }
                    if (n9 <= 0 && n4 <= 0) {
                        if (n9 >= n4) continue;
                        n8 = nArray[0];
                        n5 = nArray[1];
                        continue;
                    }
                    if (n9 >= 0) continue;
                    n8 = nArray[0];
                    n5 = nArray[1];
                }
                ZmfVideo.logInfo("CamView enable preview FPS " + n8 + " , " + n5);
                parameters.setPreviewFpsRange(n8, n5);
            }
            List list2 = parameters.getSupportedFocusModes();
            if (list2.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
                ZmfVideo.logInfo("CamView use continuous video focus mode");
            }
            if (Build.VERSION.SDK_INT >= 15) {
                if (parameters.isVideoStabilizationSupported()) {
                    ZmfVideo.logDebug("video stabilization default value " + parameters.getVideoStabilization());
                    parameters.setVideoStabilization(true);
                    ZmfVideo.logInfo("CamView enable video stabilization");
                } else {
                    ZmfVideo.logInfo("CamView video stabilization is not supported");
                }
            }
            int[] nArray = new int[3];
            CamView.this.getOrient(this._captureId, nArray);
            this._camAngle = nArray[1];
            this._dir = nArray[0] == 1 ? 1 : -1;
            if (Build.VERSION.SDK_INT >= 7) {
                Object object2;
                object = new PixelFormat();
                PixelFormat.getPixelFormatInfo((int)n6, (PixelFormat)object);
                int n10 = this._width * this._height * ((PixelFormat)object).bitsPerPixel / 8;
                object2 = null;
                for (n4 = 0; n4 < 3; ++n4) {
                    object2 = new byte[n10];
                    camera.addCallbackBuffer((byte[])object2);
                }
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
                this._ownsBuffers = true;
                if (VideoCapture._previewHolder != null) {
                    camera.setDisplayOrientation(nArray[2]);
                }
            } else {
                if (VideoCapture._previewHolder != null) {
                    parameters.setRotation(nArray[2]);
                }
                camera.setPreviewCallback((Camera.PreviewCallback)this);
                this._ownsBuffers = false;
            }
            int n11 = this._width * this._height * 3 / 2;
            if (this._bufI420 == null || n11 > this._bufI420.capacity()) {
                this._bufI420 = ByteBuffer.allocateDirect(n11).order(ByteOrder.nativeOrder());
            }
            camera.setParameters(parameters);
            if (VideoCapture._previewHolder != null) {
                camera.setPreviewDisplay(VideoCapture._previewHolder);
            } else {
                camera.setPreviewTexture(CamView.this._preview);
            }
            camera.startPreview();
            ZmfVideo.logInfo("CamView camera startPreview");
            this._camera = camera;
            this._camera.setErrorCallback((Camera.ErrorCallback)this);
        }

        void stop(int n, String string) {
            Zmf._handler.removeCallbacks((Runnable)this);
            if (this._looper != null) {
                this._looper.quit();
                this._looper = null;
            }
            if (this._camera != null) {
                try {
                    this._camera.stopPreview();
                    this._camera.setPreviewDisplay(null);
                    if (this._ownsBuffers) {
                        this._camera.setPreviewCallbackWithBuffer(null);
                    } else {
                        this._camera.setPreviewCallback(null);
                    }
                }
                catch (Throwable throwable) {
                    ZmfVideo.logError("Failed to setPreviewDisplay(null)");
                }
                this._camera.release();
                this._camera = null;
                ZmfVideo.onCaptureDidStop(string);
            }
            this._previewBuf = null;
            this._captureId = null;
        }

        int focus(float[] fArray, int n, float f, float f2) {
            ArrayList<Camera.Area> arrayList;
            float f3 = 0.0f;
            float f4 = 0.0f;
            if (this._dir == -1) {
                if (this._camAngle == 0) {
                    f3 = f;
                    f4 = f2;
                } else if (this._camAngle == 90) {
                    f3 = f2;
                    f4 = 1.0f - f;
                } else if (this._camAngle == 180) {
                    f3 = 1.0f - f;
                    f4 = 1.0f - f2;
                } else {
                    f3 = 1.0f - f2;
                    f4 = f;
                }
            } else if (this._camAngle == 0) {
                f3 = 1.0f - f;
                f4 = f2;
            } else if (this._camAngle == 90) {
                f3 = f2;
                f4 = f;
            } else if (this._camAngle == 180) {
                f3 = f;
                f4 = 1.0f - f2;
            } else {
                f3 = 1.0f - f2;
                f4 = 1.0f - f;
            }
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (n == 0) {
                f5 = f3 * ((float)this._croppedSize[0] - fArray[0] * 2.0f) + fArray[0];
                f6 = f4 * ((float)this._croppedSize[1] - fArray[1] * 2.0f) + fArray[1];
            } else if (Math.abs((double)f3 - 0.5) <= (double)fArray[2] / 2.0 && Math.abs((double)f4 - 0.5) <= (double)fArray[3] / 2.0) {
                f5 = (f3 - (1.0f - fArray[2]) / 2.0f) / fArray[2] * (float)this._croppedSize[0];
                f6 = (f4 - (1.0f - fArray[3]) / 2.0f) / fArray[3] * (float)this._croppedSize[1];
            } else {
                f5 = this._croppedSize[0] / 2;
                f6 = this._croppedSize[1] / 2;
                ZmfVideo.logInfo("focus at screen center");
            }
            Rect rect = this.calculateTapArea(f5, f6, 1.0f, this._width, this._height, this._croppedSize[0], this._croppedSize[1]);
            Rect rect2 = this.calculateTapArea(f5, f6, 1.5f, this._width, this._height, this._croppedSize[0], this._croppedSize[1]);
            if (this._camera == null) {
                return -1;
            }
            Camera.Parameters parameters = this._camera.getParameters();
            if (parameters.getMaxNumFocusAreas() > 0) {
                arrayList = new ArrayList<Camera.Area>();
                arrayList.add(new Camera.Area(rect, 700));
                parameters.setFocusMode("auto");
                parameters.setFocusAreas(arrayList);
            } else {
                ZmfVideo.logInfo("focus areas not supported");
            }
            if (parameters.getMaxNumMeteringAreas() > 0) {
                arrayList = new ArrayList();
                arrayList.add(new Camera.Area(rect2, 700));
                parameters.setMeteringAreas(arrayList);
            } else {
                ZmfVideo.logInfo("metering areas not supported");
            }
            this._camera.cancelAutoFocus();
            this._camera.setParameters(parameters);
            this._camera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean bl, Camera camera) {
                    if (bl) {
                        ZmfVideo.logInfo("success focus");
                    } else {
                        ZmfVideo.logInfo("focus failse");
                    }
                }
            });
            return 0;
        }

        Rect calculateTapArea(float f, float f2, float f3, int n, int n2, int n3, int n4) {
            float f4 = 200.0f;
            int n5 = (int)(f4 * f3);
            int n6 = 0;
            int n7 = 0;
            n6 = (int)(((double)f2 - 0.5 * (double)n4) / (double)n2 * 2000.0);
            n7 = (int)(((double)f - 0.5 * (double)n3) / (double)n * 2000.0);
            int n8 = n5 / 2;
            Rect rect = new Rect(this.clamp(n7 - n8, -1000, 1000), this.clamp(n6 - n8, -1000, 1000), this.clamp(n7 + n8, -1000, 1000), this.clamp(n6 + n8, -1000, 1000));
            return rect;
        }

        int clamp(int n, int n2, int n3) {
            if (n > n3) {
                return n3;
            }
            if (n < n2) {
                return n2;
            }
            return n;
        }
    }
}

