/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AutomaticGainControl;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.justalk.cloud.zmf.Audio;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfAudio;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class AudioStd
extends Audio {
    private AudioRecord _record;
    private AutomaticGainControl _AGC;
    private AcousticEchoCanceler _AEC;
    private ByteBuffer _micBuffer;
    private Thread _micThread;
    private String _micId;
    private int _micRateHz;
    private int _micChannel;
    private boolean _recording;
    private AudioTrack _track;
    private ByteBuffer _spkBuffer;
    private byte[] _spkTmpBuf;
    private Thread _spkThread;
    private String _spkId;
    private int _spkRateHz;
    private int _spkChannel;
    private int _sessionId;
    private boolean _playing;
    private AudioManager _audioMgr;

    AudioStd(Context context) {
        ZmfAudio.logInfo("Use Java Audio");
        this._audioMgr = (AudioManager)context.getSystemService("audio");
    }

    @Override
    @SuppressLint(value={"NewApi"})
    int inputStart(String string, int n, int n2, int n3, int n4) {
        int n5 = this.inputGetAudioSource(string);
        if (n5 < 0) {
            ZmfAudio.logError("invalid inputId");
            return -1;
        }
        if (this._recording || this._record != null) {
            ZmfAudio.logError("audio input already start!");
            return -1;
        }
        if (n <= 0) {
            n = 44100;
        }
        if (n2 <= 0) {
            n2 = 1;
        } else if (n2 > 2) {
            n2 = 2;
        }
        int n6 = n2 == 2 ? 12 : 16;
        int n7 = AudioRecord.getMinBufferSize((int)n, (int)n6, (int)2);
        int n8 = Build.VERSION.SDK_INT;
        if (n8 < 16) {
            n7 *= 2;
        }
        if (Build.MODEL.startsWith("MG101")) {
            n7 = Math.max(n7, 80 * n * 2 / 1000);
        }
        ZmfAudio.logInfo(Build.MODEL + " Audio Record Buffer: " + n7 + ", freq: " + n + ", channel:" + n2);
        try {
            this._record = new AudioRecord(n5, n, n6, 2, n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ZmfAudio.logError("Failed to create AudioRecord: " + illegalArgumentException.getMessage());
            return -1;
        }
        if (this._record == null) {
            ZmfAudio.logError("Failed to create AudioRecord");
            return -1;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                this._sessionId = this._record.getAudioSessionId();
                if (n4 >= 0 && AutomaticGainControl.isAvailable()) {
                    this._AGC = AutomaticGainControl.create((int)this._sessionId);
                    if (this._AGC != null) {
                        ZmfAudio.logInfo("OS AGC default " + this._AGC.getEnabled());
                        if (n4 != 0) {
                            this._AGC.setEnabled(true);
                        } else {
                            this._AGC.setEnabled(false);
                        }
                    }
                }
                if (n3 >= 0) {
                    if (AcousticEchoCanceler.isAvailable()) {
                        this._AEC = AcousticEchoCanceler.create((int)this._sessionId);
                        if (this._AEC != null) {
                            ZmfAudio.logInfo("OS AEC default " + this._AEC.getEnabled());
                            if (n3 != 0) {
                                this._AEC.setEnabled(true);
                                ZmfAudio.logInfo("OS AEC: " + this._AEC.getEnabled());
                            } else {
                                this._AEC.setEnabled(false);
                            }
                        } else {
                            ZmfAudio.logInfo("OS AEC failed to create: " + this._sessionId);
                        }
                    } else {
                        ZmfAudio.logInfo("OS AEC not available: " + this._sessionId);
                    }
                }
            }
            catch (Exception exception) {
                ZmfAudio.logError("Set AGC or AEC failed: " + exception.getMessage());
            }
        }
        if (this._record.getState() != 1) {
            this._record = null;
            if (this._AEC != null) {
                this._AEC.release();
                this._AEC = null;
            }
            if (this._AGC != null) {
                this._AGC.release();
                this._AGC = null;
            }
            ZmfAudio.logError("AudioRecord state !=  STATE_INITIALIZED");
            return -2;
        }
        this._micRateHz = this._record.getSampleRate();
        this._micChannel = n2;
        this._micId = string;
        this._record.startRecording();
        this._micBuffer = ByteBuffer.allocateDirect(this._micRateHz / 100 * 2 * this._micChannel).order(ByteOrder.nativeOrder());
        this._recording = true;
        this._micThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int n;
                AudioRecord audioRecord = AudioStd.this._record;
                try {
                    for (n = 0; AudioStd.this._recording && n < 10 && audioRecord.getRecordingState() != 3; ++n) {
                        Thread.sleep(200L);
                    }
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    ZmfAudio.logError("Set record thread priority failed: " + exception.getMessage());
                }
                n = 0;
                int n2 = 0;
                int n3 = 0;
                long l = SystemClock.elapsedRealtime();
                while (AudioStd.this._recording) {
                    int n4;
                    int n5 = 0;
                    int n6 = 0;
                    while (AudioStd.this._recording && n5 < AudioStd.this._micBuffer.capacity() && n6 >= 0) {
                        n6 = audioRecord.read((ByteBuffer)AudioStd.this._micBuffer.position(n5), AudioStd.this._micBuffer.capacity() - n5);
                        if (n6 <= 0) continue;
                        n5 += n6;
                    }
                    if (n6 < 0) {
                        if (!AudioStd.this._recording) break;
                        Zmf.audioErrorOccurred("input " + AudioStd.this._micId + ":read " + n6);
                        break;
                    }
                    if (n2 >= 0 && ++n >= 100) {
                        n = 0;
                        long l2 = SystemClock.elapsedRealtime();
                        long l3 = l2 - l;
                        if (l3 < 400L || l3 > 1600L) {
                            if (++n2 >= 10) {
                                n2 = -2;
                                if (AudioStd.this._recording) {
                                    Zmf.audioErrorOccurred("input " + AudioStd.this._micId + ":invalid ms " + l3);
                                }
                            }
                        } else {
                            n2 = 0;
                        }
                        l = l2;
                    }
                    if (AudioStd.this._recording) {
                        ZmfAudio.onInput(AudioStd.this._micId, AudioStd.this._micRateHz, AudioStd.this._micChannel, AudioStd.this._micBuffer, 0, 0, 0);
                    }
                    if (n3 < 0 || n5 < 4) continue;
                    for (n4 = (n5 / 4 - 1) * 4; n4 >= 0 && AudioStd.this._recording && AudioStd.this._micBuffer.getInt(n4) == 0; n4 -= 4) {
                    }
                    if (n4 < 0 && AudioStd.this._recording) {
                        if ((n3 += AudioStd.this._micRateHz / 100) < AudioStd.this._micRateHz * 15) continue;
                        n3 = -2;
                        if (!AudioStd.this._recording) continue;
                        Zmf.audioErrorOccurred("input " + AudioStd.this._micId + ":mute audio ");
                        continue;
                    }
                    n3 = -1;
                }
                if (audioRecord != null) {
                    if (audioRecord.getState() != 0 && audioRecord.getRecordingState() != 1) {
                        try {
                            audioRecord.stop();
                        }
                        catch (IllegalStateException illegalStateException) {
                            ZmfAudio.logError("AudioRecord stop failed: " + illegalStateException.getMessage());
                        }
                    }
                    audioRecord.release();
                }
            }
        });
        this._micThread.start();
        return 0;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    int inputStop(String string) {
        if (!this._recording || this._micId == null || !this._micId.equals(string)) {
            return -1;
        }
        this._recording = false;
        this._sessionId = 0;
        try {
            this._micThread.join(100L);
        }
        catch (InterruptedException interruptedException) {
            ZmfAudio.logError("AudioRecord Thread join failed: " + interruptedException.getMessage());
        }
        this._micThread = null;
        this._record = null;
        if (this._AEC != null) {
            this._AEC.release();
            this._AEC = null;
        }
        if (this._AGC != null) {
            this._AGC.release();
            this._AGC = null;
        }
        ZmfAudio.onInputDidStop(string);
        return 0;
    }

    @Override
    int inputStopAll() {
        if (this._recording && this._micId != null) {
            return this.inputStop(this._micId);
        }
        return 0;
    }

    @Override
    @TargetApi(value=17)
    int outputStart(String string, int n, int n2) {
        int n3 = this.outputGetStreamType(string);
        if (n3 < 0) {
            ZmfAudio.logError("invalid outputId");
            return -1;
        }
        if (this._playing || this._track != null) {
            ZmfAudio.logError("audio output already start!");
            return -1;
        }
        if (n <= 0) {
            n = 16000;
        }
        if (n2 <= 0) {
            n2 = 1;
        } else if (n2 > 2) {
            n2 = 2;
        }
        int n4 = n2 == 2 ? 12 : 4;
        int n5 = AudioTrack.getMinBufferSize((int)n, (int)n4, (int)2);
        if (Build.VERSION.SDK_INT < 16) {
            n5 *= 2;
        }
        ZmfAudio.logInfo(Build.MODEL + " AudioTrack Buffer: " + n5 + ", freq: " + n + ", channel:" + n2);
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                this._track = new AudioTrack(n3, n, n4, 2, n5, 1, this._sessionId);
                ZmfAudio.logInfo("create audio track " + this._sessionId);
            } else {
                this._track = new AudioTrack(n3, n, n4, 2, n5, 1);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ZmfAudio.logError("Failed to create AudioTrack: " + illegalArgumentException.getMessage());
            return -1;
        }
        if (this._track == null) {
            ZmfAudio.logError("Failed to create AudioTrack");
            return -1;
        }
        if (this._track.getState() != 1) {
            this._track = null;
            ZmfAudio.logError("AudioTrack state !=  STATE_INITIALIZED");
            return -2;
        }
        this._spkRateHz = this._track.getSampleRate();
        this._spkChannel = n2;
        this._spkId = string;
        this._track.play();
        this._spkBuffer = ByteBuffer.allocateDirect(this._spkRateHz / 100 * 2 * this._spkChannel).order(ByteOrder.nativeOrder());
        if (!(this._spkBuffer.hasArray() || this._spkTmpBuf != null && this._spkTmpBuf.length >= this._spkBuffer.capacity())) {
            this._spkTmpBuf = new byte[this._spkBuffer.capacity()];
        }
        this._playing = true;
        this._spkThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AudioTrack audioTrack = AudioStd.this._track;
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    ZmfAudio.logError("Set play thread priority failed: " + exception.getMessage());
                }
                boolean bl = true;
                while (AudioStd.this._playing && bl) {
                    ZmfAudio.onOutput(AudioStd.this._spkId, AudioStd.this._spkRateHz, AudioStd.this._spkChannel, AudioStd.this._spkBuffer);
                    try {
                        int n = 0;
                        block11: while (bl && AudioStd.this._playing && n < AudioStd.this._spkBuffer.capacity()) {
                            int n2;
                            if (AudioStd.this._spkBuffer.hasArray()) {
                                n2 = audioTrack.write(AudioStd.this._spkBuffer.array(), n + AudioStd.this._spkBuffer.arrayOffset(), AudioStd.this._spkBuffer.capacity() - n);
                            } else {
                                AudioStd.this._spkBuffer.rewind();
                                AudioStd.this._spkBuffer.get(AudioStd.this._spkTmpBuf);
                                n2 = audioTrack.write(AudioStd.this._spkTmpBuf, n, AudioStd.this._spkBuffer.capacity() - n);
                            }
                            switch (n2) {
                                case -3: {
                                    bl = false;
                                    ZmfAudio.logError("Invalid AudioTrack.write()");
                                    continue block11;
                                }
                                case -2: {
                                    bl = false;
                                    ZmfAudio.logError("Bad arguments to AudioTrack.write()");
                                    continue block11;
                                }
                            }
                            n += n2;
                        }
                    }
                    catch (Exception exception) {
                        bl = false;
                        ZmfAudio.logError("AudioTrack write failed: " + exception.getMessage());
                    }
                }
                if (audioTrack.getState() != 0 && audioTrack.getPlayState() != 1) {
                    try {
                        audioTrack.stop();
                    }
                    catch (IllegalStateException illegalStateException) {
                        ZmfAudio.logError("AudioTrack stop failed: " + illegalStateException.getMessage());
                    }
                }
                audioTrack.release();
            }
        });
        this._spkThread.start();
        return 0;
    }

    @Override
    int outputStop(String string) {
        if (!this._playing || this._spkId == null || !this._spkId.equals(string)) {
            return -1;
        }
        this._playing = false;
        try {
            this._spkThread.join(100L);
        }
        catch (InterruptedException interruptedException) {
            ZmfAudio.logError("AudioTrack Thread join failed: " + interruptedException.getMessage());
        }
        this._spkThread = null;
        ZmfAudio.onOutputDidStop(string);
        this._track = null;
        return 0;
    }

    @Override
    int outputStopAll() {
        if (this._playing && this._spkId != null) {
            return this.outputStop(this._spkId);
        }
        return 0;
    }
}

