/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.avatar;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.justalk.cloud.avatar.ZpandTimer;
import java.util.UUID;

public class ZpandDevice {
    private static final String TAG = ZpandDevice.class.getName();
    private static final String ID = "id";
    private static final String UUID_KEY = "uuid";

    public static String getId() {
        Context context = ZpandTimer.sContext;
        SharedPreferences sharedPreferences = context.getSharedPreferences(TAG, 0);
        String string = sharedPreferences.getString(ID, null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        string = ZpandDevice.getIMEI(context);
        if (TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)(string = ZpandDevice.getSerial())) && TextUtils.isEmpty((CharSequence)(string = ZpandDevice.getMac(context))) && TextUtils.isEmpty((CharSequence)(string = ZpandDevice.getAndroidId(context)))) {
            string = UUID.randomUUID().toString();
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(ID, string);
            editor.apply();
        }
        return string;
    }

    public static String getUuid() {
        Context context = ZpandTimer.sContext;
        SharedPreferences sharedPreferences = context.getSharedPreferences(TAG, 0);
        String string = sharedPreferences.getString(UUID_KEY, null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        string = UUID.randomUUID().toString();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(UUID_KEY, string);
            editor.apply();
        }
        return string;
    }

    private static String getIMEI(Context context) {
        try {
            String string;
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null && !TextUtils.isEmpty((CharSequence)(string = telephonyManager.getDeviceId()))) {
                return "IMEI" + string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static String getSerial() {
        String string = Build.PRODUCT;
        if (!TextUtils.isEmpty((CharSequence)string) && !"unknown".equals(string)) {
            String string2 = Build.SERIAL;
            if (!TextUtils.isEmpty((CharSequence)string) && !"unknown".equals(string2)) {
                return "PRODUCT" + string + "SERIAL" + string2;
            }
        }
        return null;
    }

    private static String getMac(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return null;
        }
        try {
            String string;
            WifiInfo wifiInfo;
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null && !TextUtils.isEmpty((CharSequence)(string = wifiInfo.getMacAddress()))) {
                return "MAC" + string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static String getAndroidId(Context context) {
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return "ANDROIDID" + string;
        }
        return null;
    }
}

