/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.avatar;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.SystemClock;

public class ZpandTimer {
    private static int sType = 2;
    private static String sAction;
    private static AlarmManager sAlarmManager;
    private static BroadcastReceiver sTimerReceiver;
    static Context sContext;

    public static void init(Context context, String string) {
        sContext = context;
        sAction = "com.justalk.cloud.avatar.ACTION_TIMER." + string;
        sTimerReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ZpandTimer.active();
            }
        };
        context.registerReceiver(sTimerReceiver, new IntentFilter(sAction));
        sAlarmManager = (AlarmManager)context.getSystemService("alarm");
        ZpandTimer.doInit();
    }

    public static void destroy() {
        ZpandTimer.doDestroy();
        sAlarmManager = null;
        sContext.unregisterReceiver(sTimerReceiver);
        sTimerReceiver = null;
        sContext = null;
    }

    public static void setWakeup(boolean bl) {
        sType = bl ? 2 : 3;
    }

    private static void start(long l) {
        sAlarmManager.set(sType, SystemClock.elapsedRealtime() + l, ZpandTimer.timerOperation(sContext));
    }

    private static void stop() {
        sAlarmManager.cancel(ZpandTimer.timerOperation(sContext));
    }

    private static PendingIntent timerOperation(Context context) {
        Intent intent = new Intent(sAction);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    private static native void doInit();

    private static native void doDestroy();

    private static native void active();

    static {
        sTimerReceiver = null;
    }
}

