/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.media.AudioManager;
import android.os.Build;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientCallback;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCMediaDevice;
import com.juphoon.cloud.JCMediaDeviceCallback;
import com.juphoon.cloud.JCMediaDeviceVideoCanvas;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.ZmfEngine;
import com.justalk.cloud.lemon.MtcCallDb;
import com.justalk.cloud.lemon.MtcNumber;
import com.justalk.cloud.zmf.ZmfVideo;
import java.util.ArrayList;
import java.util.List;

class JCMediaDeviceImpl
extends JCMediaDevice
implements JCClientCallback {
    static final String TAG = JCMediaDeviceImpl.class.getSimpleName();
    private List<JCMediaDeviceCallback> mCallbacks = new ArrayList<JCMediaDeviceCallback>();
    private JCClient mClient;
    private int mDefaultCameraIndex;
    private int mCameraIndex;
    private boolean mCameraOpen;
    private boolean mAudioStart;
    private boolean mSpeakerOn;
    private int mWidth;
    private int mHeight;
    private int mFramerate;
    private int mScreenCaptureWidth;
    private int mScreenCaptureHeight;
    private int mScreenCaptureFrameRate;
    private List<JCMediaDeviceVideoCanvas> mCameraCanvas = new ArrayList<JCMediaDeviceVideoCanvas>();
    private List<JCMediaDeviceVideoCanvas> mOtherCanvas = new ArrayList<JCMediaDeviceVideoCanvas>();
    private List<String> mCameras;
    private AudioManager mAudioManager;
    private boolean mSawtooth;
    private int mAecMode;
    private int mVideoMode;

    JCMediaDeviceImpl(JCClient client, JCMediaDeviceCallback callback) {
        JCParam.Init param = new JCParam.Init();
        param.context = client.getContext();
        ZmfEngine.getInstance().initialize(param);
        this.mCameraOpen = false;
        this.mAudioStart = false;
        this.mSpeakerOn = false;
        this.mSawtooth = false;
        this.mAecMode = 2;
        this.mVideoMode = 0;
        this.mWidth = 352;
        this.mHeight = 282;
        this.mFramerate = 10;
        this.mScreenCaptureWidth = 640;
        this.mScreenCaptureHeight = 360;
        this.mScreenCaptureFrameRate = 10;
        this.mCameras = ZmfEngine.getInstance().getCameras();
        if (this.mCameras.size() > 0) {
            this.mCameraIndex = 0;
            this.mDefaultCameraIndex = 0;
        } else {
            this.mCameraIndex = -1;
            this.mDefaultCameraIndex = -1;
        }
        this.mClient = client;
        this.mCallbacks.add(callback);
        this.mClient.addCallback(this);
        this.mAudioManager = (AudioManager)this.mClient.getContext().getSystemService("audio");
    }

    @Override
    protected void destroyObj() {
        this.mCameras.clear();
        this.mCallbacks.clear();
        this.mClient.removeCallback(this);
        this.mClient = null;
        ZmfEngine.getInstance().uninitialize();
    }

    @Override
    public boolean isCameraOpen() {
        return this.mCameraOpen;
    }

    @Override
    public boolean isSpeakerOn() {
        return this.mSpeakerOn;
    }

    @Override
    public String getCamera() {
        if (this.mCameraIndex >= 0 && this.mCameraIndex < this.mCameras.size()) {
            return this.mCameras.get(this.mCameraIndex);
        }
        return null;
    }

    @Override
    public List<String> getCameras() {
        return this.mCameras;
    }

    @Override
    public JCMediaDeviceVideoCanvas startCameraVideo(int renderType) {
        if (this.mCameras.size() == 0) {
            return null;
        }
        JCMediaDeviceVideoCanvas canvas = new JCMediaDeviceVideoCanvas(this.mClient.getContext(), this.mCameras.get(this.mCameraIndex), renderType);
        canvas.autoRotate = this.autoRotate;
        canvas.resume();
        this.mCameraCanvas.add(canvas);
        this.startCamera();
        return canvas;
    }

    @Override
    public JCMediaDeviceVideoCanvas startVideo(String videoSource, int renderType) {
        JCMediaDeviceVideoCanvas canvas = new JCMediaDeviceVideoCanvas(this.mClient.getContext(), videoSource, renderType);
        canvas.autoRotate = this.autoRotate;
        canvas.resume();
        this.mOtherCanvas.add(canvas);
        return canvas;
    }

    @Override
    public void stopVideo(JCMediaDeviceVideoCanvas canvas) {
        canvas.pause();
        if (this.mCameraCanvas.contains(canvas)) {
            this.mCameraCanvas.remove(canvas);
            if (this.mCameraCanvas.size() == 0) {
                JCLog.info(TAG, "\u65e0\u672c\u5730\u89c6\u9891\u5bf9\u8c61", new Object[0]);
                this.stopCamera();
            }
        } else {
            this.mOtherCanvas.remove(canvas);
        }
    }

    @Override
    public boolean startAudio() {
        if (this.mAudioStart) {
            JCLog.info(TAG, "\u5df2\u7ecf\u6253\u5f00\u97f3\u9891", new Object[0]);
        } else {
            JCParam.AudioDeal param = new JCParam.AudioDeal();
            param.start = true;
            param.watch = this.mVideoMode == 0 || this.mVideoMode == 1;
            boolean bl = param.os = this.mAecMode != 1;
            if (ZmfEngine.getInstance().dealAudio((JCParam.AudioDeal)param).succ) {
                JCLog.info(TAG, "\u6253\u5f00\u97f3\u9891", new Object[0]);
            } else {
                JCLog.info(TAG, "\u6253\u5f00\u97f3\u9891\u5931\u8d25", new Object[0]);
            }
            this.mAudioManager.setMode(this.getAudioMode());
            this.mAudioStart = true;
        }
        return this.mAudioStart;
    }

    @Override
    public boolean stopAudio() {
        if (this.mAudioStart) {
            JCParam.AudioDeal param = new JCParam.AudioDeal();
            param.start = false;
            if (ZmfEngine.getInstance().dealAudio((JCParam.AudioDeal)param).succ) {
                JCLog.info(TAG, "\u5173\u95ed\u97f3\u9891", new Object[0]);
            } else {
                JCLog.info(TAG, "\u5173\u95ed\u97f3\u9891\u5931\u8d25", new Object[0]);
            }
            this.mAudioManager.setMode(0);
            this.mAudioStart = false;
        } else {
            JCLog.info(TAG, "\u5df2\u7ecf\u5173\u95ed\u97f3\u9891", new Object[0]);
        }
        return !this.mAudioStart;
    }

    @Override
    public boolean startCamera() {
        if (this.mCameraOpen) {
            JCLog.info(TAG, "\u6444\u50cf\u5934\u5df2\u6253\u5f00", new Object[0]);
            return true;
        }
        this.mCameraIndex = this.mDefaultCameraIndex;
        JCParam.CameraDeal param = new JCParam.CameraDeal();
        param.type = 0;
        param.camera = this.mCameras.get(this.mCameraIndex);
        param.width = this.mWidth;
        param.height = this.mHeight;
        param.framerate = this.mFramerate;
        if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
            JCLog.info(TAG, "\u6444\u50cf\u5934\u6253\u5f00", new Object[0]);
            this.mCameraOpen = true;
            this.notifyCameraUpdate();
            return true;
        }
        JCLog.error(TAG, "\u6444\u50cf\u5934\u6253\u5f00\u5931\u8d25", new Object[0]);
        return false;
    }

    @Override
    public boolean stopCamera() {
        if (this.mCameraOpen) {
            JCParam.CameraDeal param = new JCParam.CameraDeal();
            param.type = 1;
            param.camera = this.mCameras.get(this.mCameraIndex);
            if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
                JCLog.info(TAG, "\u6444\u50cf\u5934\u5173\u95ed", new Object[0]);
            } else {
                JCLog.error(TAG, "\u6444\u50cf\u5934\u5931\u8d25", new Object[0]);
            }
            this.mCameraOpen = false;
            this.mCameraIndex = this.mDefaultCameraIndex;
        } else {
            JCLog.info(TAG, "\u6444\u50cf\u5934\u5df2\u5173\u95ed", new Object[0]);
        }
        return true;
    }

    @Override
    public boolean switchCamera() {
        if (this.mCameraOpen) {
            JCParam.CameraDeal param = new JCParam.CameraDeal();
            param.type = 2;
            param.switchedCamera = this.mCameras.get(this.mCameraIndex);
            this.mCameraIndex = (this.mCameraIndex + 1) % this.mCameras.size();
            param.camera = this.mCameras.get(this.mCameraIndex);
            if (this.mCameras.size() == 0) {
                return false;
            }
            if (this.mCameras.size() == 1) {
                JCLog.info(TAG, "\u53ea\u6709\u4e00\u4e2a\u6444\u50cf\u5934", new Object[0]);
                return true;
            }
            param.width = this.mWidth;
            param.height = this.mHeight;
            param.framerate = this.mFramerate;
            if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
                for (JCMediaDeviceVideoCanvas canvas : this.mCameraCanvas) {
                    canvas.switchCamera(param.camera);
                }
                this.notifyCameraUpdate();
                return true;
            }
            JCLog.error(TAG, "\u5207\u6362\u6444\u50cf\u5934\u5931\u8d25", new Object[0]);
        } else {
            JCLog.error(TAG, "\u672a\u6253\u5f00\u5207\u6362\u6444\u50cf\u5934", new Object[0]);
        }
        return false;
    }

    @Override
    public void specifyCamera(int cameraIndex) {
        if (cameraIndex >= 0 && cameraIndex < this.mCameras.size()) {
            this.mDefaultCameraIndex = cameraIndex;
        }
    }

    @Override
    public void setCameraProperty(int width, int height, int frameRate) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFramerate = frameRate;
    }

    @Override
    public void setScreenCaptureProperty(int width, int height, int frameRate) {
        this.mScreenCaptureWidth = width;
        this.mScreenCaptureHeight = height;
        this.mScreenCaptureFrameRate = frameRate;
    }

    @Override
    public int getCameraType(int cameraIndex) {
        if (cameraIndex >= 0 && cameraIndex < this.mCameras.size()) {
            if (this.mCameras.get(cameraIndex).equals(ZmfVideo.CaptureFront())) {
                return 1;
            }
            if (this.mCameras.get(cameraIndex).equals(ZmfVideo.CaptureBack())) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    @Override
    public void enableSpeaker(boolean enable) {
        if (this.mSpeakerOn != enable) {
            this.mSpeakerOn = enable;
            this.mAudioManager.setSpeakerphoneOn(this.mSpeakerOn);
            this.notifyAudioOutputTypeChange();
        }
    }

    @Override
    public void setVideoMode(int videoMode, JCMediaDevice.VideoModeOtherParam otherParam) {
        JCLog.info(TAG, "setVideoMode %d", videoMode);
        this.mVideoMode = videoMode;
        if (this.mVideoMode == 0) {
            this.mWidth = 352;
            this.mHeight = 282;
            this.mFramerate = 10;
        } else if (this.mVideoMode == 1) {
            this.mWidth = 352;
            this.mHeight = 282;
            this.mFramerate = 10;
        } else {
            this.mWidth = 640;
            this.mHeight = 480;
            this.mFramerate = this.mVideoMode == 3 ? 30 : 10;
        }
        this.configMeidaParam(otherParam);
    }

    @Override
    public int getVideoMode() {
        return this.mVideoMode;
    }

    @Override
    public void setAecMode(int aecMode) {
        this.mAecMode = aecMode;
    }

    @Override
    public int getAecMode() {
        return this.mAecMode;
    }

    @Override
    public void setSawtooth(boolean sawtooth) {
        this.mSawtooth = sawtooth;
    }

    @Override
    protected void addCallback(JCMediaDeviceCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    protected void removeCallback(JCMediaDeviceCallback callback) {
        this.mCallbacks.remove(callback);
    }

    @Override
    protected void configMeidaParam(JCMediaDevice.VideoModeOtherParam otherParam) {
        JCLog.info(TAG, "configMeidaParam videoMode=%d", this.mVideoMode);
        MtcCallDb.Mtc_CallDbSetAnUsePresetVideoParams((boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"PCMU", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"G722", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"AMR-WB", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"PCMA", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"iLBC", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"opus", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"AMR", (boolean)true);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"G729", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecByPriority((String)"AMR", (short)0);
        MtcCallDb.Mtc_CallDbSetArsEnable((boolean)true);
        MtcCallDb.Mtc_CallDbSetVoiceArsParam((int)12000, (int)2000);
        MtcCallDb.Mtc_CallDbSetVadEnable((boolean)true);
        MtcCallDb.Mtc_CallDbSetAudioRed((boolean)false);
        MtcCallDb.Mtc_CallDbSetRxAnrEnable((boolean)false);
        MtcNumber Aec = new MtcNumber();
        MtcNumber Anr = new MtcNumber();
        MtcNumber Agc = new MtcNumber();
        MtcNumber Vad = new MtcNumber();
        MtcCallDb.Mtc_CallDbGetAudioQos((MtcNumber)Aec, (MtcNumber)Anr, (MtcNumber)Agc, (MtcNumber)Vad);
        boolean bAec = false;
        boolean bAgc = false;
        boolean bVad = false;
        if (Aec.getValue() != 0) {
            bAec = true;
        }
        if (Agc.getValue() != 0) {
            bAgc = true;
        }
        if (Vad.getValue() != 0) {
            bVad = true;
        }
        MtcCallDb.Mtc_CallDbSetAudioRtxEnable((boolean)false);
        MtcCallDb.Mtc_CallDbSetSrtpCryptoType((int)0);
        MtcCallDb.Mtc_CallDbSetAecMode((short)(this.mAecMode == 0 ? (short)1 : 4));
        MtcCallDb.Mtc_CallDbSetResolutionControl((boolean)false);
        MtcCallDb.Mtc_CallDbSetVideoArs((boolean)true);
        MtcCallDb.Mtc_CallDbSetSmallNaluEnable((boolean)true);
        MtcCallDb.Mtc_CallDbSetVideoRedFec((boolean)false);
        MtcCallDb.Mtc_CallDbSetVideoFramerate((int)this.mFramerate);
        if (this.mVideoMode == 0 || this.mVideoMode == 1) {
            if (this.mSawtooth) {
                MtcCallDb.Mtc_CallDbSetAnVideoRecvResolution((int)240, (int)240);
            } else {
                MtcCallDb.Mtc_CallDbSetAnVideoRecvResolution((int)174, (int)144);
            }
            if (this.mVideoMode == 0) {
                MtcCallDb.Mtc_CallDbSetVideoArsParm((int)80000, (int)10000, (int)0, (int)0);
                MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate((int)50);
            } else {
                MtcCallDb.Mtc_CallDbSetVideoArsParm((int)200000, (int)10000, (int)0, (int)0);
                MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate((int)150);
            }
            if (this.mVideoMode == 0) {
                MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (boolean)false, (boolean)true);
            } else {
                MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (boolean)true, (boolean)true);
            }
        } else if (this.mVideoMode == 2) {
            MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (boolean)false, (boolean)true);
            MtcCallDb.Mtc_CallDbSetAnVideoRecvResolution((int)this.mWidth, (int)this.mHeight);
            if (this.mFramerate >= 15 || this.mSawtooth) {
                MtcCallDb.Mtc_CallDbSetVideoArsParm((int)120000, (int)10000, (int)0, (int)0);
            } else {
                MtcCallDb.Mtc_CallDbSetVideoArsParm((int)80000, (int)10000, (int)0, (int)0);
            }
            MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate((int)50);
        } else {
            MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (boolean)true, (boolean)true);
            MtcCallDb.Mtc_CallDbSetAnUsePresetVideoParams((boolean)true);
            MtcCallDb.Mtc_CallDbSetVoiceArsParam((int)75000, (int)20000);
            MtcCallDb.Mtc_CallDbSetVideoArsParm((int)1500000, (int)50000, (int)0, (int)0);
            MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate((int)800);
        }
        if (otherParam != null && otherParam.agc != -1) {
            MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (otherParam.agc > 0 ? 1 : 0) != 0, (boolean)true);
        }
    }

    @Override
    public void onLogin(boolean result, int reason) {
    }

    @Override
    public void onLogout(int reason) {
    }

    @Override
    public void onClientStateChange(int state, int oldState) {
    }

    private void notifyCameraUpdate() {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u6444\u50cf\u5934\u53d8\u6362", new Object[0]);
                for (JCMediaDeviceCallback callback : JCMediaDeviceImpl.this.mCallbacks) {
                    callback.onCameraUpdate();
                }
            }
        });
    }

    private void notifyAudioOutputTypeChange() {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u626c\u58f0\u5668\u6539\u53d8", new Object[0]);
                for (JCMediaDeviceCallback callback : JCMediaDeviceImpl.this.mCallbacks) {
                    callback.onAudioOutputTypeChange(JCMediaDeviceImpl.this.mSpeakerOn);
                }
            }
        });
    }

    private int getAudioMode() {
        if (Build.VERSION.SDK_INT < 11) {
            return 0;
        }
        return 3;
    }

    @Override
    protected boolean enableScreenCapture(boolean enable) {
        JCParam.CameraDeal param = new JCParam.CameraDeal();
        if (enable) {
            param.type = 0;
            param.camera = ZmfVideo.CaptureScreen;
            param.width = this.mScreenCaptureWidth;
            param.height = this.mScreenCaptureHeight;
            param.framerate = this.mScreenCaptureFrameRate;
            if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
                JCLog.info(TAG, "\u5c4f\u5e55\u5171\u4eabCapture\u5f00\u542f\u6210\u529f", new Object[0]);
                return true;
            }
            JCLog.error(TAG, "\u5c4f\u5e55\u5171\u4eabCapture\u5f00\u542f\u5931\u8d25", new Object[0]);
            return false;
        }
        param.type = 1;
        param.camera = ZmfVideo.CaptureScreen;
        if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
            JCLog.info(TAG, "\u5c4f\u5e55\u5171\u4eabCapture\u5173\u95ed\u6210\u529f", new Object[0]);
            return true;
        }
        JCLog.error(TAG, "\u5c4f\u5e55\u5171\u4eabCapture\u5173\u95ed\u5931\u8d25", new Object[0]);
        return false;
    }
}

