/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.content.Context;
import android.text.TextUtils;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientCallback;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCNet;
import com.juphoon.cloud.JCNetCallback;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.MtcEngine;
import com.justalk.cloud.lemon.MtcCli;
import com.justalk.cloud.lemon.MtcCliConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class JCClientImpl
extends JCClient
implements MtcCliConstants,
MtcEngine.MtcNotifyListener,
JCNetCallback {
    Context mContext;
    private List<JCClientCallback> mCallbacks = new ArrayList<JCClientCallback>();
    private String mUserId;
    private String mServer;
    private String mAppKey;
    private String mDeviceId;
    private String mUid;
    private int mState;

    JCClientImpl(Context context, String appKey, JCClientCallback callback, Map<String, String> extraParams) {
        JCLog.info(TAG, "\u521b\u5efa", new Object[0]);
        if (context == null) {
            throw new RuntimeException("JCClient Context cannot be null!");
        }
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            throw new RuntimeException("JCClient app key cannot be empty!");
        }
        if (callback == null) {
            throw new RuntimeException("JCClient callback cannot be null!");
        }
        this.mContext = context.getApplicationContext();
        this.mState = 0;
        JCParam.Init param = new JCParam.Init();
        param.context = this.mContext;
        if (extraParams != null) {
            if (extraParams.containsKey("create_extra_sdk_info_dir")) {
                param.sdkInfoDir = extraParams.get("create_extra_sdk_info_dir");
            }
            if (extraParams.containsKey("create_extra_sdk_log_dir")) {
                param.sdkLogDir = extraParams.get("create_extra_sdk_log_dir");
            }
        }
        if (MtcEngine.getInstance().initialize((JCParam.Init)param).succ) {
            JCLog.info(TAG, "SDK\u521d\u59cb\u5316\u6210\u529f", new Object[0]);
            this.mServer = "http:cn.router.justalkcloud.com:8080";
            this.mState = 1;
            this.mCallbacks.add(callback);
            this.mAppKey = appKey;
            MtcEngine.getInstance().addMtcNotifyListener(this);
            JCNet.getInstance().initialize(this.mContext);
            JCNet.getInstance().addCallback(this);
        } else {
            JCLog.error(TAG, "SDK\u521d\u59cb\u5316\u5931\u8d25", new Object[0]);
        }
    }

    @Override
    protected void destroyObj() {
        this.mCallbacks.clear();
        MtcEngine.getInstance().removeMtcNotifyListener(this);
        JCNet.getInstance().removeCallback(this);
        JCNet.getInstance().uninitialize();
        MtcEngine.getInstance().uninitialize();
    }

    @Override
    public void setForeground(final boolean foreground) {
        JCClientThreadImpl.getInstance().postDelayed(new Runnable(){

            @Override
            public void run() {
                JCNet.getInstance().updateNetType();
                MtcEngine.getInstance().setForeground(foreground);
            }
        }, 1000L);
    }

    @Override
    public String getUserId() {
        return this.mUserId;
    }

    @Override
    public boolean setConfig(String key, String value) {
        boolean ret = true;
        if (key.equals("config_key_server_address")) {
            this.mServer = value;
        } else if (key.equals("config_key_device_id")) {
            this.mDeviceId = value;
        } else {
            ret = false;
        }
        return ret;
    }

    @Override
    public String getConfig(String key) {
        if (key.equals("config_key_server_address")) {
            return this.mServer;
        }
        if (key.equals("config_key_device_id")) {
            return TextUtils.isEmpty((CharSequence)this.mDeviceId) ? MtcEngine.getInstance().getDeviceId() : this.mDeviceId;
        }
        return "";
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public boolean login(String userId, String password) {
        if (this.mState == 0) {
            JCLog.info(TAG, "login SDK\u672a\u521d\u59cb\u5316", new Object[0]);
            this.notifyLogin(false, 1);
        } else if (this.mState == 1) {
            if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)password)) {
                JCLog.error(TAG, "\u8d26\u53f7\u5bc6\u7801\u5185\u5bb9\u65e0\u6548", new Object[0]);
                this.notifyLogin(false, 2);
                return false;
            }
            String format = "^[A-Za-z0-9_+][A-Za-z0-9_+.-]{1,64}$";
            if (!userId.matches(format)) {
                JCLog.error(TAG, "\u8d26\u53f7\u4e0d\u7b26\u5408\u89c4\u5219", new Object[0]);
                this.notifyLogin(false, 2);
                return false;
            }
            this.mUserId = userId;
            JCParam.Login param = new JCParam.Login();
            param.username = userId;
            param.password = password;
            param.server = this.mServer;
            param.appkey = this.mAppKey;
            param.deviceId = this.mDeviceId;
            param.autoCreate = true;
            if (MtcEngine.getInstance().login((JCParam.Login)param).succ) {
                JCLog.info(TAG, "\u8fdb\u884c\u767b\u5f55", new Object[0]);
                this.setState(2);
                return true;
            }
            JCLog.info(TAG, "\u767b\u9646\u8c03\u7528\u5931\u8d25", new Object[0]);
            this.notifyLogin(false, 3);
        } else {
            if (this.mState == 3) {
                JCLog.info(TAG, "\u5df2\u767b\u5f55", new Object[0]);
                this.notifyLogin(true, 0);
                return true;
            }
            if (this.mState == 2) {
                MtcCli.Mtc_CliRefresh();
                return true;
            }
            JCLog.info(TAG, "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u884c\u767b\u5f55", new Object[0]);
            this.notifyLogin(false, 4);
        }
        return false;
    }

    @Override
    public boolean logout() {
        if (this.mState > 1) {
            if (MtcEngine.getInstance().logout((JCParam.Logout)new JCParam.Logout()).succ) {
                JCLog.info(TAG, "\u767b\u51fa", new Object[0]);
            } else {
                this.notifyLogout(0);
            }
        } else {
            JCLog.info(TAG, "\u5f53\u524d\u5df2\u767b\u51fa", new Object[0]);
            this.notifyLogout(0);
        }
        return true;
    }

    @Override
    public void onNotify(JCNotify notify) {
        if (notify.type == 0) {
            if (notify.cliNotify.type == 1) {
                this.mUid = notify.cliNotify.loginOk.uid;
                this.notifyLogin(true, 0);
                this.setState(3);
            } else if (notify.cliNotify.type == 2) {
                this.notifyLogin(false, this.translateFromMtc(notify.cliNotify.loginFail.statusCode));
                this.setState(1);
            } else if (notify.cliNotify.type == 3) {
                this.notifyLogout(0);
                this.setState(1);
            } else if (notify.cliNotify.type == 4) {
                this.notifyLogout(this.translateFromMtc(notify.cliNotify.logouted.statusCode));
                this.setState(1);
            } else if (notify.cliNotify.type == 5) {
                this.setState(2);
            } else if (notify.cliNotify.type == 6) {
                this.setState(3);
            }
        }
    }

    @Override
    public void onNetChange(int newNetType, int oldNetType) {
        JCLog.info(TAG, "onNetChange", new Object[0]);
        JCParam.Net param = new JCParam.Net();
        param.type = 0;
        param.newNetType = this.translateToMtcNetType(newNetType);
        param.oldNetType = this.translateToMtcNetType(oldNetType);
        MtcEngine.getInstance().netChange(param);
    }

    @Override
    protected Context getContext() {
        return this.mContext;
    }

    @Override
    protected void addCallback(JCClientCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    protected void removeCallback(JCClientCallback callback) {
        this.mCallbacks.remove(callback);
    }

    void notifyLogin(final boolean result, final int reason) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(JCClient.TAG, "\u767b\u9646\u7ed3\u679c:%b \u539f\u56e0:%d", result, reason);
                for (JCClientCallback callback : JCClientImpl.this.mCallbacks) {
                    callback.onLogin(result, reason);
                }
            }
        });
    }

    void notifyLogout(final int reason) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(JCClient.TAG, "\u767b\u51fa\u539f\u56e0:%d", reason);
                for (JCClientCallback callback : JCClientImpl.this.mCallbacks) {
                    callback.onLogout(reason);
                }
            }
        });
    }

    void notifyStateChange(final int state, final int oldState) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(JCClient.TAG, "\u72b6\u6001 %d->%d", oldState, state);
                for (JCClientCallback callback : JCClientImpl.this.mCallbacks) {
                    callback.onClientStateChange(state, oldState);
                }
            }
        });
    }

    void setState(int state) {
        if (this.mState != state) {
            int old = this.mState;
            this.mState = state;
            this.notifyStateChange(this.mState, old);
        }
    }

    int translateFromMtc(int code) {
        switch (code) {
            case 57600: {
                return 0;
            }
            case 57603: {
                return 8;
            }
            case 57604: {
                return 9;
            }
            case 57605: {
                return 5;
            }
            case 57611: {
                return 6;
            }
            case 57619: {
                return 7;
            }
            case 57612: {
                return 10;
            }
        }
        return 100;
    }

    private int translateToMtcNetType(int type) {
        if (type == 2) {
            return 0;
        }
        if (type == 1) {
            return 256;
        }
        return -2;
    }
}

