/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCStorageCallback;
import com.juphoon.cloud.JCStorageImpl;
import com.juphoon.cloud.JCStorageItem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class JCStorage {
    public static final int REASON_NONE = 0;
    public static final int REASON_NOT_LOGIN = 1;
    public static final int REASON_TIMEOUT = 2;
    public static final int REASON_NETWORK = 3;
    public static final int REASON_TOOLARGE = 4;
    public static final int REASON_EXPIRE = 5;
    public static final int REASON_OTHER = 100;
    public static final int ITEM_STATE_INIT = 0;
    public static final int ITEM_STATE_TRANSFERRING = 1;
    public static final int ITEM_STATE_OK = 2;
    public static final int ITEM_STATE_FAIL = 3;
    public static final int ITEM_STATE_CANCEL = 4;
    public static final int DIRECTION_UPLOAD = 0;
    public static final int DIRECTION_DOWNLOAD = 1;
    static final int MAX_FILE_SIZE = 0x6400000;
    static final int FILE_EXIPIRE = 604800;
    private static JCStorage sStorage;

    public static JCStorage create(JCClient client, JCStorageCallback callback) {
        if (sStorage != null) {
            return sStorage;
        }
        sStorage = new JCStorageImpl(client, callback);
        return sStorage;
    }

    public static void destroy() {
        if (sStorage != null) {
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    sStorage.destroyObj();
                    sStorage = null;
                }
            });
        }
    }

    protected abstract void destroyObj();

    public abstract JCStorageItem uploadFile(String var1);

    public abstract JCStorageItem downloadFile(String var1, String var2);

    public abstract boolean cancelFile(JCStorageItem var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ItemDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ItemState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StorageReason {
    }
}

