/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCNetCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

class JCNet {
    static final String TAG = JCNet.class.getSimpleName();
    static final int UNAVAILABLE = 0;
    static final int WIFI = 1;
    static final int MOBILE = 2;
    static final int ETHERNET = 3;
    private Context mContext;
    private int mNetType;
    private List<JCNetCallback> mCallbacks = new ArrayList<JCNetCallback>();
    private BroadcastReceiver mNetworkChangedReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            JCNet.this.updateNetType();
        }
    };

    JCNet() {
    }

    static JCNet getInstance() {
        return NetworkManagerHolder.INSTANCE;
    }

    void initialize(Context appContext) {
        if (appContext == null) {
            throw new RuntimeException("Context should not be null!");
        }
        this.mContext = appContext.getApplicationContext();
        this.mContext.registerReceiver(this.mNetworkChangedReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.mNetType = this.getNetTypeInternal();
    }

    void uninitialize() {
        if (this.mContext != null) {
            this.mContext.getApplicationContext().unregisterReceiver(this.mNetworkChangedReceiver);
        }
    }

    int getNetType() {
        return this.mNetType;
    }

    void addCallback(JCNetCallback callback) {
        this.mCallbacks.add(callback);
    }

    void removeCallback(JCNetCallback callback) {
        this.mCallbacks.remove(callback);
    }

    void updateNetType() {
        int old = this.mNetType;
        this.mNetType = this.getNetTypeInternal();
        if (old != this.mNetType) {
            JCLog.info(TAG, "\u72b6\u6001 %d->%d", old, this.mNetType);
            for (JCNetCallback h : this.mCallbacks) {
                h.onNetChange(this.mNetType, old);
            }
        }
    }

    private int getNetTypeInternal() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info == null || !info.isConnected()) {
            return 0;
        }
        int netType = info.getType();
        if (netType == 1) {
            return 1;
        }
        if (netType == 0) {
            return 2;
        }
        if (netType == 9) {
            return 3;
        }
        return 0;
    }

    private static final class NetworkManagerHolder {
        private static final JCNet INSTANCE = new JCNet();

        private NetworkManagerHolder() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetType {
    }
}

