/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Bundle;
import android.util.Log;
import com.justalk.cloud.zmf.H264Codec;
import com.justalk.cloud.zmf.H265Codec;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfCodec;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

@SuppressLint(value={"NewApi"})
public class ZmfMediaCodec
extends ZmfCodec {
    protected static final int MEDIA_CODEC_OK = 0;
    protected static final String KEY_CODEC_NAME = "codec-name";
    protected static final String KEY_START_FLAGS = "start-flags";
    protected static final int BUFFER_FLAG_TRY_AGAIN = 4096;
    protected static final String KEY_STRIDE = "stride";
    protected static final String KEY_SLICE_HEIGHT = "slice-height";
    protected static final String KEY_LEVEL = "level";
    protected static final String KEY_CROP_LEFT = "crop-left";
    protected static final String KEY_CROP_RIGHT = "crop-right";
    protected static final String KEY_CROP_TOP = "crop-top";
    protected static final String KEY_CROP_BOTTOM = "crop-bottom";
    protected String TAG = "ZMC";
    private static final int DEQUEUE_BUFFER_TIMEOUT_US = 100000;
    private static final int START_DEQUEUE_BUFFER_TIMEOUT_US = 1000000;
    private MediaCodec.BufferInfo mInBufferInfo = null;
    private MediaCodec.BufferInfo mOutBufferInfo = null;
    private MediaCodec mOMX = null;
    private ZmfMediaCodec mInstance = null;
    private MediaFormat mInputFormat = null;
    private volatile boolean mStarted = false;
    private int mKeyRequestCount = 0;
    private Thread mOutputThread = null;
    private BlockingDeque mOutputQueue = null;
    private ByteBuffer mConfigBuffer = null;
    private ByteBuffer mOutBuf;
    private int mInputFrameNum;
    private int mOutputFrameNum;

    protected final int MEDIA_CODEC_ERROR(String string) {
        Log.e((String)this.TAG, (String)string);
        return -1;
    }

    protected final int MEDIA_CODEC_ERROR(Exception exception) {
        Log.e((String)this.TAG, (String)"exception", (Throwable)exception);
        return -1;
    }

    public ZmfMediaCodec() {
    }

    protected ZmfMediaCodec(String string) {
        this.mInBufferInfo = new MediaCodec.BufferInfo();
        this.mOutBufferInfo = new MediaCodec.BufferInfo();
        this.mOutputQueue = new LinkedBlockingDeque();
        if (string != null) {
            this.TAG = string;
        }
    }

    protected int resetMediaCodec(long l) {
        return -1;
    }

    protected ByteBuffer onInputBuffer(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, MediaCodec mediaCodec) {
        return null;
    }

    protected ByteBuffer onOutputBuffer(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        return null;
    }

    protected void onOutputFormatChanged(MediaFormat mediaFormat) {
    }

    protected int startMediaCodec(MediaFormat mediaFormat, int n) {
        if (this.mStarted) {
            return 0;
        }
        this.mInputFormat = mediaFormat;
        this.mInputFormat.setInteger(KEY_START_FLAGS, n);
        return 0;
    }

    protected int stopMediaCodec() {
        if (this.mInputFormat == null) {
            return 0;
        }
        this.mInputFormat = null;
        if (this.mOMX != null && this.mStarted) {
            Log.i((String)this.TAG, (String)"begin stop");
            this.mStarted = false;
            try {
                this.mOutputThread.join(5000L);
            }
            catch (Exception exception) {
                Log.i((String)this.TAG, (String)"failed to stop output thread");
            }
            Log.i((String)this.TAG, (String)"stop OK");
        }
        return 0;
    }

    public static void register(String[] stringArray, boolean bl) {
        try {
            for (String string : stringArray) {
                String[] stringArray2 = string.split("\\.");
                if (stringArray2.length >= 2 && stringArray2[stringArray2.length - 2].equals("H264") && H264Codec.isSupported(bl)) {
                    if (Zmf.codecGetClass(string) != null) continue;
                    Zmf.codecRegister(string, ZmfMediaCodec.class);
                    continue;
                }
                if (stringArray2.length < 2 || !stringArray2[stringArray2.length - 2].equals("H265") || !H265Codec.isSupported(bl) || Zmf.codecGetClass(string) != null) continue;
                Zmf.codecRegister(string, ZmfMediaCodec.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deregister(String[] stringArray) {
        for (String string : stringArray) {
            Zmf.codecDeregister(string);
        }
    }

    @Override
    protected int init(boolean bl, String string, long l, long l2) {
        this.TAG = string + (bl ? "ENC" : "DEC");
        if (this.mInBufferInfo != null) {
            return super.init(bl, string, l, l2);
        }
        if (string.contains("H264")) {
            this.mInstance = new H264Codec();
            return this.mInstance.init(bl, string, l, l2);
        }
        if (string.contains("H265")) {
            this.mInstance = new H265Codec();
            return this.mInstance.init(bl, string, l, l2);
        }
        return this.MEDIA_CODEC_ERROR("invalid " + string);
    }

    @Override
    protected void codecDone(ByteBuffer byteBuffer, int n, long l, boolean bl) {
        if (this.mInstance != null) {
            this.mInstance.codecDone(byteBuffer, n, l, bl);
        } else {
            super.codecDone(byteBuffer, n, l, bl);
        }
    }

    @Override
    protected int set(int n, int n2) {
        if (this.mInstance != null) {
            return this.mInstance.set(n, n2);
        }
        return this.MEDIA_CODEC_ERROR("invalid set " + n);
    }

    @Override
    protected int set(int n, byte[] byArray) {
        if (this.mInstance != null) {
            return this.mInstance.set(n, byArray);
        }
        return this.MEDIA_CODEC_ERROR("invalid set " + n);
    }

    @Override
    protected int get(int n) {
        if (this.mInstance != null) {
            return this.mInstance.get(n);
        }
        return this.MEDIA_CODEC_ERROR("invalid get" + n);
    }

    @Override
    protected int get(int n, byte[] byArray) {
        if (this.mInstance != null) {
            return this.mInstance.get(n, byArray);
        }
        return this.MEDIA_CODEC_ERROR("invalid get" + n);
    }

    @Override
    protected int release() {
        if (this.mInstance != null) {
            return this.mInstance.release();
        }
        if (this.mOMX == null) {
            return 0;
        }
        Log.i((String)this.TAG, (String)"begin release");
        this.stopMediaCodec();
        if (this.mOMX != null) {
            this.mOMX.release();
            this.mOMX = null;
        }
        Log.i((String)this.TAG, (String)"release OK");
        return 0;
    }

    @Override
    protected int reset(long l) {
        if (this.mInstance != null) {
            return this.mInstance.reset(l);
        }
        return this.resetMediaCodec(l);
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (ZmfMediaCodec.this.mStarted) {
                    ZmfMediaCodec.this.deliverOutput();
                }
                ZmfMediaCodec.this.stopCodec();
            }
        };
    }

    private void stopCodec() {
        try {
            this.mOMX.stop();
        }
        catch (Exception exception) {
            Log.i((String)this.TAG, (String)"Media codec stop failed");
        }
        try {
            this.mOMX.release();
        }
        catch (Exception exception) {
            Log.i((String)this.TAG, (String)"Media codec release failed");
        }
        this.mOMX = null;
        this.mOutputQueue.clear();
        Log.i((String)this.TAG, (String)"cleared output queue");
    }

    private void deliverOutput() {
        int n;
        MediaCodec mediaCodec = this.mOMX;
        try {
            this.mOutBufferInfo.flags = 0;
            n = mediaCodec.dequeueOutputBuffer(this.mOutBufferInfo, 100000L);
        }
        catch (MediaCodec.CodecException codecException) {
            this.MEDIA_CODEC_ERROR((Exception)((Object)codecException));
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.MEDIA_CODEC_ERROR(illegalStateException.toString());
            return;
        }
        if (n == -2) {
            this.onOutputFormatChanged(mediaCodec.getOutputFormat());
            return;
        }
        if (n < 0) {
            return;
        }
        ByteBuffer byteBuffer = mediaCodec.getOutputBuffer(n);
        if (byteBuffer == null) {
            mediaCodec.releaseOutputBuffer(n, false);
            this.MEDIA_CODEC_ERROR("getOutputBuffer null");
            return;
        }
        byteBuffer.position(this.mOutBufferInfo.offset);
        byteBuffer.limit(this.mOutBufferInfo.offset + this.mOutBufferInfo.size);
        if (this.isEncoder()) {
            if ((this.mOutBufferInfo.flags & 2) != 0) {
                Log.i((String)this.TAG, (String)("Config frame generated. Offset: " + this.mOutBufferInfo.offset + ". Size: " + this.mOutBufferInfo.size));
                this.mConfigBuffer = ByteBuffer.allocateDirect(this.mOutBufferInfo.size);
                this.mConfigBuffer.put(byteBuffer);
            } else {
                ByteBuffer byteBuffer2;
                boolean bl;
                boolean bl2 = bl = (this.mOutBufferInfo.flags & 1) != 0;
                if (bl) {
                    Log.i((String)this.TAG, (String)("Prepending config frame of size " + this.mConfigBuffer.capacity() + " to output buffer with offset " + this.mOutBufferInfo.offset + ", size " + this.mOutBufferInfo.size));
                    byteBuffer2 = ByteBuffer.allocateDirect(this.mOutBufferInfo.size + this.mConfigBuffer.capacity());
                    this.mConfigBuffer.rewind();
                    byteBuffer2.put(this.mConfigBuffer);
                } else {
                    byteBuffer2 = ByteBuffer.allocateDirect(this.mOutBufferInfo.size);
                }
                byteBuffer2.put(byteBuffer);
                byteBuffer2.rewind();
                this.codecDone(byteBuffer2, byteBuffer2.capacity(), (Long)this.mOutputQueue.poll(), true);
                ++this.mOutputFrameNum;
            }
        } else {
            byteBuffer = this.onOutputBuffer(byteBuffer, this.mOutBufferInfo);
            long l = this.mOutBufferInfo.presentationTimeUs / 1000L * 90L;
            Object e = this.mOutputQueue.poll();
            if (e != null) {
                l = (Long)e;
            }
            if (byteBuffer != null && this.mOutBufferInfo.size > 0) {
                this.codecDone(byteBuffer, this.mOutBufferInfo.size, l, true);
            }
            ++this.mOutputFrameNum;
        }
        mediaCodec.releaseOutputBuffer(n, false);
    }

    @Override
    protected int enqueue(ByteBuffer byteBuffer, long l, long l2, boolean bl) {
        int n;
        if (this.mInstance != null) {
            return this.mInstance.enqueue(byteBuffer, l, l2, bl);
        }
        if (this.mInputFormat == null) {
            return this.MEDIA_CODEC_ERROR("wait for input format");
        }
        MediaCodec mediaCodec = this.mOMX;
        boolean bl2 = false;
        if (!this.mStarted) {
            try {
                Log.i((String)this.TAG, (String)"begin start");
                Log.i((String)this.TAG, (String)this.mInputFormat.toString());
                if (this.mOMX == null) {
                    if (this.mInputFormat.containsKey(KEY_CODEC_NAME)) {
                        this.mOMX = MediaCodec.createByCodecName((String)this.mInputFormat.getString(KEY_CODEC_NAME));
                    } else {
                        String string = this.mInputFormat.getString("mime");
                        this.mOMX = this.isEncoder() ? MediaCodec.createEncoderByType((String)string) : MediaCodec.createDecoderByType((String)string);
                    }
                }
                n = this.mInputFormat.getInteger(KEY_START_FLAGS);
                this.mOMX.configure(this.mInputFormat, null, null, n);
                this.mOMX.start();
                bl2 = true;
                this.mInputFrameNum = 0;
                this.mOutputFrameNum = 0;
                this.mKeyRequestCount = 0;
                Log.i((String)this.TAG, (String)"start OK");
                mediaCodec = this.mOMX;
            }
            catch (Exception exception) {
                if (this.mOMX != null) {
                    this.mOMX.release();
                }
                this.mOMX = null;
                return this.MEDIA_CODEC_ERROR(exception);
            }
            this.mStarted = true;
            this.mOutputThread = this.createOutputThread();
            this.mOutputThread.start();
        }
        if (mediaCodec == null) {
            return 0;
        }
        if (!bl) {
            return this.MEDIA_CODEC_ERROR("invalid stream");
        }
        long l3 = l / 90L * 1000L;
        int n2 = -1;
        int n3 = 5;
        do {
            n = 0;
            --n3;
            try {
                ByteBuffer byteBuffer2;
                n2 = mediaCodec.dequeueInputBuffer(bl2 ? 1000000L : 100000L);
                if (n2 < 0) {
                    n = 1;
                    continue;
                }
                if (this.isEncoder() && this.mOutputQueue.size() > 2) {
                    Log.i((String)this.TAG, (String)("encode input buffer full " + this.mOutputQueue.size()));
                    return 0;
                }
                this.mInBufferInfo.flags = 0;
                if ((byteBuffer = this.onInputBuffer(byteBuffer, this.mInBufferInfo, mediaCodec)) == null) {
                    return this.MEDIA_CODEC_ERROR("onInputBuffer null");
                }
                if ((this.mInBufferInfo.flags & 1) != 0) {
                    if (this.isEncoder()) {
                        byteBuffer2 = new Bundle(1);
                        byteBuffer2.putInt("request-sync", 0);
                        try {
                            ++this.mKeyRequestCount;
                            mediaCodec.setParameters((Bundle)byteBuffer2);
                            Log.i((String)this.TAG, (String)("KEY_REQUEST_SYNC_FRAME " + this.mKeyRequestCount));
                        }
                        catch (Exception exception) {
                            return this.MEDIA_CODEC_ERROR(exception);
                        }
                    } else {
                        Log.i((String)this.TAG, (String)"input keyframe.");
                    }
                }
                if ((byteBuffer2 = mediaCodec.getInputBuffer(n2)) == null) {
                    return this.MEDIA_CODEC_ERROR("getInputBuffer null");
                }
                this.mInBufferInfo.offset = byteBuffer2.position();
                this.mOutputQueue.offer(l2);
                byteBuffer2.put(byteBuffer);
                mediaCodec.queueInputBuffer(n2, this.mInBufferInfo.offset, this.mInBufferInfo.size, l3, this.mInBufferInfo.flags);
            }
            catch (MediaCodec.CodecException codecException) {
                if (codecException.isTransient()) {
                    n = 1;
                    continue;
                }
                return this.MEDIA_CODEC_ERROR((Exception)((Object)codecException));
            }
            catch (IllegalStateException illegalStateException) {
                return this.MEDIA_CODEC_ERROR(illegalStateException.toString());
            }
        } while (n != 0 && n3 > 0);
        if (n2 < 0 || n != 0) {
            return this.MEDIA_CODEC_ERROR("null InputBuffer");
        }
        ++this.mInputFrameNum;
        if (this.mInputFrameNum % 100 == 0) {
            Log.i((String)this.TAG, (String)("Frame count: input" + this.mInputFrameNum + "; output " + this.mOutputFrameNum));
        }
        return 0;
    }
}

