/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import com.justalk.cloud.zmf.ZmfAudio;
import com.justalk.cloud.zmf.ZmfCodec;
import com.justalk.cloud.zmf.ZmfMediaCodec;
import com.justalk.cloud.zmf.ZmfObserver;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class Zmf {
    static final int PIXEL_AUTO = 0;
    static final int PIXEL_I420 = 1;
    static final int PIXEL_IYUV = 2;
    static final int PIXEL_RGB24 = 3;
    static final int PIXEL_ABGR = 4;
    static final int PIXEL_ARGB = 5;
    static final int PIXEL_ARGB4444 = 6;
    static final int PIXEL_RGB565 = 7;
    static final int PIXEL_ARGB1555 = 8;
    static final int PIXEL_YUY2 = 9;
    static final int PIXEL_YV12 = 10;
    static final int PIXEL_UYVY = 11;
    static final int PIXEL_MJPG = 12;
    static final int PIXEL_NV21 = 13;
    static final int PIXEL_NV12 = 14;
    static final int PIXEL_BGRA = 15;
    private static Map<String, Class> _codecsMap = new HashMap<String, Class>();
    static final int LOG_DEBUG = 0;
    static final int LOG_INFO = 1;
    static final int LOG_WARN = 2;
    static final int LOG_ERROR = 3;
    static int _refCount = 0;
    static final Handler _handler = new Handler();
    static WeakHashMap<ZmfObserver, Object> sObservers;
    public static final int AudioInputRequestStart = 1;
    public static final int AudioInputRequestStop = 2;
    public static final int AudioInputDidStart = 3;
    public static final int AudioOutputRequestStart = 4;
    public static final int AudioOutputRequestStop = 5;
    public static final int AudioOutputDidStart = 6;
    public static final int AudioErrorOccurred = 7;
    public static final String AudioInput = "AudioInput";
    public static final String AudioOutput = "AudioOutput";
    public static final String SamplingRate = "SamplingRate";
    public static final String ChannelNumber = "ChannelNumber";
    public static final String AutoGainControl = "AutoGainControl";
    public static final String AcousticEchoCancel = "AcousticEchoCancel";
    public static final String AudioError = "AudioError";
    public static final int VideoCaptureRequestStart = 20;
    public static final int VideoCaptureRequestChange = 30;
    public static final int VideoCaptureRequestStop = 21;
    public static final int VideoCaptureDidStart = 22;
    public static final int VideoRenderRequestAdd = 25;
    public static final int VideoRenderDidReceive = 26;
    public static final int VideoRenderDidStart = 27;
    public static final int VideoRenderDidResize = 28;
    public static final int VideoRenderRequestRemove = 29;
    public static final int VideoErrorOccurred = 31;
    public static final int VideoCaptureStatus = 33;
    public static final String Capture = "Capture";
    public static final String Face = "Face";
    public static final String Width = "Width";
    public static final String Height = "Height";
    public static final String Angle = "Angle";
    public static final String Render = "Render";
    public static final String SourceType = "SourceType";
    public static final String Window = "Window";
    public static final String FrameRate = "FrameRate";
    public static final String VideoError = "VideoError";
    public static final String Exposure = "Exposure";
    public static final String Brightness = "Brightness";
    public static final String Backlot = "Backlot";
    public static final String BUILTIN_DECODER_H264 = "zmf.builtin.H264.decoder";
    public static final String BUILTIN_ENCODER_H264 = "zmf.builtin.H264.encoder";
    public static final String BUILTIN_DECODER_H265 = "zmf.builtin.H265.decoder";
    public static final String BUILTIN_ENCODER_H265 = "zmf.builtin.H265.encoder";
    public static final String DECODER_H264 = "H264.decoder";
    public static final String ENCODER_H264 = "H264.encoder";
    public static final String DECODER_H265 = "H265.decoder";
    public static final String ENCODER_H265 = "H265.encoder";
    public static final String FILE_ENCODER_H264 = "FILE.H264.encoder";
    static String[] BUILTIN_CODECS;

    private static int audioInputGetCount() {
        return ZmfAudio.inputGetCount();
    }

    private static String[] audioInputGetName(int n) {
        String[] stringArray = new String[2];
        ZmfAudio.inputGetName(n, stringArray);
        return stringArray;
    }

    private static int audioInputStart(String string, int n, int n2, int n3, int n4) {
        return ZmfAudio.inputStart(string, n, n2, n3, n4);
    }

    private static int audioInputStop(String string) {
        return ZmfAudio.inputStop(string);
    }

    private static int audioInputStopAll() {
        return ZmfAudio.inputStopAll();
    }

    private static void audioOutputRequestStart(final String string, final int n, final int n2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(AudioOutput, (Object)string);
            jSONObject.put(SamplingRate, n);
            jSONObject.put(ChannelNumber, n2);
            Zmf.sendMessage(4, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfAudio.outputRequestStart(string, n, n2);
            }
        });
    }

    private static void audioOutputRequestStop(final String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(AudioOutput, (Object)string);
            Zmf.sendMessage(5, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfAudio.outputRequestStop(string);
            }
        });
    }

    private static void audioOutputDidStart(final String string, final int n, final int n2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(AudioOutput, (Object)string);
            jSONObject.put(SamplingRate, n);
            jSONObject.put(ChannelNumber, n2);
            Zmf.sendMessage(6, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfAudio.outputDidStart(string, n, n2);
            }
        });
    }

    private static void audioInputRequestStart(final String string, final int n, final int n2, final int n3, final int n4) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(AudioInput, (Object)string);
            jSONObject.put(SamplingRate, n);
            jSONObject.put(ChannelNumber, n2);
            jSONObject.put(AcousticEchoCancel, n3);
            jSONObject.put(AutoGainControl, n4);
            Zmf.sendMessage(1, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfAudio.inputRequestStart(string, n, n2, n3, n4);
            }
        });
    }

    private static void audioInputRequestStop(final String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(AudioInput, (Object)string);
            Zmf.sendMessage(2, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfAudio.inputRequestStop(string);
            }
        });
    }

    private static void audioInputDidStart(final String string, final int n, final int n2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(AudioInput, (Object)string);
            jSONObject.put(SamplingRate, n);
            jSONObject.put(ChannelNumber, n2);
            Zmf.sendMessage(3, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfAudio.inputDidStart(string, n, n2);
            }
        });
    }

    private static int audioOutputGetCount() {
        return ZmfAudio.outputGetCount();
    }

    private static String[] audioOutputGetName(int n) {
        String[] stringArray = new String[2];
        ZmfAudio.outputGetName(n, stringArray);
        return stringArray;
    }

    private static int audioOutputStart(String string, int n, int n2) {
        return ZmfAudio.outputStart(string, n, n2);
    }

    private static int audioOutputStop(String string) {
        return ZmfAudio.outputStop(string);
    }

    private static int audioOutputStopAll() {
        return ZmfAudio.outputStopAll();
    }

    private static int cameraGetCount() {
        return ZmfVideo.cameraGetCount();
    }

    private static String[] cameraGetName(int n) {
        String[] stringArray = new String[2];
        ZmfVideo.cameraGetName(n, stringArray);
        return stringArray;
    }

    private static int videoCaptureStart(String string, int n, int n2, int n3) {
        return ZmfVideo.captureStart(string, n, n2, n3);
    }

    private static int videoCaptureStop(String string) {
        return ZmfVideo.captureStop(string);
    }

    private static int videoCaptureStopAll() {
        return ZmfVideo.captureStopAll();
    }

    private static int[] videoCaptureGetOrient(String string) {
        int[] nArray = new int[3];
        ZmfVideo.captureGetOrient(string, nArray);
        return nArray;
    }

    private static int videoRenderStart(View view) {
        return ZmfVideo.renderStart(view);
    }

    private static int videoRenderStop(View view) {
        return ZmfVideo.renderStop(view);
    }

    private static int videoRenderAdd(View view, String string, int n, int n2) {
        return ZmfVideo.renderAdd(view, string, n, n2);
    }

    private static int videoRenderRemove(View view, String string) {
        return ZmfVideo.renderRemove(view, string);
    }

    private static int videoRenderMove(View view, String string, float f, float f2, float f3, float f4) {
        return ZmfVideo.renderMove(view, string, f, f2, f3, f4);
    }

    private static int videoRenderMirror(View view, String string, int n) {
        return ZmfVideo.renderMirror(view, string, n);
    }

    private static int videoRenderRotate(View view, int n) {
        return ZmfVideo.renderRotate(view, n);
    }

    private static int[] getCamParam(String string) {
        return ZmfVideo.getCamParam(string);
    }

    private static void videoCaptureRequestStart(final String string, final int n, final int n2, final int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Capture, (Object)string);
            jSONObject.put(Width, n);
            jSONObject.put(Height, n2);
            jSONObject.put(FrameRate, n3);
            Zmf.sendMessage(20, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.captureRequestStart(string, n, n2, n3);
            }
        });
    }

    private static void videoCaptureRequestChange(final String string, final int n, final int n2, final int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Capture, (Object)string);
            jSONObject.put(Width, n);
            jSONObject.put(Height, n2);
            jSONObject.put(FrameRate, n3);
            Zmf.sendMessage(30, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.captureRequestChange(string, n, n2, n3);
            }
        });
    }

    private static void videoCaptureRequestStop(final String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Capture, (Object)string);
            Zmf.sendMessage(21, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.captureRequestStop(string);
            }
        });
    }

    private static void videoCaptureDidStart(final String string, final int n, final int n2, final int n3, int n4) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Capture, (Object)string);
            jSONObject.put(Face, n);
            jSONObject.put(Width, n2);
            jSONObject.put(Height, n3);
            jSONObject.put(Angle, n4);
            Zmf.sendMessage(22, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.captureDidStart(string, n, n2, n3);
            }
        });
    }

    private static void videoRenderRequestAdd(final String string, final int n, int n2, int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Render, (Object)string);
            jSONObject.put(SourceType, n);
            jSONObject.put(Width, n2);
            jSONObject.put(Height, n3);
            Zmf.sendMessage(25, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderRequestAdd(string, n);
            }
        });
    }

    private static void videoCaptureStatus(final String string, final int n, final int n2, final int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Capture, (Object)string);
            jSONObject.put(Exposure, n);
            jSONObject.put(Brightness, n2);
            jSONObject.put(Backlot, n3);
            Zmf.sendMessage(33, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.captureStatus(string, n, n2, n3);
            }
        });
    }

    static void onVideoRenderRequestRemove(final View view, final int n, final String string) {
        Zmf.zmfLog(0, "Evt:videoRendReqRemv={\"Render\":\"" + string + "\"}");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Window, (Object)view);
            jSONObject.put(SourceType, n);
            jSONObject.put(Render, (Object)string);
            Zmf.sendMessage(29, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderRequestRemove(view, n, string);
            }
        });
    }

    private static void videoRenderRequestRemove(final String string, final int n) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(SourceType, n);
            jSONObject.put(Render, (Object)string);
            Zmf.sendMessage(29, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderRequestRemove(null, n, string);
            }
        });
    }

    static void videoRenderDidReceive(final String string, final int n, final int n2, final int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(SourceType, n);
            jSONObject.put(Render, (Object)string);
            jSONObject.put(Width, n2);
            jSONObject.put(Height, n3);
            Zmf.sendMessage(26, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderDidReceive(null, n, string, n2, n3);
            }
        });
    }

    static void videoRenderDidResize(final String string, final int n, final int n2, final int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(SourceType, n);
            jSONObject.put(Render, (Object)string);
            jSONObject.put(Width, n2);
            jSONObject.put(Height, n3);
            Zmf.sendMessage(28, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderDidResize(null, n, string, n2, n3);
            }
        });
    }

    static void videoRenderDidStart(final String string, final int n, final int n2, final int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(SourceType, n);
            jSONObject.put(Render, (Object)string);
            jSONObject.put(Width, n2);
            jSONObject.put(Height, n3);
            Zmf.sendMessage(27, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderDidStart(null, n, string, n2, n3);
            }
        });
    }

    static void videoRenderDidReceive(final View view, final int n, final String string, final int n2, final int n3) {
        Zmf.zmfLog(0, "Evt:videoRendDidRecv={\"Render\":\"" + string + "\",\"Width\":" + n2 + ",\"Height\":" + n3 + "}");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Window, (Object)view);
            jSONObject.put(SourceType, n);
            jSONObject.put(Render, (Object)string);
            jSONObject.put(Width, n2);
            jSONObject.put(Height, n3);
            Zmf.sendMessage(26, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderDidReceive(view, n, string, n2, n3);
            }
        });
    }

    static void videoRenderDidResize(final View view, final int n, final String string, final int n2, final int n3) {
        Zmf.zmfLog(0, "Evt:videoRendDidResz={\"Render\":\"" + string + "\",\"Width\":" + n2 + ",\"Height\":" + n3 + "}");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Window, (Object)view);
            jSONObject.put(SourceType, n);
            jSONObject.put(Render, (Object)string);
            jSONObject.put(Width, n2);
            jSONObject.put(Height, n3);
            Zmf.sendMessage(28, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderDidResize(view, n, string, n2, n3);
            }
        });
    }

    static void videoRenderDidStart(final View view, final int n, final String string, final int n2, final int n3) {
        Zmf.zmfLog(0, "Evt:videoRendDidStat={\"Render\":\"" + string + "\",\"Width\":" + n2 + ",\"Height\":" + n3 + "}");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Window, (Object)view);
            jSONObject.put(SourceType, n);
            jSONObject.put(Render, (Object)string);
            jSONObject.put(Width, n2);
            jSONObject.put(Height, n3);
            Zmf.sendMessage(27, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.renderDidStart(view, n, string, n2, n3);
            }
        });
    }

    static void videoErrorOccurred(final String string) {
        Zmf.zmfLog(3, string);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(VideoError, (Object)string);
            Zmf.sendMessage(31, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfVideo.videoErrorOccurred(string);
            }
        });
    }

    static void audioErrorOccurred(final String string) {
        Zmf.zmfLog(3, string);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(AudioError, (Object)string);
            Zmf.sendMessage(7, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Zmf.zmfLog(3, jSONException.getLocalizedMessage());
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                ZmfAudio.audioErrorOccurred(string);
            }
        });
    }

    static native void onVideoCaptureDidStop(String var0);

    static native void onAudioInputDidStop(String var0);

    static native void onAudioOutputDidStop(String var0);

    static native int videoRenderAddCallback(ZmfVideo.RenderCallback var0);

    static native int videoRenderRemoveCallback(int var0);

    static native int videoCaptureAddCallback(ZmfVideo.CaptureCallback var0);

    static native int videoCaptureRemoveCallback(int var0);

    static native void onVideoRender(String var0, int var1, int var2, int var3, int var4, int var5, ByteBuffer var6);

    static native void onVideoCapture(String var0, int var1, int var2, int var3, int[] var4, ByteBuffer var5, String var6, int[] var7);

    static native void onAudioOutput(String var0, int var1, int var2, ByteBuffer var3);

    static native void onAudioInput(String var0, int var1, int var2, ByteBuffer var3, int var4, int var5, int var6);

    static native int convertFromI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, int var4);

    static native int convertToI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, int var4, int var5, int var6, int var7, int[] var8);

    static native int onCaptureEnhance(int var0, String var1);

    static native int videoRenderSnapshot(String var0, int var1, int var2, String var3);

    static native int codecParametersGetInt(long var0, String var2);

    static native String codecParametersGetString(long var0, String var2);

    private static native int codecRegister(String var0);

    private static native int codecDeRegister(String var0);

    static native void codecDoCallback(long var0, long var2, ByteBuffer var4, int var5, long var6, boolean var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object codecNew(String string, long l, long l2) {
        Class clazz;
        ZmfCodec zmfCodec = null;
        String[] stringArray = string.split("\\.");
        if (stringArray == null || stringArray.length < 2) {
            Zmf.zmfLog(3, "invalid codecName");
            return null;
        }
        Map<String, Class> map = _codecsMap;
        synchronized (map) {
            clazz = _codecsMap.get(string);
        }
        if (clazz == null) {
            Zmf.zmfLog(3, "no codec:" + string);
            return null;
        }
        try {
            zmfCodec = (ZmfCodec)clazz.newInstance();
        }
        catch (Exception exception) {
            String string2 = exception.getLocalizedMessage();
            if (string2 == null) {
                string2 = "invalid newInstance " + string;
            }
            Zmf.zmfLog(3, "codecNew: " + string2);
            return null;
        }
        if (zmfCodec != null) {
            zmfCodec.init(stringArray[stringArray.length - 1].equals("encoder"), stringArray[stringArray.length - 2], l, l2);
        }
        return zmfCodec;
    }

    static int codecReset(Object object, long l) {
        ZmfCodec zmfCodec = (ZmfCodec)object;
        return zmfCodec.reset(l);
    }

    static int codecSet(Object object, int n, int n2) {
        ZmfCodec zmfCodec = (ZmfCodec)object;
        return zmfCodec.set(n, n2);
    }

    static int codecSet(Object object, int n, byte[] byArray) {
        ZmfCodec zmfCodec = (ZmfCodec)object;
        return zmfCodec.set(n, byArray);
    }

    static int codecGet(Object object, int n) {
        ZmfCodec zmfCodec = (ZmfCodec)object;
        return zmfCodec.get(n);
    }

    static int codecGet(Object object, int n, byte[] byArray) {
        ZmfCodec zmfCodec = (ZmfCodec)object;
        return zmfCodec.get(n, byArray);
    }

    static int codecDo(Object object, ByteBuffer byteBuffer, long l, long l2, boolean bl) {
        ZmfCodec zmfCodec = (ZmfCodec)object;
        return zmfCodec.enqueue(byteBuffer, l, l2, bl);
    }

    static void codecDelete(Object object) {
        ZmfCodec zmfCodec = (ZmfCodec)object;
        zmfCodec.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean codecRegister(String string, Class clazz) {
        if (string == null || clazz == null) {
            Zmf.zmfLog(3, "codecRegister: null param");
            return false;
        }
        try {
            clazz.newInstance();
        }
        catch (Exception exception) {
            String string2 = exception.getLocalizedMessage();
            if (string2 == null) {
                string2 = "invalid newInstance " + string;
            }
            Zmf.zmfLog(3, "codecRegister: " + string2);
            return false;
        }
        if (Zmf.codecRegister(string) < 0) {
            return false;
        }
        Map<String, Class> map = _codecsMap;
        synchronized (map) {
            _codecsMap.put(string, clazz);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean codecDeregister(String string) {
        if (string == null) {
            Zmf.zmfLog(3, "codecRegister: null param");
            return false;
        }
        if (Zmf.codecDeRegister(string) < 0) {
            return false;
        }
        Map<String, Class> map = _codecsMap;
        synchronized (map) {
            _codecsMap.remove(string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class codecGetClass(String string) {
        Map<String, Class> map = _codecsMap;
        synchronized (map) {
            return _codecsMap.get(string);
        }
    }

    public static native boolean codecHasClass(String var0);

    static native void zmfLog(int var0, String var1);

    private static native int zmfInitialize(String var0, String var1, int var2);

    private static native int zmfTerminate();

    public static native String getVersion();

    public static native int getApiLevel();

    static native String zmfTraits();

    static synchronized int initialize(Context context) {
        if (_refCount++ == 0) {
            if (Build.VERSION.SDK_INT >= 21) {
                ZmfMediaCodec.register(BUILTIN_CODECS, false);
            }
            return Zmf.zmfInitialize(context.getPackageName(), context.getApplicationInfo().nativeLibraryDir, Build.VERSION.SDK_INT);
        }
        return 0;
    }

    static synchronized int terminate() {
        if (_refCount > 0 && --_refCount == 0) {
            if (Build.VERSION.SDK_INT >= 21) {
                ZmfMediaCodec.deregister(BUILTIN_CODECS);
            }
            return Zmf.zmfTerminate();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addObserver(ZmfObserver zmfObserver) {
        Zmf.zmfLog(1, "addObserver: " + zmfObserver);
        WeakHashMap<ZmfObserver, Object> weakHashMap = sObservers;
        synchronized (weakHashMap) {
            sObservers.put(zmfObserver, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObserver(ZmfObserver zmfObserver) {
        WeakHashMap<ZmfObserver, Object> weakHashMap = sObservers;
        synchronized (weakHashMap) {
            sObservers.remove(zmfObserver);
        }
    }

    static void sendMessage(final int n, final JSONObject jSONObject) {
        if (sObservers.size() == 0) {
            return;
        }
        _handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WeakHashMap<ZmfObserver, Object> weakHashMap = sObservers;
                synchronized (weakHashMap) {
                    for (ZmfObserver zmfObserver : sObservers.keySet()) {
                        zmfObserver.handleNotification(n, jSONObject);
                    }
                }
            }
        });
    }

    static {
        try {
            System.loadLibrary("zmf");
        }
        catch (Throwable throwable) {
            Log.e((String)"ZMF", (String)"loadLibrary libzmf.so failed!");
            throwable.printStackTrace();
        }
        sObservers = new WeakHashMap();
        BUILTIN_CODECS = new String[]{BUILTIN_DECODER_H264, BUILTIN_ENCODER_H264, BUILTIN_DECODER_H265, BUILTIN_ENCODER_H265};
    }
}

