/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.util.Range;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfMediaCodec;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.ByteBuffer;
import java.util.Arrays;

@SuppressLint(value={"NewApi"})
class H264Codec
extends ZmfMediaCodec {
    protected static final int kNALTypeIDR = 5;
    protected static final int kNALTypeSPS = 7;
    protected static final int kNALTypePPS = 8;
    protected static final int kNALTypeBad = -1;
    protected static final byte[] ANNEXB_HEAD = new byte[]{0, 0, 0, 1};
    ByteBuffer mSps;
    ByteBuffer mPps;
    boolean mNextKeyframe;
    boolean mKeyframe;
    int mColorFormat;
    int mSetWidth;
    int mWidth;
    int mSetHeight;
    int mHeight;
    int mCropLeft;
    int mCropRight;
    int mCropTop;
    int mCropBot;
    int mCroppedWidth;
    int mCroppedHeight;
    int mStride;
    int mSliceHeight;
    ByteBuffer mBufI420;
    int mNextBitRateKbps;
    int mBitRateKbps;
    boolean mAdjustBr;
    int mMaxFrameRate;
    int mSetFrameRate;
    int mBitrateMode = 0;
    long mLastTimeAdjustBr;
    Range<Integer> mBitrateRange = null;
    static MediaCodecInfo[] H264_CODEC_INFO_LIST = null;
    static int H264_CODEC_INFO_COUNT = 0;
    private static final String[] H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337"};
    private static final String[] H264_Supported_Prefix = new String[]{"qcom", "Exynos", "MTK"};

    private int setBitrate(MediaCodec mediaCodec, int n) {
        long l = SystemClock.elapsedRealtime();
        if (l - this.mLastTimeAdjustBr <= 1000L) {
            return 0;
        }
        this.mLastTimeAdjustBr = l;
        this.mBitRateKbps = n;
        int n2 = n * 1000;
        if (this.mAdjustBr) {
            n2 = this.mMaxFrameRate * n2 / this.mSetFrameRate;
        }
        if (this.mBitrateRange != null) {
            n2 = (Integer)this.mBitrateRange.clamp((Comparable)Integer.valueOf(n2));
        }
        Bundle bundle = new Bundle(1);
        bundle.putInt("video-bitrate", n2);
        try {
            mediaCodec.setParameters(bundle);
        }
        catch (Exception exception) {
            return this.MEDIA_CODEC_ERROR(exception);
        }
        Log.d((String)this.TAG, (String)("BitRate=" + n));
        return 0;
    }

    @Override
    protected int set(int n, byte[] byArray) {
        switch (n) {
            case 10: {
                this.mSps = ByteBuffer.allocate(ANNEXB_HEAD.length + byArray.length);
                this.mSps.put(ANNEXB_HEAD).put(byArray);
                this.mSps.clear();
                return 0;
            }
            case 11: {
                this.mPps = ByteBuffer.allocate(ANNEXB_HEAD.length + byArray.length);
                this.mPps.put(ANNEXB_HEAD).put(byArray);
                this.mPps.clear();
                return 0;
            }
        }
        return this.MEDIA_CODEC_ERROR("invalid param" + n);
    }

    @Override
    protected int set(int n, int n2) {
        switch (n) {
            case 1: {
                if (this.mBitrateMode != 0) {
                    this.mNextBitRateKbps = n2;
                }
                return 0;
            }
            case 0: {
                this.mNextKeyframe = true;
                return 0;
            }
            case 2: {
                this.mSetFrameRate = n2;
                return 0;
            }
            case 6: 
            case 7: {
                return 0;
            }
        }
        return this.MEDIA_CODEC_ERROR("invalid param" + n);
    }

    @Override
    protected int get(int n) {
        switch (n) {
            case 4: {
                return this.mCroppedWidth;
            }
            case 5: {
                return this.mCroppedHeight;
            }
            case 9: {
                return 1;
            }
            case 0: {
                return this.mKeyframe ? 1 : 0;
            }
            case 8: {
                return 0;
            }
        }
        return this.MEDIA_CODEC_ERROR("invalid param" + n);
    }

    private int resetH264Decoder(long l) {
        if (this.mSps == null || this.mPps == null) {
            return -1;
        }
        int n = this.configGetInt(l, "video.width");
        int n2 = this.configGetInt(l, "video.height");
        if (this.mSetWidth == n && this.mSetHeight == n2) {
            return 0;
        }
        this.stopMediaCodec();
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)n, (int)n2);
        mediaFormat.setByteBuffer("csd-0", this.mSps);
        mediaFormat.setByteBuffer("csd-1", this.mPps);
        this.mWidth = this.mCroppedWidth = n;
        this.mSetWidth = this.mCroppedWidth;
        this.mHeight = this.mCroppedHeight = n2;
        this.mSetHeight = this.mCroppedHeight;
        this.mCropBot = 0;
        this.mCropTop = 0;
        this.mCropRight = 0;
        this.mCropLeft = 0;
        this.mStride = n;
        this.mSliceHeight = n2;
        this.mColorFormat = 19;
        return this.startMediaCodec(mediaFormat, 0);
    }

    static boolean isSupported(boolean bl) {
        Object object;
        Object object2;
        if (H264_CODEC_INFO_LIST == null) {
            MediaCodecInfo[] mediaCodecInfoArray;
            object2 = new MediaCodecInfo[64];
            MediaCodecList mediaCodecList = new MediaCodecList(0);
            MediaCodecInfo[] mediaCodecInfoArray2 = mediaCodecInfoArray = mediaCodecList.getCodecInfos();
            int n = mediaCodecInfoArray2.length;
            block2: for (int i = 0; i < n; ++i) {
                object = mediaCodecInfoArray2[i];
                if (!object.isEncoder()) continue;
                try {
                    MediaCodecInfo.CodecCapabilities codecCapabilities = object.getCapabilitiesForType("video/avc");
                    int[] nArray = codecCapabilities.colorFormats;
                    int n2 = nArray.length;
                    for (int j = 0; j < n2; ++j) {
                        int n3 = nArray[j];
                        if (n3 != 19 && n3 != 21) continue;
                        String string = object.getName();
                        Log.i((String)"ZMF", (String)("H264 find encoder name: " + string));
                        if (H264_CODEC_INFO_COUNT >= ((Object)object2).length) continue block2;
                        Log.i((String)"ZMF", (String)("H264 add encoder name: " + string));
                        object2[H264Codec.H264_CODEC_INFO_COUNT++] = object;
                        continue block2;
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            H264_CODEC_INFO_LIST = (MediaCodecInfo[])Arrays.copyOf(object2, H264_CODEC_INFO_COUNT);
        }
        if (H264_CODEC_INFO_COUNT > 0) {
            if (!bl) {
                object2 = Arrays.asList(H264_HW_EXCEPTION_MODELS);
                if (object2.contains(Build.MODEL)) {
                    Log.i((String)"ZMF", (String)("H264 Encoder on blacklist: " + Build.MODEL));
                    return false;
                }
                boolean bl2 = false;
                for (MediaCodecInfo mediaCodecInfo : H264_CODEC_INFO_LIST) {
                    object = mediaCodecInfo.getName();
                    for (MediaCodecInfo.CodecCapabilities codecCapabilities : H264_Supported_Prefix) {
                        if (!((String)object).contains((CharSequence)codecCapabilities)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) break;
                }
                if (!bl2) {
                    Log.i((String)"ZMF", (String)"H264 Encoder soc not on whitelist");
                    return false;
                }
            }
            Log.i((String)"ZMF", (String)("H264 Encoder supported(" + bl + "): " + Build.MODEL));
            return true;
        }
        return false;
    }

    private int resetH264Encoder(long l) {
        Object object3;
        Object object2;
        int n;
        int n2 = this.configGetInt(l, "video.width");
        int n3 = this.configGetInt(l, "video.height");
        int n4 = this.configGetInt(l, "video.maxFramerate");
        int n5 = this.configGetInt(l, "video.startBitrate");
        if (this.mSetWidth == n2 && this.mSetHeight == n3 && this.mMaxFrameRate == n4 && this.mBitRateKbps == n5) {
            return 0;
        }
        MediaCodecInfo mediaCodecInfo = H264_CODEC_INFO_LIST[0];
        String string = mediaCodecInfo.getName();
        int n6 = n = string.contains("sprd") ? this.release() : this.stopMediaCodec();
        if (n != 0) {
            return n;
        }
        this.mAdjustBr = !string.contains("qcom");
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)n2, (int)n3);
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType("video/avc");
        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
        MediaCodecInfo.EncoderCapabilities encoderCapabilities = codecCapabilities.getEncoderCapabilities();
        mediaFormat.setString("codec-name", mediaCodecInfo.getName());
        if (!videoCapabilities.areSizeAndRateSupported(n2, n3, (double)n4)) {
            try {
                object2 = videoCapabilities.getSupportedFrameRatesFor(n2, n3);
                if (object2 == null) {
                    return this.MEDIA_CODEC_ERROR("don't supprot size and rate!");
                }
                n4 = ((Double)object2.clamp((Comparable)Double.valueOf(n4))).intValue();
            }
            catch (Exception exception) {
                return this.MEDIA_CODEC_ERROR("don't support size " + n2 + "x" + n3);
            }
        }
        this.mBitrateRange = videoCapabilities.getBitrateRange();
        if (this.mBitrateRange != null) {
            n5 = (Integer)this.mBitrateRange.clamp((Comparable)Integer.valueOf(n5 * 1000)) / 1000;
        }
        this.mWidth = this.mCroppedWidth = n2;
        this.mSetWidth = this.mCroppedWidth;
        this.mHeight = this.mCroppedHeight = n3;
        this.mSetHeight = this.mCroppedHeight;
        this.mMaxFrameRate = n4;
        this.mBitRateKbps = this.mNextBitRateKbps = n5;
        for (Object object3 : (Object)codecCapabilities.colorFormats) {
            if (object3 != 19 && object3 != 21) continue;
            this.mColorFormat = (int)object3;
            break;
        }
        object2 = this.configGetString(l, "video.H264.profile");
        int n7 = 1;
        switch (((String)object2).charAt(0)) {
            default: {
                n7 = 1;
                break;
            }
            case 'M': {
                n7 = 2;
                break;
            }
            case 'E': {
                n7 = 4;
                break;
            }
            case 'H': {
                n7 = 8;
            }
        }
        mediaFormat.setInteger("i-frame-interval", 65535);
        mediaFormat.setInteger("color-format", this.mColorFormat);
        mediaFormat.setInteger("stride", this.mSetWidth);
        mediaFormat.setInteger("slice-height", this.mSetHeight);
        mediaFormat.setFloat("frame-rate", (float)this.mMaxFrameRate);
        mediaFormat.setInteger("bitrate", this.mBitRateKbps * 1000);
        int n8 = 0;
        object3 = this.mSetWidth * this.mSetHeight;
        n8 = object3 <= 76800 ? 16 : (object3 <= 307200 ? 256 : (object3 <= 921600 ? 512 : 2048));
        for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecCapabilities.profileLevels) {
            if (codecProfileLevel.profile < n7 || codecProfileLevel.level < n8) continue;
            mediaFormat.setInteger("profile", codecProfileLevel.profile);
            mediaFormat.setInteger("level", n8);
            break;
        }
        this.mBitrateMode = 2;
        if (string.contains("sprd")) {
            this.mBitrateMode = 1;
        }
        mediaFormat.setInteger("bitrate-mode", this.mBitrateMode);
        mediaFormat.setInteger("VideoMinQP", this.configGetInt(l, "video.qpMin"));
        mediaFormat.setInteger("VideoMaxQP", this.configGetInt(l, "video.qpMax"));
        this.mNextKeyframe = false;
        this.mLastTimeAdjustBr = SystemClock.elapsedRealtime();
        Log.i((String)this.TAG, (String)("BitrateRange " + this.mBitrateRange + " BitrateMode " + this.mBitrateMode));
        return this.startMediaCodec(mediaFormat, 1);
    }

    @Override
    protected int resetMediaCodec(long l) {
        if (l == 0L) {
            this.mSps = null;
            this.mPps = null;
            return this.stopMediaCodec();
        }
        if (this.isEncoder()) {
            return this.resetH264Encoder(l);
        }
        return this.resetH264Decoder(l);
    }

    @Override
    protected ByteBuffer onInputBuffer(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, MediaCodec mediaCodec) {
        this.mKeyframe = false;
        if (!this.isEncoder()) {
            bufferInfo.size = byteBuffer.capacity();
            int n = byteBuffer.get(4) & 0x1F;
            if (this.mNextKeyframe || n == 5) {
                bufferInfo.flags |= 1;
            } else if (n == 7 || n == 8) {
                bufferInfo.flags |= 2;
            }
            this.mNextKeyframe = false;
            return byteBuffer;
        }
        if (this.mBitRateKbps != this.mNextBitRateKbps) {
            this.setBitrate(mediaCodec, this.mNextBitRateKbps);
        }
        if (this.mNextKeyframe) {
            bufferInfo.flags |= 1;
        }
        this.mNextKeyframe = false;
        switch (this.mColorFormat) {
            case 21: {
                bufferInfo.size = byteBuffer.capacity();
                if (this.mBufI420 == null || this.mBufI420.capacity() < bufferInfo.size) {
                    this.mBufI420 = ByteBuffer.allocateDirect(bufferInfo.size);
                }
                this.mBufI420.clear();
                this.mBufI420.limit(bufferInfo.size);
                if (0 <= ZmfVideo.convertFromI420(this.mBufI420, 14, byteBuffer, this.mSetWidth, this.mSetHeight)) {
                    return this.mBufI420;
                }
                return null;
            }
            case 19: {
                bufferInfo.size = byteBuffer.capacity();
                return byteBuffer;
            }
        }
        return null;
    }

    @Override
    protected ByteBuffer onOutputBuffer(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        if (!this.isEncoder()) {
            switch (this.mColorFormat) {
                case 21: 
                case 2141391876: {
                    if (this.mBufI420 == null || this.mBufI420.capacity() < bufferInfo.size) {
                        this.mBufI420 = ByteBuffer.allocateDirect(bufferInfo.size);
                    }
                    this.mBufI420.clear();
                    this.mBufI420.limit(bufferInfo.size);
                    int[] nArray = new int[]{this.mCroppedWidth, this.mCroppedHeight};
                    if (0 <= Zmf.convertToI420(this.mBufI420, 14, byteBuffer, this.mStride, this.mSliceHeight, 0, this.mCropLeft, this.mCropTop, nArray)) {
                        bufferInfo.size = nArray[0] * nArray[1] * 3 / 2;
                        return this.mBufI420;
                    }
                    Log.i((String)this.TAG, (String)("failed to  convertToI420 " + this.mStride + "x" + this.mSliceHeight + " crop " + this.mCropLeft + " " + this.mCropTop + " to " + this.mCroppedWidth + "x" + this.mCroppedHeight));
                    return null;
                }
                case 19: {
                    return byteBuffer;
                }
            }
            Log.i((String)this.TAG, (String)("unsupported colorformat " + this.mColorFormat));
            return null;
        }
        int n = byteBuffer.get(4) & 0x1F;
        if ((bufferInfo.flags & 1) != 0) {
            this.mKeyframe = true;
        } else if (n == 7 || n == 8 || n == 5) {
            this.mKeyframe = true;
        }
        if (bufferInfo.size < 64 && (n == 7 || n == 8)) {
            bufferInfo.flags |= 0x1000;
        }
        return byteBuffer;
    }

    @Override
    protected void onOutputFormatChanged(MediaFormat mediaFormat) {
        if (mediaFormat.containsKey("width")) {
            this.mWidth = mediaFormat.getInteger("width");
        }
        if (mediaFormat.containsKey("height")) {
            this.mHeight = mediaFormat.getInteger("height");
        }
        if (mediaFormat.containsKey("color-format")) {
            this.mColorFormat = mediaFormat.getInteger("color-format");
        }
        if (mediaFormat.containsKey("stride")) {
            this.mStride = mediaFormat.getInteger("stride");
        }
        if (mediaFormat.containsKey("slice-height")) {
            this.mSliceHeight = mediaFormat.getInteger("slice-height");
        }
        if (mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-right") && mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top")) {
            this.mCropLeft = mediaFormat.getInteger("crop-left");
            this.mCropRight = mediaFormat.getInteger("crop-right");
            this.mCropBot = mediaFormat.getInteger("crop-bottom");
            this.mCropTop = mediaFormat.getInteger("crop-top");
            this.mCroppedWidth = 1 + this.mCropRight - this.mCropLeft;
            this.mCroppedHeight = 1 + this.mCropBot - this.mCropTop;
        } else {
            this.mCroppedWidth = this.mWidth;
            this.mCroppedHeight = this.mHeight;
        }
        this.mStride = Math.max(this.mStride, this.mWidth);
        this.mSliceHeight = Math.max(this.mSliceHeight, this.mHeight);
        Log.i((String)this.TAG, (String)String.format("%dx%d,color=%d,stride=%dx%d,crop %d-%d,%d-%d", this.mWidth, this.mHeight, this.mColorFormat, this.mStride, this.mSliceHeight, this.mCropLeft, this.mCropRight, this.mCropTop, this.mCropBot));
    }

    public H264Codec() {
        super("H264");
    }
}

