package com.juphoon.cloud;

/**
 * 文件存储对象
 *
 * @author juphoon
 */
public class JCStorageItem {

    String fileId;
    String uri;
    String path;
    int progress;
    int sessId;
    int cookie;
    @JCStorage.ItemState
    int state;
    @JCStorage.ItemDirection
    int direction;
    @JCStorage.StorageReason
    int reason;

    /**
     * 文件唯一标识符
     */
    public String getFileId() {
        return fileId;
    }

    /**
     * 文件链接，上传文件可获得
     */
    public String getUri() {
        return uri;
    }

    /**
     * 文件本地路径，发送时表明发送文件路径，接收时表明文件下载保存路径
     */
    public String getPath() {
        return path;
    }

    /**
     * 上传还是下载，参见 JCStorageDirection
     */
    @JCMessageChannel.ItemDirection
    public int getDirection() {
        return direction;
    }

    /**
     * 传输状态，参见 JCStorageState
     */
    @JCStorage.ItemState
    public int getState() {
        return state;
    }

    /**
     * 原因值，当文件状态未 JCStorageStateFail 时有效，参见 JCStorageReason
     */
    @JCStorage.StorageReason
    public int getReason() {
        return reason;
    }

    /**
     * 文件传输进度
     */
    public int getProgress() {
        return progress;
    }

}
