/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.mapuikit;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.CountDownTimer;
import android.support.annotation.NonNull;
import android.support.v4.widget.CursorAdapter;
import android.support.v4.widget.SimpleCursorAdapter;
import android.support.v7.widget.SearchView;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.daimajia.androidanimations.library.Techniques;
import com.daimajia.androidanimations.library.YoYo;
import com.jibestream.jmapandroidsdk.analytics_kit.AnalyticsEvent;
import com.jibestream.jmapandroidsdk.components.ActiveVenue;
import com.jibestream.jmapandroidsdk.components.Amenity;
import com.jibestream.jmapandroidsdk.components.BaseModel;
import com.jibestream.jmapandroidsdk.components.Destination;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.PathType;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.jmapandroidsdk.jcore.JCore;
import com.jibestream.jmapandroidsdk.rendering_engine.MapLayer;
import com.jibestream.jmapandroidsdk.rendering_engine.MapView;
import com.jibestream.jmapandroidsdk.rendering_engine.Stage;
import com.jibestream.jmapandroidsdk.rendering_engine.Transform;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.MapDrawable;
import com.jibestream.jmapandroidsdk.styles.JStyle;
import com.jibestream.jmapandroidsdk.styles.JStyleConfig;
import com.jibestream.mapuikit.Compass;
import com.jibestream.mapuikit.CompassOptions;
import com.jibestream.mapuikit.FloorButton;
import com.jibestream.mapuikit.FloorSelector;
import com.jibestream.mapuikit.FloorSelectorOptions;
import com.jibestream.mapuikit.PopupDrawable;
import com.jibestream.mapuikit.PopupDrawableOptions;
import com.jibestream.mapuikit.R;
import com.jibestream.mapuikit.Search;
import com.jibestream.mapuikit.SearchOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class MapUiKit {
    private static final int SEARCH_QUERY_THRESHOLD = 1;
    private static final int TYPE_DESTINATION = 0;
    private static final int TYPE_AMENITY = 1;
    private static final int TYPE_PATH_TYPE = 2;
    private final JCore core;
    private final JController controller;
    private ActiveVenue activeVenue;
    private final Stage stage;
    private final Context context;
    private RelativeLayout uiContainer;
    private FloorSelector floorSelector;
    private Compass compass;
    private PopupDrawable popupDrawable;
    private Search search;
    private CompassOptions compassOptions;
    private JStyleConfig.UiKitStyle.Default defaultStyle;
    private final int DEFAULT_MARGIN = 20;
    private Techniques animationIn;
    private Techniques animationOut;
    private boolean allowConcurrentPopups;
    private JStyleConfig mapTemplate;
    private static ArrayList<Typeface> typefaces;
    private HashSet<FloorButton> floorButtons;
    private LinearLayout floorButtonContainer;

    public MapUiKit(@NonNull JCore core, @NonNull JController controller) {
        this.core = core;
        this.controller = controller;
        this.stage = controller.getStage();
        this.activeVenue = controller.getActiveVenue();
        this.context = controller.getContext();
        this.setupMapUIContainer();
        this.setupMapTemplate();
        this.defaultStyle = new JStyleConfig.UiKitStyle.Default(new JStyleConfig.UiKitStyle(new JStyleConfig()));
        this.defaultStyle = this.mapTemplate != null && this.mapTemplate.uiKitStyle != null && this.mapTemplate.uiKitStyle.defaultStyle != null ? this.mapTemplate.uiKitStyle.defaultStyle : new JStyleConfig.UiKitStyle.Default(new JStyleConfig.UiKitStyle(new JStyleConfig()));
        if (this.defaultStyle.activeStyle == null) {
            this.defaultStyle.activeStyle = new JStyleConfig.UiKitStyle.ActiveStyle(new JStyleConfig.UiKitStyle(new JStyleConfig()));
            this.defaultStyle.activeStyle.fill = "#3e4eb8";
            this.defaultStyle.activeStyle.opacity = Float.valueOf(1.0f);
        } else {
            if (this.defaultStyle.activeStyle.fill == null) {
                this.defaultStyle.activeStyle.fill = "#3e4eb8";
            }
            if (this.defaultStyle.activeStyle.opacity == null) {
                this.defaultStyle.activeStyle.opacity = Float.valueOf(1.0f);
            }
        }
        if (this.defaultStyle.inactiveStyle == null) {
            this.defaultStyle.inactiveStyle = new JStyleConfig.UiKitStyle.InactiveStyle(new JStyleConfig.UiKitStyle(new JStyleConfig()));
            this.defaultStyle.inactiveStyle.fill = "#ffffff";
            this.defaultStyle.inactiveStyle.opacity = Float.valueOf(1.0f);
        } else {
            if (this.defaultStyle.inactiveStyle.fill == null) {
                this.defaultStyle.inactiveStyle.fill = "#ffffff";
            }
            if (this.defaultStyle.inactiveStyle.opacity == null) {
                this.defaultStyle.inactiveStyle.opacity = Float.valueOf(1.0f);
            }
        }
        if (this.defaultStyle.activeFont == null) {
            this.defaultStyle.activeFont = new JStyleConfig.UiKitStyle.ActiveFont(new JStyleConfig.UiKitStyle(new JStyleConfig()));
            this.defaultStyle.activeFont.fill = "#ffffff";
            this.defaultStyle.activeFont.fontFamily = "default";
        } else {
            if (this.defaultStyle.activeFont.fill == null) {
                this.defaultStyle.activeFont.fill = "#ffffff";
            }
            if (this.defaultStyle.activeFont.fontFamily == null) {
                this.defaultStyle.activeFont.fontFamily = "default";
            }
        }
        if (this.defaultStyle.inactiveFont == null) {
            this.defaultStyle.inactiveFont = new JStyleConfig.UiKitStyle.InactiveFont(new JStyleConfig.UiKitStyle(new JStyleConfig()));
            this.defaultStyle.inactiveFont.fill = "#000000";
            this.defaultStyle.inactiveFont.fontFamily = "default";
        } else {
            if (this.defaultStyle.inactiveFont.fill == null) {
                this.defaultStyle.inactiveFont.fill = "#000000";
            }
            if (this.defaultStyle.inactiveFont.fontFamily == null) {
                this.defaultStyle.inactiveFont.fontFamily = "default";
            }
        }
        this.defaultStyle.padding = new float[]{10.0f, 10.0f, 10.0f, 10.0f};
        this.setupTypefaces();
    }

    private void setupTypefaces() {
        typefaces = new ArrayList<Typeface>(){
            {
                this.add(Typeface.MONOSPACE);
                this.add(Typeface.DEFAULT);
                this.add(Typeface.DEFAULT_BOLD);
                this.add(Typeface.SANS_SERIF);
                this.add(Typeface.SERIF);
            }
        };
    }

    public Compass renderCompass(CompassOptions compassOptions) {
        Object[] padding;
        boolean isDefaultPresent;
        boolean addView = false;
        if (this.compass == null) {
            this.compass = new Compass(this.context);
            this.compass.setId(R.id.map_ui_compass);
            this.compass.setImageResource(R.drawable.ic_compass);
            addView = true;
        }
        final RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        boolean isCompassPresentMapTemplate = this.mapTemplate != null && this.mapTemplate.uiKitStyle != null && this.mapTemplate.uiKitStyle.compass != null;
        boolean bl = isDefaultPresent = this.mapTemplate != null && this.mapTemplate.uiKitStyle != null && this.mapTemplate.uiKitStyle.defaultStyle != null;
        if (compassOptions == null) {
            compassOptions = new CompassOptions();
        }
        if (compassOptions.position == null || compassOptions.position.length != 2) {
            int[] defaultPosition = new int[]{1, 1};
            int[] nArray = compassOptions.position = isCompassPresentMapTemplate && this.mapTemplate.uiKitStyle.compass.position != null && this.mapTemplate.uiKitStyle.compass.position.length == 2 ? this.mapTemplate.uiKitStyle.compass.position : defaultPosition;
        }
        if (compassOptions.position[0] == 0 && compassOptions.position[1] == 0) {
            params.addRule(9);
            params.addRule(10);
        } else if (compassOptions.position[0] == 0 && compassOptions.position[1] == 1) {
            params.addRule(9);
            params.addRule(12);
        } else if (compassOptions.position[0] == 1 && compassOptions.position[1] == 0) {
            params.addRule(10);
            params.addRule(11);
        } else if (compassOptions.position[0] == 1 && compassOptions.position[1] == 1) {
            params.addRule(11);
            params.addRule(12);
        }
        if (isCompassPresentMapTemplate && this.mapTemplate.uiKitStyle.compass.padding != null && this.mapTemplate.uiKitStyle.compass.padding.length == 4) {
            padding = this.mapTemplate.uiKitStyle.compass.padding;
            params.setMargins(Math.round(padding[3].floatValue()), Math.round(padding[0].floatValue()), Math.round(padding[1].floatValue()), Math.round(padding[2].floatValue()));
        } else if (isDefaultPresent && this.mapTemplate.uiKitStyle.defaultStyle.padding != null && this.mapTemplate.uiKitStyle.defaultStyle.padding.length == 4) {
            padding = this.mapTemplate.uiKitStyle.defaultStyle.padding;
            params.setMargins(Math.round(padding[3]), Math.round(padding[0]), Math.round(padding[1]), Math.round(padding[2]));
        } else {
            params.setMargins(20, 20, 20, 20);
        }
        if (this.compass.getHeight() == 0 && this.compass.getWidth() == 0 && isCompassPresentMapTemplate) {
            float height = this.mapTemplate.uiKitStyle.compass.height;
            float width = this.mapTemplate.uiKitStyle.compass.width;
            this.compass.setAdjustViewBounds(true);
            if (height != 0.0f) {
                this.compass.setMaxHeight(Math.round(height));
            }
            if (width != 0.0f) {
                this.compass.setMaxWidth(Math.round(width));
            }
        }
        this.compass.setOptions(compassOptions);
        if (compassOptions.icon == R.drawable.ic_compass && compassOptions.rotatedIcon != R.drawable.ic_rotated_compass) {
            compassOptions.icon = compassOptions.rotatedIcon;
        } else if (compassOptions.icon != R.drawable.ic_compass && compassOptions.rotatedIcon == R.drawable.ic_rotated_compass) {
            compassOptions.rotatedIcon = compassOptions.icon;
        }
        final CompassOptions finalCompassOptions = compassOptions;
        this.compassOptions = compassOptions;
        this.controller.setOnRotateListener(new MapView.OnRotateListener(){

            public void onRotateChanged(float v) {
                final float delta = v - MapUiKit.this.compass.getRotation();
                MapUiKit.this.compass.post(new Runnable(){

                    @Override
                    public void run() {
                        if (((MapUiKit)MapUiKit.this).compass.isCompassNorth) {
                            MapUiKit.this.compass.setImageResource(finalCompassOptions.rotatedIcon);
                            ((MapUiKit)MapUiKit.this).compass.isCompassNorth = false;
                        }
                        MapUiKit.this.compass.setRotation(MapUiKit.this.compass.getRotation() + delta);
                    }
                });
                if (MapUiKit.this.popupDrawable != null) {
                    float deltaPopup = -v;
                    MapUiKit.this.popupDrawable.setRotation(deltaPopup);
                }
            }
        });
        if (compassOptions.resetRotationOnTap) {
            this.compass.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Transform transform = new Transform();
                    transform.setRotate(0.0f);
                    MapUiKit.this.controller.setMapTransform(transform, 500, new MapView.OnAnimationCallback(){

                        public void onAnimationComplete() {
                            MapUiKit.this.compass.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    MapUiKit.this.compass.setImageResource(finalCompassOptions.icon);
                                    ((MapUiKit)MapUiKit.this).compass.isCompassNorth = true;
                                }
                            }, 300L);
                        }

                        public void onAnimationInterrupted() {
                        }
                    });
                }
            });
        }
        if (addView) {
            this.uiContainer.post(new Runnable(){

                @Override
                public void run() {
                    MapUiKit.this.uiContainer.addView((View)MapUiKit.this.compass, (ViewGroup.LayoutParams)params);
                }
            });
        }
        return this.compass;
    }

    public Compass renderCompass() {
        return this.renderCompass(new CompassOptions());
    }

    public FloorSelector renderFloorSelector(FloorSelectorOptions floorSelectorOptions) {
        ScrollView scrollView;
        String fontFamily;
        Typeface typeface;
        JStyle style;
        boolean isFloorSelectorPresentInMapTemplate;
        EventBus.getDefault().register((Object)this);
        boolean addView = false;
        if (this.floorSelector == null) {
            this.floorSelector = new FloorSelector(this.context);
            this.floorSelector.setId(R.id.map_ui_floor_selector);
            addView = true;
        }
        final RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        boolean bl = isFloorSelectorPresentInMapTemplate = this.mapTemplate != null && this.mapTemplate.uiKitStyle != null && this.mapTemplate.uiKitStyle.floorSelector != null;
        if (floorSelectorOptions == null) {
            floorSelectorOptions = new FloorSelectorOptions();
            if (isFloorSelectorPresentInMapTemplate && this.mapTemplate.uiKitStyle.floorSelector.vertical) {
                floorSelectorOptions.setVertical(true);
            }
        }
        if (floorSelectorOptions.activeStyle == null) {
            JStyleConfig.UiKitStyle.ActiveStyle mapTemplateActiveStyle = isFloorSelectorPresentInMapTemplate && this.mapTemplate.uiKitStyle.floorSelector.activeStyle != null ? this.mapTemplate.uiKitStyle.floorSelector.activeStyle : this.defaultStyle.activeStyle;
            style = new JStyle();
            if (mapTemplateActiveStyle != null) {
                if (mapTemplateActiveStyle.fill != null) {
                    style.setColor(Color.parseColor((String)mapTemplateActiveStyle.fill));
                }
                if (mapTemplateActiveStyle.opacity != null) {
                    style.setStrokeWidth(mapTemplateActiveStyle.opacity.floatValue());
                }
            }
            floorSelectorOptions.activeStyle = style;
        }
        if (floorSelectorOptions.position == null || floorSelectorOptions.position.length != 2) {
            int[] defaultPosition = new int[]{1, 1};
            floorSelectorOptions.position = isFloorSelectorPresentInMapTemplate && this.mapTemplate.uiKitStyle.floorSelector.position != null && this.mapTemplate.uiKitStyle.floorSelector.position.length == 2 ? this.mapTemplate.uiKitStyle.floorSelector.position : defaultPosition;
            params.setMargins(20, 20, 20, 20);
        }
        if (floorSelectorOptions.position[0] == 0 && floorSelectorOptions.position[1] == 0) {
            floorSelectorOptions.position[0] = 9;
            floorSelectorOptions.position[1] = 10;
            params.addRule(9);
            params.addRule(10);
        } else if (floorSelectorOptions.position[0] == 0 && floorSelectorOptions.position[1] == 1) {
            floorSelectorOptions.position[0] = 9;
            floorSelectorOptions.position[1] = 12;
            params.addRule(9);
            params.addRule(12);
        } else if (floorSelectorOptions.position[0] == 1 && floorSelectorOptions.position[1] == 0) {
            floorSelectorOptions.position[0] = 11;
            floorSelectorOptions.position[1] = 10;
            params.addRule(11);
            params.addRule(10);
        } else if (floorSelectorOptions.position[0] == 1 && floorSelectorOptions.position[1] == 1) {
            floorSelectorOptions.position[0] = 11;
            floorSelectorOptions.position[1] = 12;
            params.addRule(11);
            params.addRule(12);
        }
        if (floorSelectorOptions.maxHeight == 0 && isFloorSelectorPresentInMapTemplate && this.mapTemplate.uiKitStyle.floorSelector.maxHeight != 0.0f) {
            floorSelectorOptions.maxHeight = Math.round(this.mapTemplate.uiKitStyle.floorSelector.maxHeight);
        }
        if (floorSelectorOptions.inactiveStyle == null) {
            JStyleConfig.UiKitStyle.InactiveStyle mapTemplateInactiveStyle = isFloorSelectorPresentInMapTemplate && this.mapTemplate.uiKitStyle.floorSelector.inactiveStyle != null ? this.mapTemplate.uiKitStyle.floorSelector.inactiveStyle : this.defaultStyle.inactiveStyle;
            style = new JStyle();
            if (mapTemplateInactiveStyle != null) {
                if (mapTemplateInactiveStyle.fill != null) {
                    style.setColor(Color.parseColor((String)mapTemplateInactiveStyle.fill));
                }
                if (mapTemplateInactiveStyle.opacity != null) {
                    style.setStrokeWidth(mapTemplateInactiveStyle.opacity.floatValue());
                }
            } else {
                style.setColor(Color.parseColor((String)"#ffffff"));
            }
            floorSelectorOptions.inactiveStyle = style;
        }
        if (floorSelectorOptions.activeFontStyle == null) {
            JStyleConfig.UiKitStyle.ActiveFont mapTemplateActiveFont = isFloorSelectorPresentInMapTemplate && this.mapTemplate.uiKitStyle.floorSelector.activeFont != null ? this.mapTemplate.uiKitStyle.floorSelector.activeFont : this.defaultStyle.activeFont;
            style = new JStyle();
            if (mapTemplateActiveFont != null) {
                if (mapTemplateActiveFont.fill != null) {
                    style.setColor(Color.parseColor((String)mapTemplateActiveFont.fill));
                }
                if (mapTemplateActiveFont.fontFamily != null && typefaces.contains(typeface = Typeface.create((String)(fontFamily = mapTemplateActiveFont.fontFamily), (int)0))) {
                    style.setTypeFace(typeface);
                }
            }
            floorSelectorOptions.activeFontStyle = style;
        }
        if (floorSelectorOptions.inactiveFontStyle == null) {
            JStyleConfig.UiKitStyle.InactiveFont mapTemplateInActiveFont = isFloorSelectorPresentInMapTemplate && this.mapTemplate.uiKitStyle.floorSelector.inactiveFont != null ? this.mapTemplate.uiKitStyle.floorSelector.inactiveFont : this.defaultStyle.inactiveFont;
            style = new JStyle();
            if (mapTemplateInActiveFont != null) {
                if (mapTemplateInActiveFont.fill != null) {
                    style.setColor(Color.parseColor((String)mapTemplateInActiveFont.fill));
                }
                if (mapTemplateInActiveFont.fontFamily != null && typefaces.contains(typeface = Typeface.create((String)(fontFamily = mapTemplateInActiveFont.fontFamily), (int)0))) {
                    style.setTypeFace(typeface);
                }
            }
            floorSelectorOptions.inactiveFontStyle = style;
        }
        this.floorSelector.setOptions(floorSelectorOptions);
        float[] padding = isFloorSelectorPresentInMapTemplate && this.mapTemplate.uiKitStyle.floorSelector.padding != null ? this.mapTemplate.uiKitStyle.floorSelector.padding : this.defaultStyle.padding;
        params.setMargins(Math.round(padding[3]), Math.round(padding[0]), Math.round(padding[1]), Math.round(padding[2]));
        this.floorSelector.setLayoutParams((ViewGroup.LayoutParams)params);
        LinearLayout floorButtonContainer = new LinearLayout(this.context);
        floorButtonContainer.setId(R.id.floor_container);
        boolean isVerticalBottom = false;
        boolean isHorizontalRight = false;
        if (floorSelectorOptions.vertical) {
            scrollView = new ScrollView(this.context);
            this.animationIn = Techniques.FadeInDown;
            this.animationOut = Techniques.FadeOutUp;
            this.floorSelector.setOrientation(1);
            floorButtonContainer.setOrientation(1);
            isVerticalBottom = floorSelectorOptions.position[1] == 12;
        } else {
            scrollView = new HorizontalScrollView(this.context);
            this.animationIn = Techniques.FadeInLeft;
            this.animationOut = Techniques.FadeOutLeft;
            this.floorSelector.setOrientation(0);
            floorButtonContainer.setOrientation(0);
            isHorizontalRight = floorSelectorOptions.position[0] == 11;
        }
        scrollView.setId(R.id.scroll_view);
        scrollView.setVisibility(4);
        LinearLayout.LayoutParams scrollViewParams = new LinearLayout.LayoutParams(-1, -2);
        scrollViewParams.weight = 1.0f;
        scrollView.setLayoutParams((ViewGroup.LayoutParams)scrollViewParams);
        scrollView.setPadding(0, 0, 0, 0);
        if (addView) {
            scrollView.post(new Runnable((FrameLayout)scrollView, floorButtonContainer){
                final /* synthetic */ FrameLayout val$scrollView;
                final /* synthetic */ LinearLayout val$floorButtonContainer;
                {
                    this.val$scrollView = frameLayout;
                    this.val$floorButtonContainer = linearLayout;
                }

                @Override
                public void run() {
                    this.val$scrollView.addView((View)this.val$floorButtonContainer);
                }
            });
        }
        if (isVerticalBottom || isHorizontalRight) {
            if (addView) {
                this.floorSelector.addView((View)scrollView, 0);
            }
            if (isVerticalBottom) {
                this.animationIn = Techniques.FadeInUp;
                this.animationOut = Techniques.FadeOutDown;
            } else {
                this.animationIn = Techniques.FadeInRight;
                this.animationOut = Techniques.FadeOutRight;
            }
        } else if (addView) {
            this.floorSelector.addView((View)scrollView);
        }
        this.setupSelectedFloorButton(floorSelectorOptions, floorButtonContainer);
        this.floorButtonContainer = floorButtonContainer;
        if (addView) {
            this.uiContainer.post(new Runnable(){

                @Override
                public void run() {
                    MapUiKit.this.uiContainer.addView((View)MapUiKit.this.floorSelector, (ViewGroup.LayoutParams)params);
                }
            });
        }
        return this.floorSelector;
    }

    public FloorSelector renderFloorSelector() {
        return this.renderFloorSelector(new FloorSelectorOptions());
    }

    public Search renderSearch(SearchOptions searchOptions, final @NonNull Search.OnItemSelectListener onItemSelectListener) {
        if (onItemSelectListener == null) {
            return null;
        }
        boolean addView = false;
        if (this.search == null) {
            this.search = new Search(this.context);
            this.search.setId(R.id.map_ui_search);
            this.search.setIconified(false);
            this.search.clearFocus();
            addView = true;
        }
        if (searchOptions == null) {
            searchOptions = new SearchOptions(null);
        }
        this.search.setOptions(searchOptions);
        this.search.setQueryHint(searchOptions.hint);
        if (searchOptions.searchArray == null) {
            Destination[] destinations = this.controller.getActiveVenue().getDestinations().getAll();
            Amenity[] amenities = this.controller.getActiveVenue().getAmenities().getAll();
            PathType[] pathTypes = this.controller.getActiveVenue().getPathTypes().getAll();
            ArrayList<Object> baseModelArrayList = new ArrayList<Object>();
            baseModelArrayList.addAll(Arrays.asList(destinations));
            baseModelArrayList.addAll(Arrays.asList(amenities));
            baseModelArrayList.addAll(Arrays.asList(pathTypes));
            searchOptions.searchArray = new BaseModel[baseModelArrayList.size()];
            searchOptions.searchArray = baseModelArrayList.toArray(searchOptions.searchArray);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.search.setBackground(this.context.getDrawable(R.drawable.rounded_corner));
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        if (this.mapTemplate != null && this.mapTemplate.uiKitStyle != null && this.mapTemplate.uiKitStyle.search != null && this.mapTemplate.uiKitStyle.search.padding != null && this.mapTemplate.uiKitStyle.search.padding.length == 4) {
            Float[] margins = this.mapTemplate.uiKitStyle.search.padding;
            params.setMargins(Math.round(margins[3].floatValue()), Math.round(margins[0].floatValue()), Math.round(margins[1].floatValue()), Math.round(margins[2].floatValue()));
        } else {
            params.setMargins(20, 20, 20, 20);
        }
        if (this.mapTemplate != null && this.mapTemplate.uiKitStyle != null && this.mapTemplate.uiKitStyle.search != null && this.mapTemplate.uiKitStyle.search.position != null && this.mapTemplate.uiKitStyle.search.position.length == 2) {
            Float[] position = this.mapTemplate.uiKitStyle.search.position;
            params.addRule(Math.round(position[0].floatValue()), Math.round(position[1].floatValue()));
        } else {
            params.addRule(searchOptions.position);
        }
        this.search.setLayoutParams((ViewGroup.LayoutParams)params);
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)this.search.findViewById(R.id.search_src_text);
        autoCompleteTextView.setThreshold(1);
        autoCompleteTextView.setImeOptions(0x10000000);
        ImageView closeButton = (ImageView)this.search.findViewById(R.id.search_close_btn);
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EditText editText = (EditText)MapUiKit.this.search.findViewById(R.id.search_src_text);
                editText.setText((CharSequence)"");
                MapUiKit.this.search.setQuery("", false);
                MapUiKit.this.search.onActionViewCollapsed();
                MapUiKit.this.search.setIconified(false);
                MapUiKit.this.search.clearFocus();
                MapUiKit.this.hideKeyboard((Activity)MapUiKit.this.context);
                if (MapUiKit.this.controller != null) {
                    MapUiKit.this.controller.clearWayfindingPath();
                }
            }
        });
        this.search.post(new Runnable(){

            @Override
            public void run() {
                MapUiKit.this.search.setSuggestionsAdapter((CursorAdapter)new SimpleCursorAdapter(MapUiKit.this.context, 17367043, null, new String[]{"suggest_text_1"}, new int[]{16908308}, 2));
                MapUiKit.this.search.setOnSuggestionListener(new SearchView.OnSuggestionListener(){

                    public boolean onSuggestionSelect(int position) {
                        return false;
                    }

                    public boolean onSuggestionClick(int position) {
                        Cursor cursor = MapUiKit.this.search.getSuggestionsAdapter().getCursor();
                        cursor.moveToPosition(position);
                        int id2 = cursor.getInt(0);
                        int type = cursor.getInt(2);
                        Destination baseModel = null;
                        if (type == 0) {
                            baseModel = MapUiKit.this.controller.getActiveVenue().getDestinations().getById(id2);
                        } else if (type == 1) {
                            baseModel = MapUiKit.this.controller.getActiveVenue().getAmenities().getById(id2);
                        } else if (type == 2) {
                            baseModel = MapUiKit.this.controller.getActiveVenue().getPathTypes().getById(id2);
                        }
                        onItemSelectListener.onItemClick((BaseModel)baseModel);
                        return false;
                    }
                });
            }
        });
        this.search.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                return query.length() >= 1;
            }

            public boolean onQueryTextChange(String newText) {
                if (newText.length() >= 1) {
                    new FetchAutoCompleteSuggestionsTask().execute(new String[]{newText});
                }
                return true;
            }
        });
        if (addView) {
            this.uiContainer.post(new Runnable(){

                @Override
                public void run() {
                    MapUiKit.this.uiContainer.addView((View)MapUiKit.this.search);
                }
            });
        }
        return this.search;
    }

    public PopupDrawable renderPopup(PopupDrawableOptions popupOptions, @NonNull PointF coordinates) {
        String subTextFontFamily;
        Typeface typeface;
        boolean isPopupPresentInMapTemplate;
        boolean bl = isPopupPresentInMapTemplate = this.mapTemplate != null && this.mapTemplate.uiKitStyle != null && this.mapTemplate.uiKitStyle.popup != null;
        if (popupOptions == null) {
            popupOptions = new PopupDrawableOptions("Default popup text");
            if (isPopupPresentInMapTemplate && this.mapTemplate.uiKitStyle.popup.showActionButton) {
                popupOptions.setShowActionButton(true);
            }
        }
        if (popupOptions.titleTextStyle == null) {
            popupOptions.titleTextStyle = new JStyle();
            if (isPopupPresentInMapTemplate && this.mapTemplate.uiKitStyle.popup.titleTextFont != null) {
                String titleTextFontFamily = this.mapTemplate.uiKitStyle.popup.titleTextFont.fontFamily;
                String titleTextColor = this.mapTemplate.uiKitStyle.popup.titleTextFont.fill;
                if (titleTextFontFamily != null && typefaces.contains(typeface = Typeface.create((String)titleTextFontFamily, (int)0))) {
                    popupOptions.titleTextStyle.setTypeFace(typeface);
                }
                if (titleTextColor != null) {
                    popupOptions.titleTextStyle.setColor(Color.parseColor((String)titleTextColor));
                }
            } else {
                subTextFontFamily = this.defaultStyle.activeFont.fontFamily;
                popupOptions.titleTextStyle.setAntiAlias(true);
                popupOptions.titleTextStyle.setColor(Color.parseColor((String)"#000000"));
                Typeface typeface2 = Typeface.create((String)subTextFontFamily, (int)0);
                if (typefaces.contains(typeface2)) {
                    popupOptions.titleTextStyle.setTypeFace(typeface2);
                }
            }
            popupOptions.setTitleText(popupOptions.titleText != null ? popupOptions.titleText : this.context.getString(R.string.popup_default_text));
        }
        if (popupOptions.subTextStyle == null && isPopupPresentInMapTemplate) {
            String subTextColor;
            popupOptions.subTextStyle = new JStyle();
            if (this.mapTemplate.uiKitStyle.popup.subTextFont != null) {
                subTextFontFamily = this.mapTemplate.uiKitStyle.popup.subTextFont.fontFamily;
                subTextColor = this.mapTemplate.uiKitStyle.popup.subTextFont.fill;
                if (subTextFontFamily != null && typefaces.contains(typeface = Typeface.create((String)subTextFontFamily, (int)0))) {
                    popupOptions.subTextStyle.setTypeFace(typeface);
                }
                if (subTextColor != null) {
                    popupOptions.subTextStyle.setColor(Color.parseColor((String)subTextColor));
                }
            } else {
                subTextFontFamily = this.defaultStyle.activeFont.fontFamily;
                subTextColor = "#000000";
                typeface = Typeface.create((String)subTextFontFamily, (int)0);
                if (typefaces.contains(typeface)) {
                    popupOptions.subTextStyle.setTypeFace(typeface);
                }
                popupOptions.subTextStyle.setColor(Color.parseColor((String)subTextColor));
            }
            popupOptions.setSubText(popupOptions.subText != null ? popupOptions.subText : this.context.getString(R.string.set_subtext));
        }
        if (popupOptions.actionButtonStyle == null) {
            String actionButtonColor;
            popupOptions.actionButtonStyle = new JStyle();
            if (isPopupPresentInMapTemplate && this.mapTemplate.uiKitStyle.popup.actionButtonStyle != null) {
                actionButtonColor = this.mapTemplate.uiKitStyle.popup.actionButtonStyle.fill;
                if (actionButtonColor != null) {
                    popupOptions.actionButtonStyle.setColor(Color.parseColor((String)actionButtonColor));
                }
            } else {
                actionButtonColor = "#1464FA";
                popupOptions.actionButtonStyle.setColor(Color.parseColor((String)actionButtonColor));
            }
            popupOptions.setShowActionButton(true);
            popupOptions.setActionButtonText(popupOptions.actionButtonText != null ? popupOptions.actionButtonText : this.context.getString(R.string.popup_action_button_text));
        }
        if (popupOptions.actionButtonTextStyle == null) {
            String actionButtonTextColor;
            String actionButtonTextFontFamily;
            popupOptions.actionButtonTextStyle = new JStyle();
            if (isPopupPresentInMapTemplate && this.mapTemplate.uiKitStyle.popup.actionButtonTextFont != null) {
                actionButtonTextFontFamily = this.mapTemplate.uiKitStyle.popup.actionButtonTextFont.fontFamily;
                actionButtonTextColor = this.mapTemplate.uiKitStyle.popup.actionButtonTextFont.fill;
                if (actionButtonTextColor != null) {
                    popupOptions.actionButtonTextStyle.setColor(Color.parseColor((String)actionButtonTextColor));
                }
                if (typefaces.contains(typeface = Typeface.create((String)actionButtonTextFontFamily, (int)0))) {
                    popupOptions.actionButtonTextStyle.setTypeFace(typeface);
                }
            } else {
                actionButtonTextFontFamily = this.defaultStyle.activeFont.fontFamily;
                actionButtonTextColor = "#ffffff";
                popupOptions.actionButtonTextStyle.setColor(Color.parseColor((String)actionButtonTextColor));
                typeface = Typeface.create((String)actionButtonTextFontFamily, (int)0);
                if (typefaces.contains(typeface)) {
                    popupOptions.actionButtonTextStyle.setTypeFace(typeface);
                }
                popupOptions.setActionButtonText("Default text");
            }
        }
        if (popupOptions.popupStyle == null) {
            popupOptions.popupStyle = new JStyle();
            if (isPopupPresentInMapTemplate && this.mapTemplate.uiKitStyle.popup.popupStyle != null) {
                Float opacity;
                String popupColor = this.mapTemplate.uiKitStyle.popup.popupStyle.fill;
                if (popupColor != null) {
                    popupOptions.popupStyle.setColor(Color.parseColor((String)popupColor));
                }
                if ((opacity = this.mapTemplate.uiKitStyle.popup.popupStyle.opacity) != null) {
                    popupOptions.popupStyle.setAlpha((int)(opacity.floatValue() * 255.0f));
                }
            } else {
                String popupStyleFill = "#ffffff";
                popupOptions.popupStyle.setColor(Color.parseColor((String)popupStyleFill));
            }
        }
        popupOptions.setCoordinates(coordinates);
        if (!this.allowConcurrentPopups) {
            for (MapDrawable mapDrawable : this.controller.getMapDrawables()) {
                MapLayer mapLayer = mapDrawable.getMapLayer("Popups");
                if (mapLayer == null) continue;
                mapLayer.clearCustomDrawables();
            }
        }
        this.popupDrawable = new PopupDrawable(popupOptions);
        this.popupDrawable.setOptions(popupOptions);
        this.controller.addComponent((JDrawable)this.popupDrawable, popupOptions.map != null ? popupOptions.map : this.controller.getCurrentMap(), popupOptions.coordinates, "Popups");
        this.popupDrawable.setRotation(-this.controller.getMapView().getCurrentRotation());
        this.popupDrawable.setScale(this.controller.getMapView().getCurrentScale());
        this.controller.setOnRotateListener(new MapView.OnRotateListener(){

            public void onRotateChanged(float v) {
                float delta = -v;
                MapUiKit.this.popupDrawable.setRotation(delta);
                if (MapUiKit.this.compass != null) {
                    final float deltaCompass = v - MapUiKit.this.compass.getRotation();
                    MapUiKit.this.compass.post(new Runnable(){

                        @Override
                        public void run() {
                            if (((MapUiKit)MapUiKit.this).compass.isCompassNorth) {
                                MapUiKit.this.compass.setImageResource(((MapUiKit)MapUiKit.this).compassOptions.rotatedIcon);
                                ((MapUiKit)MapUiKit.this).compass.isCompassNorth = false;
                            }
                            MapUiKit.this.compass.setRotation(MapUiKit.this.compass.getRotation() + deltaCompass);
                        }
                    });
                }
            }
        });
        this.controller.setOnScaleListener(new MapView.OnScaleListener(){

            public void onScaleChanged(float v) {
                MapUiKit.this.popupDrawable.setScale(v);
            }
        });
        return this.popupDrawable;
    }

    public void setAllowConcurrentPopups(boolean allowConcurrentPopups) {
        this.allowConcurrentPopups = allowConcurrentPopups;
    }

    public RelativeLayout getUiContainer() {
        return this.uiContainer;
    }

    private void setupSelectedFloorButton(final FloorSelectorOptions floorSelectorOptions, final LinearLayout floorButtonContainer) {
        Floor currentFloor = this.controller.getCurrentFloor();
        final FloorButton selectedFloorButton = (FloorButton)this.floorSelector.findViewById(R.id.main_floor_button);
        selectedFloorButton.setMain(true);
        this.styleButton(selectedFloorButton, currentFloor, floorSelectorOptions.activeStyle, floorSelectorOptions.activeFontStyle);
        selectedFloorButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!selectedFloorButton.isSelected()) {
                    MapUiKit.this.expandFloorSelector(floorButtonContainer, floorSelectorOptions);
                } else {
                    MapUiKit.this.collapseFloorSelector();
                }
            }
        });
    }

    private void collapseFloorSelector() {
        FloorButton mainButton = (FloorButton)this.floorSelector.findViewById(R.id.main_floor_button);
        mainButton.setSelected(false);
        FrameLayout scrollView = (FrameLayout)this.floorSelector.findViewById(R.id.scroll_view);
        YoYo.with((Techniques)this.animationOut).duration(700L).playOn((View)scrollView);
        this.removeFloorButtons();
    }

    private void removeFloorButtons() {
        for (FloorButton floorButton : this.floorButtons) {
            this.floorButtonContainer.removeView((View)floorButton);
        }
        this.floorButtons.clear();
    }

    private void expandFloorSelector(LinearLayout floorButtonContainer, FloorSelectorOptions floorSelectorOptions) {
        this.setupFloorButtons(floorButtonContainer, floorSelectorOptions);
        final FloorButton mainButton = (FloorButton)this.floorSelector.findViewById(R.id.main_floor_button);
        new CountDownTimer(200L, 200L){

            public void onTick(long millisUntilFinished) {
                mainButton.setEnabled(false);
            }

            public void onFinish() {
                mainButton.setSelected(true);
                FrameLayout scrollView = (FrameLayout)MapUiKit.this.floorSelector.findViewById(R.id.scroll_view);
                scrollView.setVisibility(0);
                YoYo.with((Techniques)MapUiKit.this.animationIn).duration(700L).playOn((View)scrollView);
                mainButton.setEnabled(true);
            }
        }.start();
    }

    private void setupFloorButtons(final LinearLayout floorButtonContainer, final FloorSelectorOptions floorSelectorOptions) {
        Floor[] floors = this.controller.getCurrentBuilding().getFloors().getAll();
        this.floorButtons = new HashSet();
        for (final Floor floor : floors) {
            final FloorButton floorButton = new FloorButton(this.context);
            this.styleButton(floorButton, floor, floorSelectorOptions.inactiveStyle, floorSelectorOptions.inactiveFontStyle);
            this.floorButtons.add(floorButton);
            floorButtonContainer.post(new Runnable(){

                @Override
                public void run() {
                    if (floorSelectorOptions.position[1] == 12 || floorSelectorOptions.position[0] == 11) {
                        floorButtonContainer.addView((View)floorButton, 0);
                    } else {
                        floorButtonContainer.addView((View)floorButton);
                    }
                }
            });
            floorButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FloorButton mainButton = (FloorButton)MapUiKit.this.floorSelector.findViewById(R.id.main_floor_button);
                    if (mainButton.isSelected()) {
                        mainButton.setText(floorButton.getText());
                        MapUiKit.this.collapseFloorSelector();
                        MapUiKit.this.controller.showMap(floor.getMap(), new JController.OnMapShownCallback(){

                            public void onBeforeMapShown(MapDrawable mapDrawable) {
                            }

                            public void onMapShown() {
                            }

                            public void onError(String s) {
                            }
                        });
                    }
                }
            });
        }
    }

    private void styleButton(FloorButton floorButton, Floor floor, JStyle style, JStyle fontStyle) {
        floorButton.setMapId(floor.getMap().getId());
        Drawable background = floorButton.getBackground();
        if (background instanceof ShapeDrawable) {
            ShapeDrawable shapeDrawable = (ShapeDrawable)background;
            shapeDrawable.getPaint().setColor(style.getColor());
        } else if (background instanceof GradientDrawable) {
            GradientDrawable gradientDrawable = (GradientDrawable)background;
            gradientDrawable.setColor(style.getColor());
            gradientDrawable.setStroke(style.getStrokeColor(), (int)style.getStrokeWidth());
        } else if (background instanceof ColorDrawable) {
            ColorDrawable colorDrawable = (ColorDrawable)background;
            colorDrawable.setColor(style.getColor());
        }
        floorButton.setText(floor.getShortName() != null ? floor.getShortName() : "");
        floorButton.setTextColor(fontStyle.getColor());
        floorButton.setTextSize(fontStyle.getTextSize());
        floorButton.setTypeface(fontStyle.getTypeface());
    }

    private void setupMapUIContainer() {
        this.uiContainer = new RelativeLayout(this.context);
        this.uiContainer.setId(R.id.map_ui_container);
        this.uiContainer.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.stage.post(new Runnable(){

            @Override
            public void run() {
                MapUiKit.this.stage.addView((View)MapUiKit.this.uiContainer);
            }
        });
    }

    private void setupMapTemplate() {
        this.mapTemplate = this.activeVenue.getDefaultMapTemplate();
    }

    @Subscribe
    public void onEvent(AnalyticsEvent event) {
        Floor currentFloor;
        Map map;
        if (event.getKey() == "JMAP_CONTROLLER_MAP_SHOW" && (map = this.controller.getActiveVenue().getMaps().getById(Integer.valueOf(event.getData("mapId")).intValue())) != null && (currentFloor = this.controller.getCurrentBuilding().getFloors().getByMap(map)) != null) {
            final FloorButton mainButton = (FloorButton)this.floorSelector.findViewById(R.id.main_floor_button);
            ((Activity)this.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    mainButton.setText(currentFloor.getShortName());
                }
            });
        }
    }

    private void hideKeyboard(Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    private class FetchAutoCompleteSuggestionsTask
    extends AsyncTask<String, Void, Cursor> {
        private final String[] sAutocompleteColNames = new String[]{"_id", "suggest_text_1", "type"};

        private FetchAutoCompleteSuggestionsTask() {
        }

        protected Cursor doInBackground(String ... params) {
            Object[] baseModels = JController.getObjectsInArrayByString((Object[])((MapUiKit)MapUiKit.this).search.getOptions().searchArray, (String)params[0].toLowerCase(), null, (Integer)((MapUiKit)MapUiKit.this).search.getOptions().maxResults);
            MatrixCursor cursor = new MatrixCursor(this.sAutocompleteColNames);
            for (Object object : baseModels) {
                BaseModel baseModel = (BaseModel)object;
                String name = null;
                Integer type = null;
                if (baseModel instanceof Destination) {
                    name = ((Destination)baseModel).getName();
                    type = 0;
                } else if (baseModel instanceof Amenity) {
                    name = ((Amenity)baseModel).getName();
                    type = 1;
                } else if (baseModel instanceof PathType) {
                    name = ((PathType)baseModel).getName();
                    type = 2;
                }
                Object[] row = new Object[]{baseModel.getId(), name, type};
                cursor.addRow(row);
            }
            return cursor;
        }

        protected void onPostExecute(Cursor result) {
            MapUiKit.this.search.getSuggestionsAdapter().changeCursor(result);
        }
    }
}

