package com.jibestream.mapuikit;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.LinearLayout;

/**
 * Created by Ken Pangilinan on 2018-04-17.
 */

public class FloorButton extends android.support.v7.widget.AppCompatButton {
    private int mapId;
    private boolean isMain;

    public FloorButton(Context context) {
        super(context);

        init();
    }

    public FloorButton(Context context, AttributeSet attrs) {
        super(context, attrs);

        init();
    }

    public FloorButton(Context context, AttributeSet attrs, int defStyleAttr, int mapId) {
        super(context, attrs, defStyleAttr);

        init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            setBackground(getResources().getDrawable(R.drawable.rounded_button, null));
        }

        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.WRAP_CONTENT,
                LinearLayout.LayoutParams.WRAP_CONTENT
        );
        params.setMargins(10, 10, 10, 10);
        setTextSize(20);
        setLayoutParams(params);
        setMaxLines(1);
        setEllipsize(TextUtils.TruncateAt.END);
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public int getMapId() {
        return mapId;
    }

    public void setMain(boolean main) {
        isMain = main;
    }

    public boolean isMain() {
        return isMain;
    }
}