package com.jibestream.mapuikit;

import android.widget.RelativeLayout;

/**
 * Created by Ken Pangilinan on 2018-03-29.
 */

public class CompassOptions {
    int icon;
    int rotatedIcon;

    boolean resetRotationOnTap;
    int[] position;

    /**
     * {@link Compass}' options.
     */
    public CompassOptions() {
        this.icon = R.drawable.ic_compass;
        this.rotatedIcon = R.drawable.ic_rotated_compass;
        this.resetRotationOnTap = true;
    }

    /**
     * @param position Index 0 is to assign where to snap the search on the x-axis.
     *                 RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.CENTER_HORIZONTAL, RelativeLayout.ALIGN_PARENT_RIGHT
     *                 Index 1 is to assign where to snap the search on the y-axis.
     *                 RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.CENTER_VERTICAL, RelativeLayout.ALIGN_PARENT_TOP
     *                 Defaults to bottom-left.
     *
     */
    public void setPosition(int[] position) {
        this.position = position;
    }

    /**
     * @param resId Drawable id of image to replace default compass. ie. {@code compassOptions.setIcon(R.drawable.ic_compass_2);}¬
     */
    public void setIcon(int resId) {
        this.icon = resId;
    }

    public void setRotatedIcon(int resId) {
        this.rotatedIcon = resId;
    }

    /**
     * @param resetRotationOnTap {@code true} = resets the map to point north, {@code false} = do nothing.
     */
    public void setResetRotationOnTap(boolean resetRotationOnTap) {
        this.resetRotationOnTap = resetRotationOnTap;
    }
}
