/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.mapuikit;

import android.content.Context;
import android.os.Build;
import android.support.v7.widget.AppCompatButton;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.jibestream.mapuikit.R;

public class FloorButton
extends AppCompatButton {
    private int mapId;
    private boolean isMain;

    public FloorButton(Context context) {
        super(context);
        this.init();
    }

    public FloorButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FloorButton(Context context, AttributeSet attrs, int defStyleAttr, int mapId) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setBackground(this.getResources().getDrawable(R.drawable.rounded_button, null));
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(10, 10, 10, 10);
        this.setTextSize(20.0f);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setMaxLines(1);
        this.setEllipsize(TextUtils.TruncateAt.END);
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public int getMapId() {
        return this.mapId;
    }

    public void setMain(boolean main) {
        this.isMain = main;
    }

    public boolean isMain() {
        return this.isMain;
    }
}

