/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.analyticskit;

import com.jibestream.jmapandroidsdk.analytics_kit.AnalyticsEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnalyticsKit {
    public static final String EVENT_ENDPOINT = "end_point";
    public static final String EVENT_REQUEST_START_TIME = "start_time";
    public static final String EVENT_REQUEST_END_TIME = "end_time";
    public static final String EVENT_TIME = "event_time";
    public static final String EVENT_DURATION = "duration";
    public static final String EVENT_ID = "id";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_COORDINATES = "coordinates";
    public static final String EVENT_ICON_TYPE = "type";
    public static final String EVENT_SHAPE_TYPE = "type";
    public static final String EVENT_WAYPOINT_ID = "waypoint_id";
    public static final String EVENT_WAYFIND_START_WAYPOINT_ID = "wayfind_start";
    public static final String EVENT_WAYFIND_END_WAYPOINT_ID = "wayfind_end";
    public static final String EVENT_TYPE = "event_type";
    public static final String EVENT_TYPE_API_CALL = "api_call";
    public static final String EVENT_TYPE_PARSE_MAP = "parse_map";
    public static final String EVENT_TYPE_SHOW_MAP = "show_map";
    public static final String EVENT_TYPE_GENERATE_WAYFIND = "generate_wayfind";
    public static final String EVENT_TYPE_TAP_MAP = "tap_map";
    public static final String EVENT_TYPE_TAP_ICON = "tap_icon";
    public static final String EVENT_TYPE_TAP_SHAPE = "tap_shape";
    private static AnalyticsKit ourInstance = new AnalyticsKit();
    private Date serverRequestStart;
    private Date parseMapStart;
    private OnJMapEventListener onJMapEventListener;

    public static AnalyticsKit getInstance() {
        return ourInstance;
    }

    private AnalyticsKit() {
    }

    public void onEvent(AnalyticsEvent analyticsEvent) {
        switch (analyticsEvent.getKey()) {
            case "JMAP_CORE_SERVER_REQUEST_START": {
                this.serverRequestStart = this.getCurrentDateAndTime();
                break;
            }
            case "JMAP_CORE_SERVER_REQUEST_SUCCESS": 
            case "JMAP_CORE_SERVER_REQUEST_FAILED": {
                String endpoint = analyticsEvent.getData("endpoint");
                if (endpoint == null) break;
                String regex = "";
                if (endpoint.contains("building")) {
                    regex = ".*building\\/(\\d*)";
                } else if (endpoint.contains("venue")) {
                    regex = ".*venue\\/(\\d*)";
                } else if (endpoint.contains("customer")) {
                    regex = ".*customer\\/(\\d*)";
                }
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(endpoint);
                String id = null;
                while (matcher.find()) {
                    id = matcher.group(1);
                }
                if (id == null) break;
                Date serverRequestEnd = this.getCurrentDateAndTime();
                String requestStartTime = this.getCurrentDateAndTimeFormatted(this.serverRequestStart);
                String requestEndTime = this.getCurrentDateAndTimeFormatted(serverRequestEnd);
                String duration = this.getDuration(this.serverRequestStart, serverRequestEnd);
                String error = analyticsEvent.getData(EVENT_ERROR);
                HashMap<String, String> event = new HashMap<String, String>();
                event.put(EVENT_TYPE, EVENT_TYPE_API_CALL);
                event.put(EVENT_ID, id);
                event.put(EVENT_ENDPOINT, endpoint);
                event.put(EVENT_REQUEST_START_TIME, requestStartTime);
                event.put(EVENT_REQUEST_END_TIME, requestEndTime);
                event.put(EVENT_DURATION, duration);
                if (error != null) {
                    event.put(EVENT_ERROR, error);
                }
                this.onJMapEventListener.onEvent(event);
                break;
            }
            case "JMAP_ENGINE_PARSING_START": {
                this.parseMapStart = this.getCurrentDateAndTime();
                break;
            }
            case "JMAP_ENGINE_PARSING_SUCCESS": 
            case "JMAP_ENGINE_PARSING_FAILED": {
                String mapId = analyticsEvent.getData("mapId");
                if (mapId == null) break;
                Date serverRequestEnd = this.getCurrentDateAndTime();
                String requestStartTime = this.getCurrentDateAndTimeFormatted(this.parseMapStart);
                String requestEndTime = this.getCurrentDateAndTimeFormatted(serverRequestEnd);
                String duration = this.getDuration(this.parseMapStart, serverRequestEnd);
                String error = analyticsEvent.getData(EVENT_ERROR);
                HashMap<String, String> event = new HashMap<String, String>();
                event.put(EVENT_TYPE, EVENT_TYPE_PARSE_MAP);
                event.put(EVENT_ID, mapId);
                event.put(EVENT_REQUEST_START_TIME, requestStartTime);
                event.put(EVENT_REQUEST_END_TIME, requestEndTime);
                event.put(EVENT_DURATION, duration);
                if (error != null) {
                    event.put(EVENT_ERROR, error);
                }
                this.onJMapEventListener.onEvent(event);
                break;
            }
            case "JMAP_CONTROLLER_MAP_SHOW": {
                String mapId = analyticsEvent.getData("mapId");
                if (mapId == null) break;
                String mapShownTime = this.getCurrentDateAndTimeFormatted();
                HashMap<String, String> event = new HashMap<String, String>();
                event.put(EVENT_TYPE, EVENT_TYPE_SHOW_MAP);
                event.put(EVENT_ID, mapId);
                event.put(EVENT_TIME, mapShownTime);
                this.onJMapEventListener.onEvent(event);
                break;
            }
            case "JMAP_CONTROLLER_GENERATE_WAYPATH": {
                String waypathGeneratedAt = this.getCurrentDateAndTimeFormatted();
                String waypointStartId = analyticsEvent.getData("waypointStartId");
                String waypointEndId = analyticsEvent.getData("waypointEndId");
                String error = analyticsEvent.getData(EVENT_ERROR);
                HashMap<String, String> event = new HashMap<String, String>();
                event.put(EVENT_TYPE, EVENT_TYPE_GENERATE_WAYFIND);
                event.put(EVENT_WAYFIND_START_WAYPOINT_ID, waypointStartId);
                event.put(EVENT_WAYFIND_END_WAYPOINT_ID, waypointEndId);
                event.put(EVENT_TIME, waypathGeneratedAt);
                if (error != null) {
                    event.put(EVENT_ERROR, error);
                }
                this.onJMapEventListener.onEvent(event);
                break;
            }
            case "JMAP_VIEW_TAP": {
                String mapId = analyticsEvent.getData("mapId");
                if (mapId == null) break;
                String coordinates = analyticsEvent.getData(EVENT_COORDINATES);
                String timeTapped = this.getCurrentDateAndTimeFormatted();
                HashMap<String, String> event = new HashMap<String, String>();
                event.put(EVENT_TYPE, EVENT_TYPE_TAP_MAP);
                event.put(EVENT_ID, mapId);
                event.put(EVENT_TIME, timeTapped);
                event.put(EVENT_COORDINATES, coordinates);
                this.onJMapEventListener.onEvent(event);
                break;
            }
            case "JMAP_VIEW_TAP_ICON": {
                String iconId = analyticsEvent.getData("iconId");
                String iconType = analyticsEvent.getData("iconType");
                String waypointId = analyticsEvent.getData("waypointId");
                String timeTapped = this.getCurrentDateAndTimeFormatted();
                HashMap<String, String> event = new HashMap<String, String>();
                event.put(EVENT_TYPE, EVENT_TYPE_TAP_ICON);
                event.put(EVENT_ID, iconId);
                event.put("type", iconType);
                event.put(EVENT_WAYPOINT_ID, waypointId);
                event.put(EVENT_TIME, timeTapped);
                this.onJMapEventListener.onEvent(event);
                break;
            }
            case "JMAP_VIEW_TAP_SHAPE": {
                String shapeId = analyticsEvent.getData("shapeId");
                String shapeType = analyticsEvent.getData("shapeType");
                String waypointIds = analyticsEvent.getData("waypointIds");
                String timeTapped = this.getCurrentDateAndTimeFormatted();
                HashMap<String, String> event = new HashMap<String, String>();
                event.put(EVENT_TYPE, EVENT_TYPE_TAP_SHAPE);
                event.put(EVENT_ID, shapeId);
                event.put("type", shapeType);
                event.put(EVENT_WAYPOINT_ID, waypointIds);
                event.put(EVENT_TIME, timeTapped);
                this.onJMapEventListener.onEvent(event);
                break;
            }
        }
    }

    private Date getCurrentDateAndTime() {
        return new Date();
    }

    private String getCurrentDateAndTimeFormatted() {
        return this.getCurrentDateAndTimeFormatted(new Date());
    }

    private String getCurrentDateAndTimeFormatted(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    private String getDuration(Date startDate, Date endDate) {
        long duration = endDate.getTime() - startDate.getTime();
        return String.valueOf(duration);
    }

    public void setOnJMapEventListener(OnJMapEventListener onJMapEventListener) {
        this.onJMapEventListener = onJMapEventListener;
    }

    public static interface OnJMapEventListener {
        public void onEvent(HashMap<String, String> var1);
    }
}

