/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.util;

import com.jfrog.bintray.client.impl.util.URI;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpException;
import org.apache.http.util.EncodingUtils;

public class URIUtil {
    private static final String UTF8_CHARSET_NAME = "UTF-8";

    public static String encodeQuery(String unescaped) throws HttpException {
        return URIUtil.encodeQuery(unescaped, UTF8_CHARSET_NAME);
    }

    public static String encodeQuery(String unescaped, String charset) throws HttpException {
        return URIUtil.encode(unescaped, URI.allowed_query, charset);
    }

    public static String encode(String unescaped, BitSet allowed) throws HttpException {
        return URIUtil.encode(unescaped, allowed, UTF8_CHARSET_NAME);
    }

    public static String encode(String unescaped, BitSet allowed, String charset) throws HttpException {
        byte[] rawdata = URLCodec.encodeUrl((BitSet)allowed, (byte[])EncodingUtils.getBytes((String)unescaped, (String)charset));
        return EncodingUtils.getAsciiString((byte[])rawdata);
    }

    public static String decode(String escaped) throws HttpException {
        try {
            byte[] rawdata = URLCodec.decodeUrl((byte[])EncodingUtils.getAsciiBytes((String)escaped));
            return EncodingUtils.getString((byte[])rawdata, (String)UTF8_CHARSET_NAME);
        }
        catch (DecoderException e) {
            throw new HttpException(e.getMessage());
        }
    }

    public static String decode(String escaped, String charset) throws HttpException {
        return URI.decode(escaped.toCharArray(), charset);
    }
}

