/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.model;

import com.jfrog.bintray.client.api.ObjectMapperHelper;
import com.jfrog.bintray.client.api.details.VersionDetails;
import com.jfrog.bintray.client.api.model.Version;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionImpl
implements Version {
    private static final Logger log = LoggerFactory.getLogger(VersionImpl.class);
    private String name;
    private String description;
    private String pkg;
    private String repository;
    private String owner;
    private List<String> labels;
    private List<String> attributeNames;
    private DateTime created;
    private DateTime updated;
    private DateTime released;
    private Integer ordinal;
    private String vcsTag;
    private Map<String, Object> other;

    public VersionImpl() {
    }

    public VersionImpl(VersionDetails versionDetails) {
        this.name = versionDetails.getName();
        this.description = versionDetails.getDescription();
        this.pkg = versionDetails.getPkg();
        this.repository = versionDetails.getRepo();
        this.owner = versionDetails.getOwner();
        this.labels = versionDetails.getLabels();
        this.attributeNames = versionDetails.getAttributeNames();
        this.created = versionDetails.getCreated();
        this.updated = versionDetails.getUpdated();
        this.released = versionDetails.getReleased();
        this.ordinal = versionDetails.getOrdinal();
        this.vcsTag = versionDetails.getVcsTag();
        this.other = versionDetails.other();
    }

    public VersionImpl(String name, String description, String pkg, String repository, String owner, List<String> labels, List<String> attributeNames, DateTime created, DateTime updated, DateTime released, int ordinal, String vcsTag) {
        this.name = name;
        this.description = description;
        this.pkg = pkg;
        this.repository = repository;
        this.owner = owner;
        this.labels = labels;
        this.attributeNames = attributeNames;
        this.created = created;
        this.updated = updated;
        this.released = released;
        this.ordinal = ordinal;
        this.vcsTag = vcsTag;
    }

    public static String getCreateUpdateJson(VersionDetails versionDetails) throws IOException {
        String jsonContent;
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            jsonContent = mapper.writeValueAsString((Object)versionDetails);
        }
        catch (IOException e) {
            log.error("Can't process the json file: " + e.getMessage());
            log.debug("{}", (Throwable)e);
            throw e;
        }
        return jsonContent;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String pkg() {
        return this.pkg;
    }

    public String repository() {
        return this.repository;
    }

    public String owner() {
        return this.owner;
    }

    public List<String> labels() {
        return this.labels;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public DateTime created() {
        return this.created;
    }

    public DateTime updated() {
        return this.updated;
    }

    public DateTime released() {
        return this.released;
    }

    public Integer ordinal() {
        return this.ordinal;
    }

    public String vcsTag() {
        return this.vcsTag;
    }

    public Object getFieldByKey(String key) {
        return this.other.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionImpl version = (VersionImpl)o;
        return this.name.equals(version.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Version{getName='" + this.name + '\'' + ", description='" + this.description + '\'' + ", pkg='" + this.pkg + '\'' + ", repository='" + this.repository + '\'' + ", owner='" + this.owner + '\'' + ", labels=" + this.labels + ", attributeNames=" + this.attributeNames + ", created=" + this.created + ", updated=" + this.updated + ", released=" + this.released + ", ordinal=" + this.ordinal + '}';
    }
}

