/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.handle;

import com.jfrog.bintray.client.api.BintrayCallException;
import com.jfrog.bintray.client.api.MultipleBintrayCallException;
import com.jfrog.bintray.client.api.handle.Bintray;
import com.jfrog.bintray.client.api.handle.PackageHandle;
import com.jfrog.bintray.client.api.handle.RepositoryHandle;
import com.jfrog.bintray.client.api.handle.SubjectHandle;
import com.jfrog.bintray.client.api.handle.VersionHandle;
import com.jfrog.bintray.client.impl.handle.SubjectHandleImpl;
import com.jfrog.bintray.client.impl.util.URIUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BintrayImpl
implements Bintray {
    private static final Logger log = LoggerFactory.getLogger(BintrayImpl.class);
    ExecutorService executorService;
    private CloseableHttpClient client;
    private ResponseHandler<HttpResponse> responseHandler = new BintrayResponseHandler();
    private String baseUrl;
    private int signRequestTimeoutPerFile;

    public BintrayImpl(CloseableHttpClient client, String baseUrl, int threadPoolSize, int signRequestTimeoutPerFile) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.executorService = Executors.newFixedThreadPool(threadPoolSize);
        this.signRequestTimeoutPerFile = signRequestTimeoutPerFile;
    }

    public static void addContentTypeJsonHeader(Map<String, String> headers) {
        headers.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
    }

    public static void addContentTypeBinaryHeader(Map<String, String> headers) {
        headers.put("Content-Type", ContentType.DEFAULT_BINARY.getMimeType());
    }

    private static boolean statusNotOk(int statusCode) {
        return statusCode != 200 && statusCode != 201 && statusCode != 202;
    }

    public SubjectHandle subject(String subject) {
        return new SubjectHandleImpl(this, subject);
    }

    public RepositoryHandle repository(String repositoryPath) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public PackageHandle pkg(String packagePath) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public VersionHandle version(String versionPath) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public void close() {
        this.executorService.shutdown();
        HttpClientUtils.closeQuietly((HttpClient)this.client);
    }

    public HttpResponse get(String uri, Map<String, String> headers) throws BintrayCallException {
        HttpGet getRequest = new HttpGet(this.createUrl(uri));
        return this.setHeadersAndExecute((HttpUriRequest)getRequest, headers);
    }

    public HttpResponse head(String uri, Map<String, String> headers) throws BintrayCallException {
        HttpHead headRequest = new HttpHead(this.createUrl(uri));
        return this.setHeadersAndExecute((HttpUriRequest)headRequest, headers);
    }

    public HttpResponse sign(String uri, Map<String, String> headers, int fileCount) throws BintrayCallException {
        HttpPost signRequest = new HttpPost(this.createUrl(uri));
        this.setHeaders((HttpUriRequest)signRequest, headers);
        signRequest.setConfig(RequestConfig.custom().setSocketTimeout(this.signRequestTimeoutPerFile * fileCount).setConnectionRequestTimeout(this.signRequestTimeoutPerFile * fileCount).setConnectTimeout(this.signRequestTimeoutPerFile * fileCount).build());
        RequestRunner runner = new RequestRunner((HttpRequestBase)signRequest, this.client, this.responseHandler);
        Future<String> signResponse = this.executorService.submit(runner);
        try {
            signResponse.get();
        }
        catch (Exception e) {
            BintrayCallException bce = e.getCause() instanceof BintrayCallException ? (BintrayCallException)e.getCause() : new BintrayCallException(409, e.getMessage(), e.getCause() == null ? "" : ", " + e.getCause().toString() + " : " + e.getCause().getMessage());
            log.error(bce.toString());
            log.debug("{}", (Object)e.getMessage(), (Object)e);
            throw bce;
        }
        String entity = "Signing the version was successful";
        HttpResponse response = DefaultHttpResponseFactory.INSTANCE.newHttpResponse(new ProtocolVersion("HTTP", 1, 1), 201, (HttpContext)new HttpClientContext());
        response.setEntity((HttpEntity)new StringEntity(entity, Charset.forName("UTF-8")));
        return response;
    }

    public HttpResponse post(String uri, Map<String, String> headers) throws BintrayCallException {
        HttpPost postRequest = new HttpPost(this.createUrl(uri));
        return this.setHeadersAndExecute((HttpUriRequest)postRequest, headers);
    }

    public HttpResponse post(String uri, Map<String, String> headers, InputStream elementInputStream) throws BintrayCallException {
        HttpPost postRequest = new HttpPost(this.createUrl(uri));
        InputStreamEntity requestEntity = new InputStreamEntity(elementInputStream);
        postRequest.setEntity((HttpEntity)requestEntity);
        return this.setHeadersAndExecute((HttpUriRequest)postRequest, headers);
    }

    public HttpResponse patch(String uri, Map<String, String> headers, InputStream elementInputStream) throws BintrayCallException {
        HttpPatch patchRequest = new HttpPatch(this.createUrl(uri));
        InputStreamEntity requestEntity = new InputStreamEntity(elementInputStream);
        patchRequest.setEntity((HttpEntity)requestEntity);
        return this.setHeadersAndExecute((HttpUriRequest)patchRequest, headers);
    }

    public HttpResponse delete(String uri, Map<String, String> headers) throws BintrayCallException {
        HttpDelete deleteRequest = new HttpDelete(this.createUrl(uri));
        return this.setHeadersAndExecute((HttpUriRequest)deleteRequest, headers);
    }

    public HttpResponse putBinary(String uri, Map<String, String> headers, InputStream elementInputStream) throws BintrayCallException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        BintrayImpl.addContentTypeBinaryHeader(headers);
        return this.put(uri, headers, elementInputStream);
    }

    public HttpResponse putBinary(Map<String, InputStream> uriAndStreamMap, Map<String, String> headers) throws MultipleBintrayCallException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        BintrayImpl.addContentTypeBinaryHeader(headers);
        return this.put(uriAndStreamMap, headers);
    }

    public HttpResponse put(String uri, Map<String, String> headers, InputStream elementInputStream) throws BintrayCallException {
        HttpPut putRequest = new HttpPut(this.createUrl(uri));
        InputStreamEntity requestEntity = new InputStreamEntity(elementInputStream);
        putRequest.setEntity((HttpEntity)requestEntity);
        return this.setHeadersAndExecute((HttpUriRequest)putRequest, headers);
    }

    public HttpResponse put(Map<String, InputStream> uriAndStreamMap, Map<String, String> headers) throws MultipleBintrayCallException {
        ArrayList<Future<String>> executions = new ArrayList();
        ArrayList<BintrayCallException> errors = new ArrayList<BintrayCallException>();
        List<RequestRunner> runners = this.createPutRequestRunners(uriAndStreamMap, headers, errors);
        try {
            executions = this.executorService.invokeAll(runners);
        }
        catch (InterruptedException e) {
            BintrayCallException bce = new BintrayCallException(409, e.getMessage(), e.getCause() == null ? "" : e.getCause().toString() + " : " + e.getCause().getMessage());
            log.error(bce.toString());
            log.debug("{}", (Object)e.getMessage(), (Object)e);
            errors.add(bce);
        }
        this.collectResults(executions, errors);
        if (errors.isEmpty()) {
            String entity = "Operation Successful";
            HttpResponse response = DefaultHttpResponseFactory.INSTANCE.newHttpResponse(new ProtocolVersion("HTTP", 1, 1), 201, (HttpContext)new HttpClientContext());
            response.setEntity((HttpEntity)new StringEntity(entity, Charset.forName("UTF-8")));
            return response;
        }
        throw new MultipleBintrayCallException(errors);
    }

    private List<RequestRunner> createPutRequestRunners(Map<String, InputStream> uriAndStreamMap, Map<String, String> headers, List<BintrayCallException> errors) {
        ArrayList<RequestRunner> runners = new ArrayList<RequestRunner>();
        ArrayList<HttpPut> requests = new ArrayList<HttpPut>();
        log.debug("Creating PUT requests and RequestRunners for execution");
        for (String apiPath : uriAndStreamMap.keySet()) {
            HttpPut putRequest;
            try {
                putRequest = new HttpPut(this.createUrl(apiPath));
            }
            catch (BintrayCallException bce) {
                errors.add(bce);
                continue;
            }
            InputStreamEntity requestEntity = new InputStreamEntity(uriAndStreamMap.get(apiPath));
            putRequest.setEntity((HttpEntity)requestEntity);
            this.setHeaders((HttpUriRequest)putRequest, headers);
            requests.add(putRequest);
        }
        for (HttpPut request : requests) {
            RequestRunner runner = new RequestRunner((HttpRequestBase)request, this.client, this.responseHandler);
            runners.add(runner);
        }
        return runners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectResults(List<Future<String>> executions, List<BintrayCallException> errors) {
        while (!executions.isEmpty()) {
            log.debug("Querying execution Futures for results");
            Iterator<Future<String>> executionIter = executions.iterator();
            while (executionIter.hasNext()) {
                Future<String> execution = executionIter.next();
                if (!execution.isDone()) continue;
                try {
                    String response = execution.get();
                    log.debug("Got complete execution: {}", (Object)response);
                }
                catch (Exception e) {
                    BintrayCallException bce = e.getCause() instanceof BintrayCallException ? (BintrayCallException)e.getCause() : new BintrayCallException(400, e.getMessage(), e.getCause() == null ? "" : e.getCause().getMessage());
                    log.error(bce.toString());
                    log.debug("{}", (Object)e.getMessage(), (Object)e);
                    errors.add(bce);
                }
                finally {
                    executionIter.remove();
                }
            }
        }
    }

    private String createUrl(String queryPath) throws BintrayCallException {
        log.debug("Trying to encode uri: '{}' with base url: {}", (Object)queryPath, (Object)this.baseUrl);
        try {
            return URIUtil.encodeQuery(this.baseUrl + "/" + queryPath);
        }
        catch (HttpException e) {
            throw new BintrayCallException(400, "Malformed url, request will not be sent: ", e.getMessage());
        }
    }

    private void setHeaders(HttpUriRequest request, Map<String, String> headers) {
        if (headers != null && !headers.isEmpty()) {
            for (String header : headers.keySet()) {
                request.setHeader(header, headers.get(header));
            }
        }
    }

    private HttpResponse setHeadersAndExecute(HttpUriRequest request, Map<String, String> headers) throws BintrayCallException {
        this.setHeaders(request, headers);
        return this.execute(request, null);
    }

    private HttpResponse execute(HttpUriRequest request, HttpClientContext context) throws BintrayCallException {
        log.debug("Executing {} request to path '{}', with headers: {}", new Object[]{request.getMethod(), request.getURI(), Arrays.toString(request.getAllHeaders())});
        try {
            if (context != null) {
                return (HttpResponse)this.client.execute(request, this.responseHandler, (HttpContext)context);
            }
            return (HttpResponse)this.client.execute(request, this.responseHandler);
        }
        catch (BintrayCallException bce) {
            log.debug("{}", (Object)bce.toString(), (Object)bce);
            throw bce;
        }
        catch (IOException ioe) {
            String underlyingCause = ioe.getCause() == null ? "" : ioe.toString() + " : " + ioe.getCause().getMessage();
            log.debug("{}", (Object)ioe.getMessage(), (Object)ioe);
            throw new BintrayCallException(400, ioe.getClass() + " : " + ioe.getMessage(), underlyingCause);
        }
    }

    private class BintrayResponseHandler
    implements ResponseHandler<HttpResponse> {
        private BintrayResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpResponse handleResponse(HttpResponse response) throws BintrayCallException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (BintrayImpl.statusNotOk(statusCode)) {
                BintrayCallException bce = new BintrayCallException(response);
                HttpClientUtils.closeQuietly((CloseableHttpResponse)((CloseableHttpResponse)response));
                throw bce;
            }
            String entity = "";
            if (response.getEntity() != null && statusCode != 500 && statusCode != 405) {
                try {
                    entity = IOUtils.toString((InputStream)response.getEntity().getContent());
                }
                catch (IOException | NullPointerException exception) {
                }
                finally {
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)((CloseableHttpResponse)response));
                }
            }
            HttpResponse newResponse = DefaultHttpResponseFactory.INSTANCE.newHttpResponse(response.getStatusLine(), (HttpContext)new HttpClientContext());
            newResponse.setEntity((HttpEntity)new StringEntity(entity, Charset.forName("UTF-8")));
            newResponse.setHeaders(response.getAllHeaders());
            return newResponse;
        }
    }

    private static class RequestRunner
    implements Callable<String> {
        private final HttpRequestBase request;
        private final CloseableHttpClient client;
        private final HttpClientContext context;
        private final ResponseHandler<HttpResponse> responseHandler;

        public RequestRunner(HttpRequestBase request, CloseableHttpClient client, ResponseHandler<HttpResponse> responseHandler) {
            this.request = request;
            this.client = client;
            this.context = HttpClientContext.create();
            this.responseHandler = responseHandler;
        }

        @Override
        public String call() throws BintrayCallException {
            HttpResponse response;
            StringBuilder errorResultBuilder;
            String requestPath;
            log.debug("Executing {} request to path '{}', with headers: {}", new Object[]{this.request.getMethod(), this.request.getURI(), Arrays.toString(this.request.getAllHeaders())});
            if (this.request instanceof HttpPut) {
                requestPath = this.request.getURI().getPath().substring(9);
                log.info("Pushing " + requestPath);
                errorResultBuilder = new StringBuilder(" Pushing " + requestPath + " failed: ");
            } else {
                requestPath = this.request.getURI().getPath();
                errorResultBuilder = new StringBuilder(this.request.getMethod() + " " + requestPath + " failed: ");
            }
            try {
                response = (HttpResponse)this.client.execute((HttpUriRequest)this.request, this.responseHandler, (HttpContext)this.context);
            }
            catch (BintrayCallException bce) {
                log.debug("{}", (Object)bce.getMessage(), (Object)bce);
                errorResultBuilder.append(bce.getMessage());
                bce.setMessage(errorResultBuilder.toString());
                throw bce;
            }
            catch (IOException ioe) {
                log.debug("IOException occurred: '{}'", (Object)ioe.getMessage(), (Object)ioe);
                String cause = ioe.getCause() != null ? ", caused by: " + ioe.getCause().toString() + " : " + ioe.getCause().getMessage() : "";
                errorResultBuilder.append(ioe.toString()).append(" : ").append(ioe.getMessage()).append(cause);
                throw new BintrayCallException(400, ioe.getMessage(), errorResultBuilder.toString());
            }
            finally {
                this.request.releaseConnection();
            }
            if (BintrayImpl.statusNotOk(response.getStatusLine().getStatusCode())) {
                bce = new BintrayCallException(response);
                errorResultBuilder.append(bce.getMessage());
                bce.setMessage(errorResultBuilder.toString());
                throw bce;
            }
            return this.request.getMethod() + " " + requestPath + ": " + String.valueOf(response.getStatusLine().getStatusCode());
        }
    }
}

