/*
 * Decompiled with CFR 0.152.
 */
package com.jeequan.jeepay.net;

import com.jeequan.jeepay.Jeepay;

public class RequestOptions {
    private String uri;
    private String version;
    private String signType;
    private String apiKey;
    private int connectTimeout;
    private int readTimeout;
    private int maxNetworkRetries;
    private String acceptLanguage;

    public static RequestOptions getDefault(String uri, String version) {
        return new RequestOptions(uri, version, "MD5", Jeepay.apiKey, Jeepay.getConnectTimeout(), Jeepay.getReadTimeout(), Jeepay.getMaxNetworkRetries(), Jeepay.getAcceptLanguage());
    }

    private RequestOptions(String uri, String version, String signType, String apiKey, int connectTimeout, int readTimeout, int maxNetworkRetries, String acceptLanguage) {
        this.uri = uri;
        this.version = version;
        this.signType = signType;
        this.apiKey = apiKey;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.acceptLanguage = acceptLanguage;
    }

    public String getUri() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSignType() {
        return this.signType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    private static String normalizeApiUri(String apiUri) {
        if (apiUri == null) {
            throw new InvalidRequestOptionsException("\u63a5\u53e3URI\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (apiUri.startsWith("/")) {
            throw new InvalidRequestOptionsException("\u63a5\u53e3URI(" + apiUri + ")\u4e0d\u80fd\u4ee5'/'\u5f00\u5934");
        }
        return apiUri;
    }

    private static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        String normalized = apiKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("API key\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return normalized;
    }

    private static String normalizeAcceptLanguage(String acceptLanguage) {
        if (acceptLanguage == null) {
            return null;
        }
        String normalized = acceptLanguage.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Accept-Language\u4e0d\u80fd\u7a7a!");
        }
        return normalized;
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }

    public static class RequestOptionsBuilder {
        private String uri;
        private String version;
        private String signType = "MD5";
        private String apiKey = Jeepay.apiKey;
        private int connectTimeout = Jeepay.getConnectTimeout();
        private int readTimeout = Jeepay.getReadTimeout();
        private int maxNetworkRetries = Jeepay.getMaxNetworkRetries();
        private String acceptLanguage = Jeepay.getAcceptLanguage();

        public String getUri() {
            return this.uri;
        }

        public RequestOptionsBuilder setUri(String uri) {
            this.uri = RequestOptions.normalizeApiUri(uri);
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public RequestOptionsBuilder setVersion(String version) {
            this.version = version;
            return this;
        }

        public String getSignType() {
            return this.signType;
        }

        public RequestOptionsBuilder setSignType(String signType) {
            this.signType = signType;
            return this;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = RequestOptions.normalizeApiKey(apiKey);
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.apiKey = null;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public RequestOptionsBuilder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public RequestOptionsBuilder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public int getMaxNetworkRetries() {
            return this.maxNetworkRetries;
        }

        public RequestOptionsBuilder setMaxNetworkRetries(int maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        public String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public RequestOptionsBuilder setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = RequestOptions.normalizeAcceptLanguage(acceptLanguage);
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(RequestOptions.normalizeApiUri(this.uri), this.version, this.signType, RequestOptions.normalizeApiKey(this.apiKey), this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.acceptLanguage);
        }
    }
}

