/*
 * Decompiled with CFR 0.152.
 */
package com.jeequan.jeepay.net;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jeequan.jeepay.exception.APIException;
import com.jeequan.jeepay.exception.InvalidRequestException;
import com.jeequan.jeepay.exception.JeepayException;
import com.jeequan.jeepay.net.APIJeepayRequest;
import com.jeequan.jeepay.net.APIJeepayResponse;
import com.jeequan.jeepay.net.HttpClient;
import com.jeequan.jeepay.net.HttpURLConnectionClient;
import com.jeequan.jeepay.request.JeepayRequest;
import com.jeequan.jeepay.response.JeepayResponse;
import com.jeequan.jeepay.util.JSONWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APIResource {
    private static final Logger _log = LoggerFactory.getLogger(APIResource.class);
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static HttpClient httpClient = new HttpURLConnectionClient();

    public static Class<?> getSelfClass() {
        return APIResource.class;
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    public <T extends JeepayResponse> T execute(JeepayRequest<T> request, RequestMethod method, String url) throws JeepayException {
        String jsonParam = new JSONWriter().write(request.getBizModel(), true);
        JSONObject params = JSONObject.parseObject((String)jsonParam);
        request.getRequestOptions();
        APIJeepayRequest apiJeepayRequest = new APIJeepayRequest(method, url, (Map<String, Object>)params, request.getRequestOptions());
        if (_log.isDebugEnabled()) {
            _log.debug("Jeepay_SDK_REQ\uff1aurl={}, data={}", (Object)apiJeepayRequest.getUrl(), (Object)JSONObject.toJSONString(apiJeepayRequest.getParams()));
        }
        APIJeepayResponse response = httpClient.requestWithRetries(apiJeepayRequest);
        int responseCode = response.getResponseCode();
        String responseBody = response.getResponseBody();
        if (_log.isDebugEnabled()) {
            _log.debug("Jeepay_SDK_RES\uff1acode={}, body={}", (Object)responseCode, (Object)responseBody);
        }
        if (responseCode != 200) {
            APIResource.handleAPIError(response);
        }
        JeepayResponse resource = null;
        try {
            resource = (JeepayResponse)JSONObject.parseObject((String)responseBody, request.getResponseClass());
        }
        catch (JSONException e) {
            APIResource.raiseMalformedJsonError(responseBody, responseCode);
        }
        return (T)resource;
    }

    private static void handleAPIError(APIJeepayResponse response) throws JeepayException {
        String rBody = response.getResponseBody();
        int rCode = response.getResponseCode();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSONObject.parseObject((String)rBody);
        }
        catch (JSONException e) {
            APIResource.raiseMalformedJsonError(rBody, rCode);
        }
        if (rCode == 404) {
            throw new InvalidRequestException(jsonObject.getString("status") + ", " + jsonObject.getString("error") + ", " + jsonObject.getString("path"), rCode, null);
        }
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode) throws APIException {
        throw new APIException(String.format("Invalid response object from API: %s. (HTTP response code was %d)", responseBody, responseCode), null, null, responseCode, null);
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

