/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.android.firebase.database.auth;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.database.DatabaseReference;
import com.jdroid.android.firebase.database.FirebaseDatabaseRepository;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.utils.LoggerUtils;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;

public abstract class FirebaseAuthenticationStrategy
implements FirebaseAuth.AuthStateListener,
OnFailureListener {
    private static final Logger LOGGER = LoggerUtils.getLogger(FirebaseDatabaseRepository.class);
    private CountDownLatch countDownLatch;

    public final void authenticate(DatabaseReference databaseReference) {
        this.countDownLatch = new CountDownLatch(1);
        this.doAuthenticate(databaseReference);
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    protected abstract void doAuthenticate(DatabaseReference var1);

    public void onFailure(@NonNull Exception e) {
        this.getCountDownLatch().countDown();
        this.doOnAuthenticationError(e);
    }

    protected void doOnAuthenticationError(Exception e) {
        throw new UnexpectedException((Throwable)e);
    }

    public void onAuthStateChanged(@NonNull FirebaseAuth firebaseAuth) {
        if (firebaseAuth.getCurrentUser() != null) {
            LOGGER.debug("AuthStateChanged", (Object)("User is signed in with uid: " + firebaseAuth.getCurrentUser().getUid()));
            this.getCountDownLatch().countDown();
            this.doOnAuthenticated(firebaseAuth);
        } else {
            Log.i((String)"AuthStateChanged", (String)"No user is signed in.");
        }
    }

    protected void doOnAuthenticated(FirebaseAuth firebaseAuth) {
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }
}

