/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.android.firebase.database;

import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.Query;
import com.google.firebase.database.ValueEventListener;
import com.jdroid.android.firebase.database.FirebaseDatabaseCompletionListener;
import com.jdroid.android.firebase.database.FirebaseDatabaseValueEventListener;
import com.jdroid.android.firebase.database.auth.FirebaseAuthenticationStrategy;
import com.jdroid.java.collections.Lists;
import com.jdroid.java.domain.Entity;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.repository.Repository;
import com.jdroid.java.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public abstract class FirebaseDatabaseRepository<T extends Entity>
implements Repository<T> {
    private static final Logger LOGGER = LoggerUtils.getLogger(FirebaseDatabaseRepository.class);
    private FirebaseAuthenticationStrategy firebaseAuthenticationStrategy = this.createFirebaseAuthenticationStrategy();

    protected FirebaseAuthenticationStrategy createFirebaseAuthenticationStrategy() {
        return null;
    }

    protected abstract String getPath();

    protected abstract Class<T> getEntityClass();

    protected DatabaseReference createDatabaseReference() {
        DatabaseReference databaseReference = FirebaseDatabase.getInstance().getReference();
        if (this.firebaseAuthenticationStrategy != null) {
            this.firebaseAuthenticationStrategy.authenticate(databaseReference);
        }
        databaseReference = databaseReference.child(this.getPath());
        return databaseReference;
    }

    public T get(String id) {
        DatabaseReference databaseReference = this.createDatabaseReference();
        databaseReference = databaseReference.child(id);
        FirebaseDatabaseValueEventListener listener = new FirebaseDatabaseValueEventListener();
        databaseReference.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        Entity result = (Entity)listener.getDataSnapshot().getValue(this.getEntityClass());
        LOGGER.info("Retrieved object from database of path: " + this.getPath() + ". [ " + result + " ]");
        return (T)result;
    }

    public void add(T item) {
        DatabaseReference databaseReference = this.createDatabaseReference();
        databaseReference = item.getId() != null ? databaseReference.child(item.getId()) : databaseReference.push();
        FirebaseDatabaseCompletionListener listener = new FirebaseDatabaseCompletionListener();
        databaseReference.setValue(item, (DatabaseReference.CompletionListener)listener);
        listener.waitOperation();
        if (item.getId() == null) {
            this.addIdField(databaseReference.getKey());
        }
        item.setId(databaseReference.getKey());
        LOGGER.info("Stored object in database: " + item);
    }

    private void addIdField(String id) {
        DatabaseReference databaseReference = this.createDatabaseReference();
        databaseReference = databaseReference.child(id);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        FirebaseDatabaseCompletionListener listener = new FirebaseDatabaseCompletionListener();
        databaseReference.updateChildren(map, (DatabaseReference.CompletionListener)listener);
        listener.waitOperation();
    }

    public void addAll(Collection<T> items) {
        for (Entity each : items) {
            this.add(each);
        }
    }

    public void update(T item) {
        if (item.getId() == null) {
            throw new UnexpectedException("Item with null id can not be updated");
        }
        this.add(item);
    }

    public List<T> findByField(String fieldName, Object ... values) {
        DatabaseReference databaseReference = this.createDatabaseReference();
        Query query = databaseReference.orderByChild(fieldName);
        if (values == null) {
            throw new UnexpectedException("Null value type not supported");
        }
        if (values.length > 1) {
            throw new UnexpectedException("Just one value is supported");
        }
        Object value = values[0];
        if (value instanceof String) {
            query = query.equalTo((String)value);
        } else if (value instanceof Long) {
            query = query.equalTo((double)((Long)value).longValue());
        } else if (value instanceof Double) {
            query = query.equalTo(((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            query = query.equalTo((double)((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            query = query.equalTo(((Boolean)value).booleanValue());
        } else {
            throw new UnexpectedException("Value type not supported");
        }
        FirebaseDatabaseValueEventListener listener = new FirebaseDatabaseValueEventListener();
        query.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        ArrayList results = Lists.newArrayList();
        for (DataSnapshot eachSnapshot : listener.getDataSnapshot().getChildren()) {
            results.add(eachSnapshot.getValue(this.getEntityClass()));
        }
        LOGGER.info("Retrieved objects [" + results.size() + "] from database of path: " + this.getPath() + " field: " + fieldName);
        return results;
    }

    public List<T> getAll() {
        DatabaseReference databaseReference = this.createDatabaseReference();
        FirebaseDatabaseValueEventListener listener = new FirebaseDatabaseValueEventListener();
        databaseReference.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        ArrayList results = Lists.newArrayList();
        for (DataSnapshot eachSnapshot : listener.getDataSnapshot().getChildren()) {
            results.add(eachSnapshot.getValue(this.getEntityClass()));
        }
        LOGGER.info("Retrieved all objects [" + results.size() + "] from path: " + this.getPath());
        return results;
    }

    public List<T> getAll(List<String> ids) {
        DatabaseReference databaseReference = this.createDatabaseReference();
        FirebaseDatabaseValueEventListener listener = new FirebaseDatabaseValueEventListener();
        databaseReference.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        ArrayList results = Lists.newArrayList();
        for (DataSnapshot eachSnapshot : listener.getDataSnapshot().getChildren()) {
            Entity each = (Entity)eachSnapshot.getValue(this.getEntityClass());
            if (!ids.contains(each.getId())) continue;
            results.add(each);
        }
        LOGGER.info("Retrieved all objects [" + results.size() + "] from path: " + this.getPath() + " and ids: " + ids);
        return results;
    }

    public void remove(T item) {
        this.remove(item.getId());
    }

    public void removeAll() {
        this.innerRemove(null);
    }

    public void removeAll(Collection<T> items) {
        for (Entity each : items) {
            this.remove(each);
        }
    }

    public void remove(String id) {
        if (id != null) {
            this.innerRemove(id);
        }
    }

    private void innerRemove(String id) {
        DatabaseReference databaseReference = this.createDatabaseReference();
        if (id != null) {
            databaseReference = databaseReference.child(id);
        }
        FirebaseDatabaseCompletionListener listener = new FirebaseDatabaseCompletionListener();
        databaseReference.removeValue((DatabaseReference.CompletionListener)listener);
        listener.waitOperation();
        LOGGER.trace("Deleted object in database: with id: " + id);
    }

    public Boolean isEmpty() {
        return this.getSize() == 0L;
    }

    public Long getSize() {
        DatabaseReference databaseReference = this.createDatabaseReference();
        FirebaseDatabaseValueEventListener listener = new FirebaseDatabaseValueEventListener();
        databaseReference.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        return listener.getDataSnapshot().getChildrenCount();
    }

    public void replaceAll(Collection<T> items) {
        for (Entity each : items) {
            this.update(each);
        }
    }

    public T getUniqueInstance() {
        List<T> results = this.getAll();
        if (!results.isEmpty()) {
            return (T)((Entity)results.get(0));
        }
        return null;
    }
}

