/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import java.io.IOException;
import java.net.URL;
import javax.json.JsonObject;

@Immutable
public interface RepoCommit
extends Comparable<RepoCommit>,
JsonReadable {
    public Repo repo();

    public String sha();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements RepoCommit {
        private final transient RepoCommit commit;
        private final transient SmartJson jsn;

        public Smart(RepoCommit cmt) {
            this.commit = cmt;
            this.jsn = new SmartJson(cmt);
        }

        public String message() throws IOException {
            return this.jsn.json().getJsonObject("commit").getString("message");
        }

        public URL url() throws IOException {
            return new URL(this.jsn.text("url"));
        }

        public String author() throws IOException {
            return this.jsn.json().getJsonObject("commit").getJsonObject("author").getString("name");
        }

        public boolean isVerified() throws IOException {
            return this.jsn.json().getJsonObject("commit").getJsonObject("verification").getBoolean("verified");
        }

        @Override
        public Repo repo() {
            return this.commit.repo();
        }

        @Override
        public String sha() {
            return this.commit.sha();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.commit.json();
        }

        @Override
        public int compareTo(RepoCommit obj) {
            return this.commit.compareTo(obj);
        }

        public String toString() {
            return "RepoCommit.Smart(commit=" + this.commit + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            RepoCommit this$commit = this.commit;
            RepoCommit other$commit = other.commit;
            if (this$commit == null ? other$commit != null : !this$commit.equals(other$commit)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RepoCommit $commit = this.commit;
            result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

