/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Gists;
import com.jcabi.github.Github;
import com.jcabi.github.Gitignores;
import com.jcabi.github.Limits;
import com.jcabi.github.Markdown;
import com.jcabi.github.Organizations;
import com.jcabi.github.Repo;
import com.jcabi.github.Repos;
import com.jcabi.github.Search;
import com.jcabi.github.Users;
import com.jcabi.github.mock.MkGists;
import com.jcabi.github.mock.MkGitignores;
import com.jcabi.github.mock.MkLimits;
import com.jcabi.github.mock.MkMarkdown;
import com.jcabi.github.mock.MkOrganizations;
import com.jcabi.github.mock.MkRepos;
import com.jcabi.github.mock.MkSearch;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUsers;
import com.jcabi.http.Request;
import com.jcabi.http.request.FakeRequest;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.RandomStringUtils;

@Immutable
@Loggable(value=1)
public final class MkGithub
implements Github {
    private final transient MkStorage storage;
    private final transient String self;

    public MkGithub() throws IOException {
        this("jeff");
    }

    public MkGithub(String login) throws IOException {
        this(new MkStorage.Synced(new MkStorage.InFile()), login);
    }

    public MkGithub(MkStorage stg, String login) {
        this.storage = stg;
        this.self = login;
    }

    public String toString() {
        return this.storage.toString();
    }

    @Override
    public Request entry() {
        return new FakeRequest().withBody("{}").withStatus(200);
    }

    @Override
    public Repos repos() {
        try {
            return new MkRepos(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Gists gists() {
        try {
            return new MkGists(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Users users() {
        try {
            return new MkUsers(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Organizations organizations() {
        try {
            return new MkOrganizations(this.storage);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Limits limits() {
        return new MkLimits(this.storage, this.self);
    }

    @Override
    public JsonObject meta() {
        return Json.createObjectBuilder().add("hooks", (JsonValue)Json.createArrayBuilder().build()).add("git", (JsonValue)Json.createArrayBuilder().build()).build();
    }

    @Override
    public Search search() {
        return new MkSearch(this.storage, this.self);
    }

    @Override
    public Gitignores gitignores() {
        return new MkGitignores(this);
    }

    @Override
    public JsonObject emojis() {
        return Json.createObjectBuilder().add("+1", "http://locahost/up").add("-1", "http://locahost/down").build();
    }

    @Override
    public Markdown markdown() {
        return new MkMarkdown(this);
    }

    public Github relogin(String login) {
        return new MkGithub(this.storage, login);
    }

    public Repo randomRepo() throws IOException {
        return this.repos().create(new Repos.RepoCreate(RandomStringUtils.randomAlphanumeric((int)20), true));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkGithub)) {
            return false;
        }
        MkGithub other = (MkGithub)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

