/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Pull;
import com.jcabi.github.PullComment;
import com.jcabi.github.PullComments;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtPullComment;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtPullComments
implements PullComments {
    private final transient Request entry;
    private final transient Request request;
    private final transient Pull owner;

    RtPullComments(Request req, Pull pull) {
        this.entry = req;
        this.owner = pull;
        this.request = this.entry.uri().path("/repos").path(pull.repo().coordinates().user()).path(pull.repo().coordinates().repo()).path("/pulls").path(Integer.toString(pull.number())).path("/comments").back();
    }

    @Override
    public Pull pull() {
        return this.owner;
    }

    @Override
    public PullComment get(int number) {
        return new RtPullComment(this.entry, this.owner, number);
    }

    @Override
    public Iterable<PullComment> iterate(Map<String, String> params) {
        return new RtPagination<PullComment>(this.request.uri().queryParams(params).back(), value -> this.get(value.getInt("id")));
    }

    @Override
    public Iterable<PullComment> iterate(int number, Map<String, String> params) {
        Request newreq = this.entry.uri().path("/repos").path(this.owner.repo().coordinates().user()).path(this.owner.repo().coordinates().repo()).path("/pulls").path(String.valueOf(number)).path("/comments").back();
        return new RtPagination<PullComment>(newreq.uri().queryParams(params).back(), value -> this.get(value.getInt("id")));
    }

    @Override
    public PullComment post(String body, String commit, String path, int position) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("body", body).add("commit_id", commit).add("path", path).add("position", position).build();
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("id"));
    }

    @Override
    public PullComment reply(String body, int comment) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("body", body).add("in_reply_to", comment).build();
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("id"));
    }

    @Override
    public void remove(int number) throws IOException {
        ((RestResponse)this.request.uri().path(String.valueOf(number)).back().method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtPullComments)) {
            return false;
        }
        RtPullComments other = (RtPullComments)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Pull this$owner = this.owner;
        Pull other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Pull $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

