/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

@Immutable
public interface Repos {
    public Github github();

    public Repo create(RepoCreate var1) throws IOException;

    public Repo get(Coordinates var1);

    public void remove(Coordinates var1) throws IOException;

    public Iterable<Repo> iterate(String var1);

    public boolean exists(Coordinates var1) throws IOException;

    @Loggable(value=1)
    public static final class RepoCreate
    implements JsonReadable {
        private final transient String nam;
        private final transient boolean priv;
        private final transient String descr;
        private final transient String home;
        private final transient Optional<Boolean> init;
        private final transient String organization;

        public RepoCreate(String nme, boolean prvt) {
            this(nme, prvt, "", "", (Optional<Boolean>)Optional.absent(), "");
        }

        private RepoCreate(String nme, boolean prvt, String desc, String page, Optional<Boolean> auto, String org) {
            if (nme.isEmpty()) {
                throw new IllegalArgumentException("Name cannot be empty!");
            }
            this.nam = nme;
            this.priv = prvt;
            this.descr = desc;
            this.home = page;
            this.init = auto;
            this.organization = org;
        }

        public String name() {
            return this.nam;
        }

        public boolean isPrivate() {
            return this.priv;
        }

        public String description() {
            return this.descr;
        }

        public String homepage() {
            return this.home;
        }

        public Optional<Boolean> autoInit() {
            return this.init;
        }

        public String organization() {
            return this.organization;
        }

        public RepoCreate withName(String nme) {
            return new RepoCreate(nme, this.priv, this.descr, this.home, this.init, this.organization);
        }

        public RepoCreate withPrivacy(boolean privacy) {
            return new RepoCreate(this.nam, privacy, this.descr, this.home, this.init, this.organization);
        }

        public RepoCreate withDescription(String desc) {
            return new RepoCreate(this.nam, this.priv, desc, this.home, this.init, this.organization);
        }

        public RepoCreate withHomepage(String page) {
            return new RepoCreate(this.nam, this.priv, this.descr, page, this.init, this.organization);
        }

        public RepoCreate withAutoInit(Optional<Boolean> auto) {
            return new RepoCreate(this.nam, this.priv, this.descr, this.home, auto, this.organization);
        }

        public RepoCreate withAutoInit(boolean auto) {
            return new RepoCreate(this.nam, this.priv, this.descr, this.home, (Optional<Boolean>)Optional.of((Object)auto), this.organization);
        }

        public RepoCreate withOrganization(String org) {
            return new RepoCreate(this.nam, this.priv, this.descr, this.home, this.init, org);
        }

        @Override
        public JsonObject json() {
            JsonObjectBuilder builder = Json.createObjectBuilder().add("name", this.nam).add("description", this.descr).add("homepage", this.home).add("private", this.priv);
            if (this.init.isPresent()) {
                builder = builder.add("auto_init", ((Boolean)this.init.get()).booleanValue());
            }
            return builder.build();
        }

        public String toString() {
            return "Repos.RepoCreate(nam=" + this.nam + ", priv=" + this.priv + ", descr=" + this.descr + ", home=" + this.home + ", init=" + this.init + ", organization=" + this.organization + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepoCreate)) {
                return false;
            }
            RepoCreate other = (RepoCreate)o;
            if (this.priv != other.priv) {
                return false;
            }
            String this$nam = this.nam;
            String other$nam = other.nam;
            if (this$nam == null ? other$nam != null : !this$nam.equals(other$nam)) {
                return false;
            }
            String this$descr = this.descr;
            String other$descr = other.descr;
            if (this$descr == null ? other$descr != null : !this$descr.equals(other$descr)) {
                return false;
            }
            String this$home = this.home;
            String other$home = other.home;
            if (this$home == null ? other$home != null : !this$home.equals(other$home)) {
                return false;
            }
            Optional<Boolean> this$init = this.init;
            Optional<Boolean> other$init = other.init;
            return !(this$init == null ? other$init != null : !this$init.equals(other$init));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.priv ? 79 : 97);
            String $nam = this.nam;
            result = result * 59 + ($nam == null ? 43 : $nam.hashCode());
            String $descr = this.descr;
            result = result * 59 + ($descr == null ? 43 : $descr.hashCode());
            String $home = this.home;
            result = result * 59 + ($home == null ? 43 : $home.hashCode());
            Optional<Boolean> $init = this.init;
            result = result * 59 + ($init == null ? 43 : $init.hashCode());
            return result;
        }
    }
}

