/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.Limit;

@Immutable
public interface Limits {
    public static final String CORE = "core";
    public static final String SEARCH = "search";

    public Github github();

    public Limit get(String var1);

    @Immutable
    @Loggable(value=1)
    public static final class Throttled
    implements Limits {
        private final transient Limits origin;
        private final transient int max;

        public Throttled(Limits limits, int allowed) {
            this.origin = limits;
            this.max = allowed;
        }

        @Override
        public Github github() {
            return this.origin.github();
        }

        @Override
        public Limit get(String resource) {
            return new Limit.Throttled(this.origin.get(resource), this.max);
        }

        public String toString() {
            return "Limits.Throttled(origin=" + this.origin + ", max=" + this.max + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throttled)) {
                return false;
            }
            Throttled other = (Throttled)o;
            Limits this$origin = this.origin;
            Limits other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Limits $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }
}

