/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;

public interface Check {
    public boolean successful() throws IOException;

    public static enum Conclusion {
        ACTION_REQUIRED("action_required"),
        CANCELLED("cancelled"),
        FAILURE("failure"),
        NEUTRAL("neutral"),
        SUCCESS("success"),
        SKIPPED("skipped"),
        STALE("stale"),
        TIMED_OUT("timed_out");

        private final String conclusion;

        private Conclusion(String con) {
            this.conclusion = con;
        }

        public static Conclusion fromString(String value) {
            return Arrays.stream(Conclusion.values()).filter(stat -> stat.same(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid value %s for conclusion", value)));
        }

        public String value() {
            return this.conclusion;
        }

        boolean successful() {
            return this == SUCCESS;
        }

        boolean same(String value) {
            return this.conclusion.equals(value.toLowerCase(Locale.ROOT));
        }
    }

    public static enum Status {
        QUEUED("queued"),
        IN_PROGRESS("in_progress"),
        COMPLETED("completed");

        private final String status;

        private Status(String stat) {
            this.status = stat;
        }

        public String value() {
            return this.status;
        }

        public static Status fromString(String value) {
            return Arrays.stream(Status.values()).filter(stat -> stat.same(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid value %s for status", value)));
        }

        boolean finished() {
            return this == COMPLETED;
        }

        boolean same(String value) {
            return this.status.equals(value.toLowerCase(Locale.ROOT));
        }
    }
}

