/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.DeployKey;
import com.jcabi.github.DeployKeys;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkDeployKey;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import java.util.Collections;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkDeployKeys
implements DeployKeys {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkDeployKeys(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"deploykeys"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Iterable<DeployKey> iterate() {
        return Collections.emptyList();
    }

    @Override
    public DeployKey get(int number) {
        return new MkDeployKey(this.storage, number, this.repo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeployKey create(String title, String key) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(String.format("%s/deploykey/id/text()", this.xpath())).size();
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"deploykey").add((Object)"id").set((Object)String.valueOf(number)).up().add((Object)"title").set((Object)title).up().add((Object)"key").set((Object)key));
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/deploykeys", this.coords);
    }

    public String toString() {
        return "MkDeployKeys(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkDeployKeys)) {
            return false;
        }
        MkDeployKeys other = (MkDeployKeys)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

