/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Release;
import com.jcabi.github.Repo;
import com.jcabi.github.Smarts;
import java.io.IOException;

@Immutable
public interface Releases {
    public Repo repo();

    public Iterable<Release> iterate();

    public Release get(int var1);

    public Release create(String var1) throws IOException;

    public void remove(int var1) throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Releases {
        private final transient Releases releases;

        public Smart(Releases original) {
            this.releases = original;
        }

        @Override
        public Repo repo() {
            return this.releases.repo();
        }

        @Override
        public Iterable<Release> iterate() {
            return this.releases.iterate();
        }

        @Override
        public Release get(int number) {
            return this.releases.get(number);
        }

        @Override
        public Release create(String tag) throws IOException {
            return this.releases.create(tag);
        }

        @Override
        public void remove(int number) throws IOException {
            this.releases.remove(number);
        }

        public boolean exists(String tag) throws IOException {
            boolean exists = false;
            Smarts rels = new Smarts(this.iterate());
            for (Release.Smart rel : rels) {
                if (!rel.tag().equals(tag)) continue;
                exists = true;
                break;
            }
            return exists;
        }

        public Release find(String tag) throws IOException {
            Release.Smart found = null;
            Smarts rels = new Smarts(this.iterate());
            for (Release.Smart rel : rels) {
                if (!rel.tag().equals(tag)) continue;
                found = rel;
                break;
            }
            if (found == null) {
                throw new IllegalArgumentException(String.format("release not found by tag '%s'", tag));
            }
            return found;
        }

        public String toString() {
            return "Releases.Smart(releases=" + this.releases + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Releases this$releases = this.releases;
            Releases other$releases = other.releases;
            return !(this$releases == null ? other$releases != null : !this$releases.equals(other$releases));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Releases $releases = this.releases;
            result = result * 59 + ($releases == null ? 43 : $releases.hashCode());
            return result;
        }
    }
}

