/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Commit;
import com.jcabi.github.Coordinates;
import com.jcabi.github.MergeState;
import com.jcabi.github.Pull;
import com.jcabi.github.PullComments;
import com.jcabi.github.PullRef;
import com.jcabi.github.Repo;
import com.jcabi.github.RtCommit;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtPullComments;
import com.jcabi.github.RtPullRef;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Immutable
@Loggable(value=1)
final class RtPull
implements Pull {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;
    private final transient int num;

    RtPull(Request req, Repo repo, int number) {
        this.entry = req;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/pulls").path(Integer.toString(number)).back();
        this.owner = repo;
        this.num = number;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public Iterable<Commit> commits() {
        return new RtPagination<Commit>(this.request.uri().path("/commits").back(), object -> new RtCommit(this.entry, this.owner, object.getString("sha")));
    }

    @Override
    public Iterable<JsonObject> files() {
        return new RtPagination<JsonObject>(this.request.uri().path("/files").back(), RtPagination.COPYING);
    }

    @Override
    public void merge(String msg) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("commit_message", msg).build();
        this.merge((JsonStructure)json).assertStatus(200);
    }

    @Override
    public MergeState merge(String msg, String sha) throws IOException {
        MergeState mergeState;
        JsonObjectBuilder builder = Json.createObjectBuilder().add("commit_message", msg).add("sha", sha);
        RestResponse response = this.merge((JsonStructure)builder.build()).assertStatus(Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{200, 405, 409})));
        switch (response.status()) {
            case 200: {
                mergeState = MergeState.SUCCESS;
                break;
            }
            case 405: {
                mergeState = MergeState.NOT_MERGEABLE;
                break;
            }
            default: {
                mergeState = MergeState.BAD_HEAD;
            }
        }
        return mergeState;
    }

    @Override
    public PullComments comments() {
        return new RtPullComments(this.entry, this);
    }

    @Override
    public PullRef base() throws IOException {
        return new RtPullRef(this.owner.github(), this.json().getJsonObject("base"));
    }

    @Override
    public PullRef head() throws IOException {
        return new RtPullRef(this.owner.github(), this.json().getJsonObject("head"));
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public int compareTo(Pull pull) {
        return this.number() - pull.number();
    }

    private RestResponse merge(JsonStructure payload) throws IOException {
        return (RestResponse)this.request.uri().path("/merge").back().body().set(payload).back().method("PUT").fetch().as(RestResponse.class);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtPull)) {
            return false;
        }
        RtPull other = (RtPull)o;
        if (this.num != other.num) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.num;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

