/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Commit;
import com.jcabi.github.Github;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.SmartJson;
import com.jcabi.github.StringEnum;
import com.jcabi.github.User;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.json.JsonObject;

@Immutable
public interface Status
extends JsonReadable {
    public Commit commit();

    public int identifier();

    public String url();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Status {
        private final transient Status status;
        private final transient SmartJson jsn;

        public Smart(Status stat) {
            this.status = stat;
            this.jsn = new SmartJson(stat);
        }

        public State state() throws IOException {
            return State.forValue(this.jsn.text("state"));
        }

        public Optional<String> targetUrl() throws IOException {
            return Optional.fromNullable((Object)this.json().getString("target_url", null));
        }

        public String description() throws IOException {
            return this.json().getString("description", "");
        }

        public String context() throws IOException {
            return this.jsn.text("context");
        }

        public Date createdAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Date updatedAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("updated_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public User creator() throws IOException {
            return this.status.commit().repo().github().users().get(this.status.json().getJsonObject("creator").getString("login"));
        }

        @Override
        public int identifier() {
            return this.status.identifier();
        }

        @Override
        public String url() {
            return this.status.url();
        }

        @Override
        public Commit commit() {
            return this.status.commit();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.status.json();
        }

        public String toString() {
            return "Status.Smart(status=" + this.status + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Status this$status = this.status;
            Status other$status = other.status;
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Status $status = this.status;
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }

    public static enum State implements StringEnum
    {
        PENDING("pending"),
        SUCCESS("success"),
        ERROR("error"),
        FAILURE("failure");

        private final transient String state;

        private State(String stat) {
            this.state = stat;
        }

        @Override
        public String identifier() {
            return this.state;
        }

        public static State forValue(String ident) {
            return State.valueOf(ident.toUpperCase(Locale.ENGLISH));
        }
    }
}

