/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import com.jcabi.http.response.WebLinkingResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.json.JsonArray;
import javax.json.JsonValue;

@Immutable
public final class RtValuePagination<T, P extends JsonValue>
implements Iterable<T> {
    private final transient Mapping<T, P> map;
    private final transient Request entry;

    public RtValuePagination(Request req, Mapping<T, P> mpp) {
        this.entry = req;
        this.map = mpp;
    }

    public String toString() {
        return this.entry.uri().get().toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new Items<T, P>(this.entry, this.map);
    }

    public Request request() {
        return this.entry;
    }

    public Mapping<T, P> mapping() {
        return this.map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtValuePagination)) {
            return false;
        }
        RtValuePagination other = (RtValuePagination)o;
        Mapping<T, P> this$map = this.map;
        Mapping<T, P> other$map = other.map;
        if (this$map == null ? other$map != null : !this$map.equals(other$map)) {
            return false;
        }
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        return !(this$entry == null ? other$entry != null : !this$entry.equals(other$entry));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Mapping<T, P> $map = this.map;
        result = result * 59 + ($map == null ? 43 : $map.hashCode());
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        return result;
    }

    private static final class Items<X, P extends JsonValue>
    implements Iterator<X> {
        private final transient Mapping<X, P> mapping;
        private transient Request request;
        private transient Queue<P> objects;
        private transient boolean more = true;

        Items(Request entry, Mapping<X, P> mpp) {
            this.request = entry;
            this.mapping = mpp;
            this.objects = new LinkedList<P>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public X next() {
            Mapping<X, P> mapping = this.mapping;
            synchronized (mapping) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more elements in pagination, use #hasNext()");
                }
                return this.mapping.map((JsonValue)this.objects.remove());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("#remove()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Mapping<X, P> mapping = this.mapping;
            synchronized (mapping) {
                if ((this.objects == null || this.objects.isEmpty()) && this.more) {
                    try {
                        this.fetch();
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                return !this.objects.isEmpty();
            }
        }

        private void fetch() throws IOException {
            RestResponse response = ((RestResponse)this.request.fetch().as(RestResponse.class)).assertStatus(200);
            WebLinkingResponse.Link link = (WebLinkingResponse.Link)((WebLinkingResponse)response.as(WebLinkingResponse.class)).links().get("next");
            if (link == null) {
                this.more = false;
            } else {
                this.request = response.jump(link.uri());
            }
            JsonArray arr = ((JsonResponse)response.as(JsonResponse.class)).json().readArray();
            LinkedList<P> list = new LinkedList<P>();
            for (JsonValue value : arr) {
                list.add(value);
            }
            this.objects = list;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Items)) {
                return false;
            }
            Items other = (Items)o;
            if (this.more != other.more) {
                return false;
            }
            Mapping<X, P> this$mapping = this.mapping;
            Mapping<X, P> other$mapping = other.mapping;
            if (this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping)) {
                return false;
            }
            Request this$request = this.request;
            Request other$request = other.request;
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            Queue<P> this$objects = this.objects;
            Queue<P> other$objects = other.objects;
            return !(this$objects == null ? other$objects != null : !this$objects.equals(other$objects));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.more ? 79 : 97);
            Mapping<X, P> $mapping = this.mapping;
            result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
            Request $request = this.request;
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            Queue<P> $objects = this.objects;
            result = result * 59 + ($objects == null ? 43 : $objects.hashCode());
            return result;
        }
    }

    @Immutable
    public static interface Mapping<X, P extends JsonValue> {
        public X map(P var1);
    }
}

