/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.CommitsComparison;
import com.jcabi.github.Coordinates;
import com.jcabi.github.RepoCommit;
import com.jcabi.github.RepoCommits;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.MkCommitsComparison;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkRepoCommit;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Map;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkRepoCommits
implements RepoCommits {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkRepoCommits(MkStorage stg, String login, Coordinates repo) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = repo;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"commits"));
    }

    @Override
    public Iterable<RepoCommit> iterate(Map<String, String> params) {
        return new MkIterable<RepoCommit>(this.storage, String.format("%s/commit", this.xpath()), new MkIterable.Mapping<RepoCommit>(){

            @Override
            public RepoCommit map(XML xml) {
                return MkRepoCommits.this.get((String)xml.xpath("sha/text()").get(0));
            }
        });
    }

    @Override
    public RepoCommit get(String sha) {
        return new MkRepoCommit(this.storage, new MkRepo(this.storage, this.self, this.coords), sha);
    }

    @Override
    public CommitsComparison compare(String base, String head) {
        return new MkCommitsComparison(this.storage, this.self, this.coords);
    }

    @Override
    public String diff(String base, String head) {
        return String.format("%s%sindex %s..%s", "diff --git a/README b/README", System.getProperty("line.separator"), base, head);
    }

    @Override
    public String patch(String base, String head) {
        return StringUtils.join((Object[])new String[]{String.format("From %s Mon Sep 17 00:00:00 2001\n", head), "From: Some Author <some_author@email.com>\n", "Date: Tue, 11 Feb 2014 20:33:49 +0200\n", "Subject: Some subject\n", "\n", "---\n", " .../java/com/jcabi/github/CommitsComparison.java   |   6 +-\n", " src/main/java/com/jcabi/github/RepoCommit.java     | 131 +++++", "++++++++++++++++\n", " src/main/java/com/jcabi/github/RepoCommits.java    |  15 +--\n", " src/main/java/com/jcabi/github/RtRepoCommit.java   | 110 +++++", "++++++++++++\n", " src/main/java/com/jcabi/github/RtRepoCommits.java  |   6 +-\n", " .../java/com/jcabi/github/mock/MkRepoCommits.java  |   6 +-\n", " src/test/java/com/jcabi/github/RepoCommitTest.java |  84 +++++", "++++++++\n", " .../java/com/jcabi/github/RtRepoCommitsITCase.java |   7 +-\n", " 8 files changed, 346 insertions(+), 19 deletions(-)\n", " create mode 100644 src/main/java/com/jcabi/github/", "RepoCommit.java\n", " create mode 100644 src/main/java/com/jcabi/github/RtRepoCommit", ".java\n", " create mode 100644 src/test/java/com/jcabi/github/", "RepoCommitTest.java"});
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/commits", this.coords);
    }

    public String toString() {
        return "MkRepoCommits(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkRepoCommits)) {
            return false;
        }
        MkRepoCommits other = (MkRepoCommits)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

