/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.PublicKey;
import com.jcabi.github.User;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import com.jcabi.xml.XML;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class MkPublicKey
implements PublicKey {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient int num;

    MkPublicKey(MkStorage stg, String login, int number) {
        this.storage = stg;
        this.self = login;
        this.num = number;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public User user() {
        try {
            return new MkUser(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int number() {
        return this.num;
    }

    private String xpath() {
        return String.format("/github/users/user[login='%s']/keys/key[id='%d']", this.self, this.num);
    }

    public String toString() {
        return "MkPublicKey(storage=" + this.storage + ", self=" + this.self + ", num=" + this.num + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPublicKey)) {
            return false;
        }
        MkPublicKey other = (MkPublicKey)o;
        if (this.num != other.num) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.num;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

