/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Notifications;
import com.jcabi.github.PublicKeys;
import com.jcabi.github.User;
import com.jcabi.github.UserEmails;
import com.jcabi.github.UserOrganizations;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkGitHub;
import com.jcabi.github.mock.MkNotifications;
import com.jcabi.github.mock.MkPublicKeys;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUserEmails;
import com.jcabi.github.mock.MkUserOrganizations;
import com.jcabi.xml.XML;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class MkUser
implements User {
    private final transient MkStorage storage;
    private final transient String self;

    MkUser(MkStorage stg, String login) {
        this.storage = stg;
        this.self = login;
    }

    @Override
    public GitHub github() {
        return new MkGitHub(this.storage, this.self);
    }

    @Override
    public String login() {
        return this.self;
    }

    @Override
    public UserOrganizations organizations() {
        try {
            return new MkUserOrganizations(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PublicKeys keys() {
        try {
            return new MkPublicKeys(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public UserEmails emails() {
        try {
            return new MkUserEmails(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Notifications notifications() {
        return new MkNotifications(this.storage, this.xpath().concat("/notifications/notification"));
    }

    @Override
    public void markAsRead(Date lastread) throws IOException {
        List ids = this.storage.xml().nodes(this.xpath().concat(String.format("/notifications/notification[date <= %s]/id", lastread.getTime())));
        JsonPatch json = new JsonPatch(this.storage);
        JsonObject read = Json.createObjectBuilder().add("read", true).build();
        for (XML nid : ids) {
            json.patch(this.xpath().concat(String.format("/notifications/notification[id = %s]", nid.xpath("text()").get(0))), read);
        }
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkUser other = (MkUser)obj;
            result = this.storage.equals(other.storage) && this.self.equals(other.self);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.self.hashCode();
        return result;
    }

    private String xpath() {
        return String.format("/github/users/user[login='%s']", this.self);
    }

    @Generated
    public String toString() {
        return "MkUser(storage=" + this.storage + ", self=" + this.self + ")";
    }
}

