/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.ReleaseAssets;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkReleaseAssets;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkRelease
implements Release {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int release;

    MkRelease(MkStorage stg, String login, Coordinates rep, int number) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.release = number;
    }

    @Override
    public int number() {
        return this.release;
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public ReleaseAssets assets() {
        try {
            return new MkReleaseAssets(this.storage, this.self, this.coords, this.release);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public void delete() throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).strict(1).remove());
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkRelease other = (MkRelease)obj;
            result = this.release == other.release && this.storage.equals(other.storage) && this.coords.equals(other.coords);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.coords.hashCode();
        result = 31 * result + this.release;
        return result;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/releases/release[id='%d']", this.coords, this.release);
    }

    @Generated
    public String toString() {
        return "MkRelease(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", release=" + this.release + ")";
    }
}

