/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.PublicKey;
import com.jcabi.github.PublicKeys;
import com.jcabi.github.User;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkPublicKey;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import java.io.IOException;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkPublicKeys
implements PublicKeys {
    private static final String KEY_ID_TEXT_PATH = "/key/id/text()";
    private final transient MkStorage storage;
    private final transient String self;

    MkPublicKeys(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.self = login;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.userXpath()).addIf((Object)"keys"));
    }

    @Override
    public User user() {
        return new MkUser(this.storage, this.self);
    }

    @Override
    public Iterable<PublicKey> iterate() {
        return new MkIterable<PublicKey>(this.storage, this.xpath().concat("/key"), xml -> this.get(Integer.parseInt((String)xml.xpath("id/text()").get(0))));
    }

    @Override
    public PublicKey get(int number) {
        return new MkPublicKey(this.storage, this.self, number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicKey create(String title, String key) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(this.xpath().concat(KEY_ID_TEXT_PATH)).size();
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"key").add((Object)"id").set((Object)String.valueOf(number)).up().add((Object)"title").set((Object)title).up().add((Object)"key").set((Object)key));
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    @Override
    public void remove(int number) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath().concat(String.format("/key[id='%d']", number))).remove());
    }

    private String userXpath() {
        return String.format("/github/users/user[login='%s']", this.self);
    }

    private String xpath() {
        return String.format("%s/keys", this.userXpath());
    }

    @Generated
    public String toString() {
        return "MkPublicKeys(storage=" + this.storage + ", self=" + this.self + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPublicKeys)) {
            return false;
        }
        MkPublicKeys other = (MkPublicKeys)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

