/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Fork;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class MkFork
implements Fork {
    private final transient MkStorage storage;
    private final transient Coordinates coords;
    private final transient int num;

    MkFork(MkStorage stg, int number, Coordinates repo) {
        this.storage = stg;
        this.num = number;
        this.coords = repo;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkFork other = (MkFork)obj;
            result = this.num == other.num && this.storage.equals(other.storage) && this.coords.equals(other.coords);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.coords.hashCode();
        result = 31 * result + this.num;
        return result;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/forks/fork[id='%d']", this.coords, this.num);
    }

    @Generated
    public String toString() {
        return "MkFork(storage=" + this.storage + ", coords=" + this.coords + ", num=" + this.num + ")";
    }
}

